/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.node;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TConfigNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TDataNodeConfiguration;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.commons.cluster.NodeType;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.rpc.TSStatusCode;

public class ClusterNodeStartUtils {
    private static final String CLUSTER_NAME = ConfigNodeDescriptor.getInstance().getConf().getClusterName();
    private static final String POSSIBLE_SOLUTIONS = " Possible solutions are as follows:\r\n";
    public static final TSStatus ACCEPT_NODE_REGISTRATION = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()).setMessage("Accept Node registration.");
    public static final TSStatus ACCEPT_NODE_RESTART = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()).setMessage("Accept Node restart.");

    public static TSStatus confirmNodeRegistration(NodeType nodeType, String clusterName, Object nodeLocation, ConfigManager configManager) {
        List<TEndPoint> conflictEndPoints;
        String CONF_FILE_NAME = NodeType.ConfigNode.equals((Object)nodeType) ? "iotdb-confignode.properties" : "iotdb-datanode.properties";
        TSStatus status = new TSStatus();
        if (!CLUSTER_NAME.equals(clusterName)) {
            status.setCode(TSStatusCode.REJECT_NODE_START.getStatusCode());
            status.setMessage(String.format("Reject %s start. Because the ClusterName of the current %s and the target cluster are inconsistent. ClusterName of the current Node: %s, ClusterName of the target cluster: %s. Possible solutions are as follows:\r\n\t1. Change the target_config_node_list parameter in %s to join the correct cluster.\n\t2. Change the cluster_name parameter in %s to match the target cluster", nodeType.getNodeType(), nodeType.getNodeType(), clusterName, CLUSTER_NAME, CONF_FILE_NAME, CONF_FILE_NAME));
            return status;
        }
        switch (nodeType) {
            case ConfigNode: {
                conflictEndPoints = ClusterNodeStartUtils.checkConflictTEndPointForNewConfigNode((TConfigNodeLocation)nodeLocation, configManager.getNodeManager().getRegisteredConfigNodes());
                break;
            }
            default: {
                conflictEndPoints = ClusterNodeStartUtils.checkConflictTEndPointForNewDataNode((TDataNodeLocation)nodeLocation, configManager.getNodeManager().getRegisteredDataNodes());
            }
        }
        if (!conflictEndPoints.isEmpty()) {
            status.setCode(TSStatusCode.REJECT_NODE_START.getStatusCode());
            status.setMessage(String.format("Reject %s registration. Because the following ip:port: %s of the current %s is conflicted with other registered Nodes in the cluster. Possible solutions are as follows:\r\n\t1. Use SQL: \"show cluster details\" to find out the conflict Nodes. Remove them and retry start.\n\t2. Change the conflict ip:port configurations in %s file and retry start.", nodeType.getNodeType(), conflictEndPoints, nodeType.getNodeType(), CONF_FILE_NAME));
            return status;
        }
        return ACCEPT_NODE_REGISTRATION;
    }

    public static TSStatus confirmNodeRestart(NodeType nodeType, String clusterName, int nodeId, Object nodeLocation, ConfigManager configManager) {
        boolean isTEndPointUpdated;
        boolean isNodeAlive;
        TConfigNodeLocation matchedNodeLocation;
        String CONF_FILE_NAME = NodeType.ConfigNode.equals((Object)nodeType) ? "iotdb-confignode.properties" : "iotdb-datanode.properties";
        TSStatus status = new TSStatus();
        if (!CLUSTER_NAME.equals(clusterName)) {
            status.setCode(TSStatusCode.REJECT_NODE_START.getStatusCode());
            status.setMessage(String.format("Reject %s restart. Because the ClusterName of the current %s and the target cluster are inconsistent. ClusterName of the current Node: %s, ClusterName of the target cluster: %s. Possible solutions are as follows:\r\n\t1. Change the target_config_node_list parameter in %s to join the correct cluster.\n\t2. Change the cluster_name parameter in %s to match the target cluster", nodeType.getNodeType(), nodeType.getNodeType(), clusterName, CLUSTER_NAME, CONF_FILE_NAME, CONF_FILE_NAME));
            return status;
        }
        if (nodeId < 0) {
            status.setCode(TSStatusCode.REJECT_NODE_START.getStatusCode());
            status.setMessage(String.format("Reject %s restart. Because the nodeId of the current %s is %d. Possible solutions are as follows:\r\n\t1. Delete \"data\" dir and retry.", nodeType.getNodeType(), nodeType.getNodeType(), nodeId));
            return status;
        }
        switch (nodeType) {
            case ConfigNode: {
                matchedNodeLocation = ClusterNodeStartUtils.matchRegisteredConfigNode((TConfigNodeLocation)nodeLocation, configManager.getNodeManager().getRegisteredConfigNodes());
                break;
            }
            default: {
                matchedNodeLocation = ClusterNodeStartUtils.matchRegisteredDataNode((TDataNodeLocation)nodeLocation, configManager.getNodeManager().getRegisteredDataNodes());
            }
        }
        if (matchedNodeLocation == null) {
            status.setCode(TSStatusCode.REJECT_NODE_START.getStatusCode());
            status.setMessage(String.format("Reject %s restart. Because there are no corresponding %s(whose nodeId=%d) in the cluster. Possible solutions are as follows:\r\n\t1. Maybe you've already removed the current %s(whose nodeId=%d). Please delete the useless 'data' dir and retry start.", nodeType.getNodeType(), nodeType.getNodeType(), nodeId, nodeType.getNodeType(), nodeId));
            return status;
        }
        NodeStatus nodeStatus = configManager.getNodeManager().getNodeStatusByNodeId(nodeId);
        boolean bl = isNodeAlive = nodeStatus != null && !NodeStatus.Unknown.equals((Object)nodeStatus);
        if (isNodeAlive) {
            status.setCode(TSStatusCode.REJECT_NODE_START.getStatusCode());
            status.setMessage(String.format("Reject %s restart. Because there already exists an alive Node with the same nodeId=%d in the target cluster. Possible solutions are as follows:\r\n\t1. Maybe you've just shutdown this Node recently. Please wait about %s for the ConfigNode-leader to mark this Node as Unknown before retry start. You can use SQL \"show cluster details\" to find out this Node's status.\n\t2. Maybe you start this Node by copying the 'data' dir of another alive Node. Please delete 'data' dir and retry start.", nodeType.getNodeType(), nodeId, "20s"));
            return status;
        }
        switch (nodeType) {
            case ConfigNode: {
                isTEndPointUpdated = ClusterNodeStartUtils.isTEndPointsOfTConfigNodeLocationUpdated((TConfigNodeLocation)nodeLocation, matchedNodeLocation);
                break;
            }
            default: {
                isTEndPointUpdated = ClusterNodeStartUtils.isTEndPointsOfTDataNodeLocationUpdated((TDataNodeLocation)nodeLocation, (TDataNodeLocation)matchedNodeLocation);
            }
        }
        if (isTEndPointUpdated) {
            status.setCode(TSStatusCode.REJECT_NODE_START.getStatusCode());
            status.setMessage(String.format("Reject %s restart. Because some TEndPoints of this %s have been changed. Possible solutions are as follows:\r\n\t1. Please delete 'data' dir and retry start. This Node will be registered as a new Node, so don't forget to remove the old one.", nodeType.getNodeType(), nodeType.getNodeType()));
            return status;
        }
        return ACCEPT_NODE_RESTART;
    }

    public static List<TEndPoint> checkConflictTEndPointForNewConfigNode(TConfigNodeLocation newConfigNodeLocation, List<TConfigNodeLocation> registeredConfigNodes) {
        HashSet<TEndPoint> conflictEndPointSet = new HashSet<TEndPoint>();
        for (TConfigNodeLocation registeredConfigNode : registeredConfigNodes) {
            if (registeredConfigNode.getInternalEndPoint().equals(newConfigNodeLocation.getInternalEndPoint())) {
                conflictEndPointSet.add(newConfigNodeLocation.getInternalEndPoint());
            }
            if (!registeredConfigNode.getConsensusEndPoint().equals(newConfigNodeLocation.getConsensusEndPoint())) continue;
            conflictEndPointSet.add(newConfigNodeLocation.getConsensusEndPoint());
        }
        return new ArrayList<TEndPoint>(conflictEndPointSet);
    }

    public static List<TEndPoint> checkConflictTEndPointForNewDataNode(TDataNodeLocation newDataNodeLocation, List<TDataNodeConfiguration> registeredDataNodes) {
        HashSet<TEndPoint> conflictEndPointSet = new HashSet<TEndPoint>();
        for (TDataNodeConfiguration registeredDataNode : registeredDataNodes) {
            TDataNodeLocation registeredLocation = registeredDataNode.getLocation();
            if (registeredLocation.getClientRpcEndPoint().equals(newDataNodeLocation.getClientRpcEndPoint())) {
                conflictEndPointSet.add(newDataNodeLocation.getClientRpcEndPoint());
            }
            if (registeredLocation.getInternalEndPoint().equals(newDataNodeLocation.getInternalEndPoint())) {
                conflictEndPointSet.add(newDataNodeLocation.getInternalEndPoint());
            }
            if (registeredLocation.getMPPDataExchangeEndPoint().equals(newDataNodeLocation.getMPPDataExchangeEndPoint())) {
                conflictEndPointSet.add(newDataNodeLocation.getMPPDataExchangeEndPoint());
            }
            if (registeredLocation.getSchemaRegionConsensusEndPoint().equals(newDataNodeLocation.getSchemaRegionConsensusEndPoint())) {
                conflictEndPointSet.add(newDataNodeLocation.getSchemaRegionConsensusEndPoint());
            }
            if (!registeredLocation.getDataRegionConsensusEndPoint().equals(newDataNodeLocation.getDataRegionConsensusEndPoint())) continue;
            conflictEndPointSet.add(newDataNodeLocation.getDataRegionConsensusEndPoint());
        }
        return new ArrayList<TEndPoint>(conflictEndPointSet);
    }

    public static TConfigNodeLocation matchRegisteredConfigNode(TConfigNodeLocation configNodeLocation, List<TConfigNodeLocation> registeredConfigNodes) {
        for (TConfigNodeLocation registeredConfigNode : registeredConfigNodes) {
            if (registeredConfigNode.getConfigNodeId() != configNodeLocation.getConfigNodeId()) continue;
            return registeredConfigNode;
        }
        return null;
    }

    public static TDataNodeLocation matchRegisteredDataNode(TDataNodeLocation dataNodeLocation, List<TDataNodeConfiguration> registeredDataNodes) {
        for (TDataNodeConfiguration registeredDataNode : registeredDataNodes) {
            if (registeredDataNode.getLocation().getDataNodeId() != dataNodeLocation.getDataNodeId()) continue;
            return registeredDataNode.getLocation();
        }
        return null;
    }

    public static boolean isTEndPointsOfTConfigNodeLocationUpdated(TConfigNodeLocation configNodeLocationA, TConfigNodeLocation configNodeLocationB) {
        if (!configNodeLocationA.getInternalEndPoint().equals(configNodeLocationB.getInternalEndPoint())) {
            return true;
        }
        return !configNodeLocationA.getConsensusEndPoint().equals(configNodeLocationB.getConsensusEndPoint());
    }

    public static boolean isTEndPointsOfTDataNodeLocationUpdated(TDataNodeLocation dataNodeLocationA, TDataNodeLocation dataNodeLocationB) {
        if (!dataNodeLocationA.getClientRpcEndPoint().equals(dataNodeLocationB.getClientRpcEndPoint())) {
            return true;
        }
        if (!dataNodeLocationA.getInternalEndPoint().equals(dataNodeLocationB.getInternalEndPoint())) {
            return true;
        }
        if (!dataNodeLocationA.getMPPDataExchangeEndPoint().equals(dataNodeLocationB.getMPPDataExchangeEndPoint())) {
            return true;
        }
        if (!dataNodeLocationA.getSchemaRegionConsensusEndPoint().equals(dataNodeLocationB.getSchemaRegionConsensusEndPoint())) {
            return true;
        }
        return !dataNodeLocationA.getDataRegionConsensusEndPoint().equals(dataNodeLocationB.getDataRegionConsensusEndPoint());
    }
}

