/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.io.IOException;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryManagerMXBean;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.ratis.util.Daemon;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.MemoizedSupplier;
import org.apache.ratis.util.TimeDuration;
import org.apache.ratis.util.function.CheckedConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JvmPauseMonitor {
    public static final Logger LOG = LoggerFactory.getLogger(JvmPauseMonitor.class);
    private static final AtomicInteger THREAD_COUNT = new AtomicInteger(0);
    private static final TimeDuration SLEEP_TIME = TimeDuration.valueOf(500L, TimeUnit.MILLISECONDS);
    private static final TimeDuration WARN_THRESHOLD = TimeDuration.valueOf(100L, TimeUnit.MILLISECONDS);
    private final String name;
    private final AtomicReference<Thread> threadRef = new AtomicReference();
    private final CheckedConsumer<TimeDuration, IOException> handler;

    static Map<String, GcInfo> getGcTimes() {
        return ManagementFactory.getGarbageCollectorMXBeans().stream().collect(Collectors.toMap(MemoryManagerMXBean::getName, x$0 -> new GcInfo((GarbageCollectorMXBean)x$0)));
    }

    static String toString(Map<String, GcInfo> beforeSleep, TimeDuration extraSleepTime, Map<String, GcInfo> afterSleep) {
        StringBuilder b = new StringBuilder("Detected pause in JVM or host machine (eg GC): pause of approximately ").append(extraSleepTime).append('.');
        boolean detected = false;
        for (Map.Entry<String, GcInfo> before : beforeSleep.entrySet()) {
            GcInfo diff;
            String name = before.getKey();
            GcInfo after = afterSleep.get(name);
            if (after == null || (diff = after.subtract(before.getValue())).count == 0L) continue;
            b.append(System.lineSeparator()).append("GC pool '").append(name).append("' had collection(s): ").append(diff);
            detected = true;
        }
        if (!detected) {
            b.append(" No GCs detected.");
        }
        return b.toString();
    }

    public JvmPauseMonitor(Object name, CheckedConsumer<TimeDuration, IOException> handler) {
        this.name = JavaUtils.getClassSimpleName(this.getClass()) + "-" + name;
        this.handler = handler;
    }

    private void run() {
        LOG.info("{}: Started", (Object)this);
        try {
            while (Thread.currentThread().equals(this.threadRef.get())) {
                this.detectPause();
            }
        }
        finally {
            LOG.info("{}: Stopped", (Object)this);
        }
    }

    private void detectPause() {
        TimeDuration extraSleep;
        Map<String, GcInfo> before = JvmPauseMonitor.getGcTimes();
        try {
            extraSleep = SLEEP_TIME.sleep();
        }
        catch (InterruptedException ie) {
            return;
        }
        if (extraSleep.compareTo(WARN_THRESHOLD) > 0) {
            Map<String, GcInfo> after = JvmPauseMonitor.getGcTimes();
            LOG.warn("{}: {}", (Object)this, (Object)JvmPauseMonitor.toString(before, extraSleep, after));
        }
        this.handle(extraSleep);
    }

    private void handle(TimeDuration extraSleep) {
        try {
            this.handler.accept(extraSleep);
        }
        catch (Throwable t) {
            LOG.error("{}: Failed to handle extra sleep {}", new Object[]{this, extraSleep, t});
        }
    }

    public void start() {
        MemoizedSupplier<Thread> supplier = JavaUtils.memoize(() -> Daemon.newBuilder().setName("JvmPauseMonitor" + THREAD_COUNT.getAndIncrement()).setRunnable(this::run).build());
        Optional.of(this.threadRef.updateAndGet(previous -> Optional.ofNullable(previous).orElseGet(supplier))).filter(t -> supplier.isInitialized()).ifPresent(Thread::start);
    }

    public void stop() {
        Thread previous = this.threadRef.getAndSet(null);
        if (previous != null) {
            previous.interrupt();
            try {
                previous.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public String toString() {
        return this.name;
    }

    static final class GcInfo {
        private final long count;
        private final long timeMs;

        private GcInfo(GarbageCollectorMXBean gcBean) {
            this(gcBean.getCollectionCount(), gcBean.getCollectionTime());
        }

        private GcInfo(long count, long timeMs) {
            this.count = count;
            this.timeMs = timeMs;
        }

        GcInfo subtract(GcInfo that) {
            return new GcInfo(this.count - that.count, this.timeMs - that.timeMs);
        }

        public String toString() {
            return "count=" + this.count + " time=" + this.timeMs + "ms";
        }
    }
}

