/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence.metric;

import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.confignode.persistence.partition.PartitionInfo;
import org.apache.iotdb.confignode.persistence.partition.StorageGroupPartitionTable;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class PartitionInfoMetrics
implements IMetricSet {
    private PartitionInfo partitionInfo;

    public PartitionInfoMetrics(PartitionInfo partitionInfo) {
        this.partitionInfo = partitionInfo;
    }

    public void bindTo(AbstractMetricService metricService) {
        metricService.createAutoGauge(Metric.QUANTITY.toString(), MetricLevel.IMPORTANT, (Object)this.partitionInfo, PartitionInfo::getStorageGroupPartitionTableSize, new String[]{Tag.NAME.toString(), "database"});
        metricService.createAutoGauge(Metric.REGION.toString(), MetricLevel.IMPORTANT, (Object)this.partitionInfo, o -> o.updateRegionGroupMetric(TConsensusGroupType.SchemaRegion), new String[]{Tag.NAME.toString(), "total", Tag.TYPE.toString(), TConsensusGroupType.SchemaRegion.toString()});
        metricService.createAutoGauge(Metric.REGION.toString(), MetricLevel.IMPORTANT, (Object)this.partitionInfo, o -> o.updateRegionGroupMetric(TConsensusGroupType.DataRegion), new String[]{Tag.NAME.toString(), "total", Tag.TYPE.toString(), TConsensusGroupType.DataRegion.toString()});
    }

    public void unbindFrom(AbstractMetricService metricService) {
        metricService.remove(MetricType.AUTO_GAUGE, Metric.QUANTITY.toString(), new String[]{Tag.NAME.toString(), "database"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.REGION.toString(), new String[]{Tag.NAME.toString(), "total", Tag.TYPE.toString(), TConsensusGroupType.SchemaRegion.toString()});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.REGION.toString(), new String[]{Tag.NAME.toString(), "total", Tag.TYPE.toString(), TConsensusGroupType.DataRegion.toString()});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionInfoMetrics that = (PartitionInfoMetrics)o;
        return Objects.equals(this.partitionInfo, that.partitionInfo);
    }

    public int hashCode() {
        return Objects.hash(this.partitionInfo);
    }

    public static class StorageGroupPartitionTableMetrics
    implements IMetricSet {
        private StorageGroupPartitionTable storageGroupPartitionTable;

        public StorageGroupPartitionTableMetrics(StorageGroupPartitionTable storageGroupPartitionTable) {
            this.storageGroupPartitionTable = storageGroupPartitionTable;
        }

        public void bindTo(AbstractMetricService metricService) {
            metricService.createAutoGauge(Metric.REGION.toString(), MetricLevel.NORMAL, (Object)this.storageGroupPartitionTable, o -> o.getRegionGroupCount(TConsensusGroupType.SchemaRegion), new String[]{Tag.NAME.toString(), this.storageGroupPartitionTable.getStorageGroupName(), Tag.TYPE.toString(), TConsensusGroupType.SchemaRegion.toString()});
            metricService.createAutoGauge(Metric.REGION.toString(), MetricLevel.NORMAL, (Object)this.storageGroupPartitionTable, o -> o.getRegionGroupCount(TConsensusGroupType.DataRegion), new String[]{Tag.NAME.toString(), this.storageGroupPartitionTable.getStorageGroupName(), Tag.TYPE.toString(), TConsensusGroupType.DataRegion.toString()});
            metricService.createAutoGauge(Metric.SLOT.toString(), MetricLevel.NORMAL, (Object)this.storageGroupPartitionTable, StorageGroupPartitionTable::getSchemaPartitionMapSize, new String[]{Tag.NAME.toString(), this.storageGroupPartitionTable.getStorageGroupName(), Tag.TYPE.toString(), "schemaSlotNumber"});
            metricService.createAutoGauge(Metric.SLOT.toString(), MetricLevel.NORMAL, (Object)this.storageGroupPartitionTable, StorageGroupPartitionTable::getDataPartitionMapSize, new String[]{Tag.NAME.toString(), this.storageGroupPartitionTable.getStorageGroupName(), Tag.TYPE.toString(), "dataSlotNumber"});
        }

        public void unbindFrom(AbstractMetricService metricService) {
            metricService.remove(MetricType.AUTO_GAUGE, Metric.REGION.toString(), new String[]{Tag.NAME.toString(), this.storageGroupPartitionTable.getStorageGroupName(), Tag.TYPE.toString(), TConsensusGroupType.SchemaRegion.toString()});
            metricService.remove(MetricType.AUTO_GAUGE, Metric.REGION.toString(), new String[]{Tag.NAME.toString(), this.storageGroupPartitionTable.getStorageGroupName(), Tag.TYPE.toString(), TConsensusGroupType.DataRegion.toString()});
            metricService.remove(MetricType.AUTO_GAUGE, Metric.SLOT.toString(), new String[]{Tag.NAME.toString(), this.storageGroupPartitionTable.getStorageGroupName(), Tag.TYPE.toString(), "schemaSlotNumber"});
            metricService.remove(MetricType.AUTO_GAUGE, Metric.SLOT.toString(), new String[]{Tag.NAME.toString(), this.storageGroupPartitionTable.getStorageGroupName(), Tag.TYPE.toString(), "dataSlotNumber"});
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StorageGroupPartitionTableMetrics that = (StorageGroupPartitionTableMetrics)o;
            return Objects.equals(this.storageGroupPartitionTable, that.storageGroupPartitionTable);
        }

        public int hashCode() {
            return Objects.hash(this.storageGroupPartitionTable);
        }
    }
}

