/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.balancer.region;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeConfiguration;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.confignode.manager.load.balancer.region.IRegionGroupAllocator;
import org.apache.iotdb.tsfile.utils.Pair;

public class GreedyRegionGroupAllocator
implements IRegionGroupAllocator {
    private static final AtomicInteger ZERO = new AtomicInteger(0);

    @Override
    public TRegionReplicaSet generateOptimalRegionReplicasDistribution(Map<Integer, TDataNodeConfiguration> availableDataNodeMap, Map<Integer, Long> freeDiskSpaceMap, List<TRegionReplicaSet> allocatedRegionGroups, int replicationFactor, TConsensusGroupId consensusGroupId) {
        List<TDataNodeLocation> weightList = this.buildWeightList(availableDataNodeMap, freeDiskSpaceMap, allocatedRegionGroups);
        return new TRegionReplicaSet(consensusGroupId, weightList.stream().limit(replicationFactor).collect(Collectors.toList()));
    }

    private List<TDataNodeLocation> buildWeightList(Map<Integer, TDataNodeConfiguration> availableDataNodeMap, Map<Integer, Long> freeDiskSpaceMap, List<TRegionReplicaSet> allocatedRegionGroups) {
        ConcurrentHashMap regionCounter = new ConcurrentHashMap();
        allocatedRegionGroups.forEach(regionReplicaSet -> regionReplicaSet.getDataNodeLocations().forEach(dataNodeLocation -> regionCounter.computeIfAbsent(dataNodeLocation.getDataNodeId(), empty -> new AtomicInteger(0)).getAndIncrement()));
        ConcurrentHashMap priorityMap = new ConcurrentHashMap();
        availableDataNodeMap.keySet().forEach(dataNodeId -> priorityMap.put(((TDataNodeConfiguration)availableDataNodeMap.get(dataNodeId)).getLocation(), new Pair((Object)regionCounter.getOrDefault(dataNodeId, ZERO).get(), (Object)freeDiskSpaceMap.getOrDefault(dataNodeId, 0L))));
        return priorityMap.entrySet().stream().sorted(Map.Entry.comparingByValue((o1, o2) -> !Objects.equals(o1.getLeft(), o2.getLeft()) ? (Integer)o1.getLeft() - (Integer)o2.getLeft() : (int)((Long)o2.getRight() - (Long)o1.getRight()))).map(entry -> ((TDataNodeLocation)entry.getKey()).deepCopy()).collect(Collectors.toList());
    }
}

