/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.read.storagegroup;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import org.apache.iotdb.commons.utils.BasicStructureSerDeUtil;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;

public class CountStorageGroupPlan
extends ConfigPhysicalPlan {
    private String[] storageGroupPattern;

    public CountStorageGroupPlan() {
        super(ConfigPhysicalPlanType.CountStorageGroup);
    }

    public CountStorageGroupPlan(ConfigPhysicalPlanType type) {
        super(type);
    }

    public CountStorageGroupPlan(List<String> storageGroupPattern) {
        this();
        this.storageGroupPattern = storageGroupPattern.toArray(new String[0]);
    }

    public CountStorageGroupPlan(ConfigPhysicalPlanType type, List<String> storageGroupPattern) {
        super(type);
        this.storageGroupPattern = storageGroupPattern.toArray(new String[0]);
    }

    public String[] getStorageGroupPattern() {
        return this.storageGroupPattern;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeShort(this.getType().getPlanType());
        stream.writeInt(this.storageGroupPattern.length);
        for (String node : this.storageGroupPattern) {
            BasicStructureSerDeUtil.write((String)node, (DataOutputStream)stream);
        }
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) {
        int length = buffer.getInt();
        this.storageGroupPattern = new String[length];
        for (int i = 0; i < length; ++i) {
            this.storageGroupPattern[i] = BasicStructureSerDeUtil.readString((ByteBuffer)buffer);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CountStorageGroupPlan that = (CountStorageGroupPlan)o;
        return Arrays.equals(this.storageGroupPattern, that.storageGroupPattern);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.storageGroupPattern);
    }
}

