/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.iot.logdispatcher;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.iotdb.consensus.config.IoTConsensusConfig;
import org.apache.iotdb.consensus.iot.logdispatcher.IndexController;
import org.apache.iotdb.consensus.iot.logdispatcher.IoTConsensusMemoryManager;
import org.apache.iotdb.consensus.iot.logdispatcher.PendingBatch;

public class SyncStatus {
    private final IoTConsensusConfig config;
    private final IndexController controller;
    private final LinkedList<PendingBatch> pendingBatches = new LinkedList();
    private final IoTConsensusMemoryManager iotConsensusMemoryManager = IoTConsensusMemoryManager.getInstance();

    public SyncStatus(IndexController controller, IoTConsensusConfig config) {
        this.controller = controller;
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNextBatch(PendingBatch batch) throws InterruptedException {
        SyncStatus syncStatus = this;
        synchronized (syncStatus) {
            while (this.pendingBatches.size() >= this.config.getReplication().getMaxPendingBatch() || !this.iotConsensusMemoryManager.reserve(batch.getSerializedSize(), false)) {
                this.wait();
            }
            this.pendingBatches.add(batch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBatch(PendingBatch batch) {
        SyncStatus syncStatus = this;
        synchronized (syncStatus) {
            batch.setSynced(true);
            if (this.pendingBatches.size() > 0 && this.pendingBatches.get(0).equals(batch)) {
                Iterator iterator = this.pendingBatches.iterator();
                PendingBatch current = (PendingBatch)iterator.next();
                while (current.isSynced()) {
                    this.controller.updateAndGet(current.getEndIndex());
                    iterator.remove();
                    this.iotConsensusMemoryManager.free(current.getSerializedSize());
                    if (!iterator.hasNext()) break;
                    current = (PendingBatch)iterator.next();
                }
                this.notifyAll();
            }
        }
    }

    public void free() {
        long size = 0L;
        for (PendingBatch pendingBatch : this.pendingBatches) {
            size += pendingBatch.getSerializedSize();
        }
        this.pendingBatches.clear();
        this.iotConsensusMemoryManager.free(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNextSendingIndex() {
        SyncStatus syncStatus = this;
        synchronized (syncStatus) {
            return 1L + (this.pendingBatches.isEmpty() ? this.controller.getCurrentIndex() : this.pendingBatches.getLast().getEndIndex());
        }
    }

    public List<PendingBatch> getPendingBatches() {
        return this.pendingBatches;
    }
}

