/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.iot.client;

import java.lang.reflect.Constructor;
import java.net.SocketException;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.client.BaseClientFactory;
import org.apache.iotdb.commons.client.ClientFactoryProperty;
import org.apache.iotdb.commons.client.ClientManager;
import org.apache.iotdb.commons.client.sync.SyncThriftClient;
import org.apache.iotdb.commons.client.sync.SyncThriftClientWithErrorHandler;
import org.apache.iotdb.consensus.iot.thrift.IoTConsensusIService;
import org.apache.iotdb.rpc.RpcTransportFactory;
import org.apache.iotdb.rpc.TConfigurationConst;
import org.apache.iotdb.rpc.TimeoutChangeableTransport;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class SyncIoTConsensusServiceClient
extends IoTConsensusIService.Client
implements SyncThriftClient,
AutoCloseable {
    private final TEndPoint endPoint;
    private final ClientManager<TEndPoint, SyncIoTConsensusServiceClient> clientManager;

    public SyncIoTConsensusServiceClient(TProtocolFactory protocolFactory, int connectionTimeout, TEndPoint endPoint, ClientManager<TEndPoint, SyncIoTConsensusServiceClient> clientManager) throws TTransportException {
        super(protocolFactory.getProtocol(RpcTransportFactory.INSTANCE.getTransport((TTransport)new TSocket(TConfigurationConst.defaultTConfiguration, endPoint.getIp(), endPoint.getPort(), connectionTimeout))));
        this.endPoint = endPoint;
        this.clientManager = clientManager;
        this.getInputProtocol().getTransport().open();
    }

    public TEndPoint getTEndpoint() {
        return this.endPoint;
    }

    public ClientManager<TEndPoint, SyncIoTConsensusServiceClient> getClientManager() {
        return this.clientManager;
    }

    @Override
    public void close() {
        if (this.clientManager != null) {
            this.clientManager.returnClient((Object)this.endPoint, (Object)this);
        }
    }

    public void setTimeout(int timeout) {
        ((TimeoutChangeableTransport)this.getInputProtocol().getTransport()).setTimeout(timeout);
    }

    public void invalidate() {
        this.getInputProtocol().getTransport().close();
    }

    public void invalidateAll() {
        this.clientManager.clear((Object)this.endPoint);
    }

    public int getTimeout() throws SocketException {
        return ((TimeoutChangeableTransport)this.getInputProtocol().getTransport()).getTimeOut();
    }

    public String toString() {
        return String.format("SyncIoTConsensusServiceClient{%s}", this.endPoint);
    }

    public static class Factory
    extends BaseClientFactory<TEndPoint, SyncIoTConsensusServiceClient> {
        public Factory(ClientManager<TEndPoint, SyncIoTConsensusServiceClient> clientManager, ClientFactoryProperty clientFactoryProperty) {
            super(clientManager, clientFactoryProperty);
        }

        public void destroyObject(TEndPoint endpoint, PooledObject<SyncIoTConsensusServiceClient> pooledObject) {
            ((SyncIoTConsensusServiceClient)pooledObject.getObject()).invalidate();
        }

        public PooledObject<SyncIoTConsensusServiceClient> makeObject(TEndPoint endpoint) throws Exception {
            Constructor constructor = SyncIoTConsensusServiceClient.class.getConstructor(TProtocolFactory.class, Integer.TYPE, endpoint.getClass(), this.clientManager.getClass());
            return new DefaultPooledObject((Object)((SyncIoTConsensusServiceClient)SyncThriftClientWithErrorHandler.newErrorHandler(SyncIoTConsensusServiceClient.class, constructor, (Object[])new Object[]{this.clientFactoryProperty.getProtocolFactory(), this.clientFactoryProperty.getConnectionTimeoutMs(), endpoint, this.clientManager})));
        }

        public boolean validateObject(TEndPoint endpoint, PooledObject<SyncIoTConsensusServiceClient> pooledObject) {
            return pooledObject.getObject() != null && ((SyncIoTConsensusServiceClient)pooledObject.getObject()).getInputProtocol().getTransport().isOpen();
        }
    }
}

