/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.metricsets.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.turbo.TurboFilter;
import ch.qos.logback.core.spi.FilterReply;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.logback.LogbackMetrics;
import org.apache.iotdb.metrics.type.Counter;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.slf4j.Marker;

public class MetricsTurboFilter
extends TurboFilter {
    private Counter errorCounter;
    private Counter warnCounter;
    private Counter infoCounter;
    private Counter debugCounter;
    private Counter traceCounter;

    MetricsTurboFilter(AbstractMetricService metricService) {
        this.errorCounter = metricService.getOrCreateCounter("logback_events", MetricLevel.IMPORTANT, "level", "error");
        this.warnCounter = metricService.getOrCreateCounter("logback_events", MetricLevel.IMPORTANT, "level", "warn");
        this.infoCounter = metricService.getOrCreateCounter("logback_events", MetricLevel.IMPORTANT, "level", "info");
        this.debugCounter = metricService.getOrCreateCounter("logback_events", MetricLevel.IMPORTANT, "level", "debug");
        this.traceCounter = metricService.getOrCreateCounter("logback_events", MetricLevel.IMPORTANT, "level", "trace");
    }

    public FilterReply decide(Marker marker, Logger logger, Level level, String format, Object[] params, Throwable t) {
        if (format == null) {
            return FilterReply.NEUTRAL;
        }
        Boolean ignored = LogbackMetrics.ignoreMetrics.get();
        if (ignored != null && ignored.booleanValue()) {
            return FilterReply.NEUTRAL;
        }
        if (level.isGreaterOrEqual(logger.getEffectiveLevel())) {
            switch (level.toInt()) {
                case 40000: {
                    this.errorCounter.inc();
                    break;
                }
                case 30000: {
                    this.warnCounter.inc();
                    break;
                }
                case 20000: {
                    this.infoCounter.inc();
                    break;
                }
                case 10000: {
                    this.debugCounter.inc();
                    break;
                }
                case 5000: {
                    this.traceCounter.inc();
                }
            }
        }
        return FilterReply.NEUTRAL;
    }
}

