/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.metricsets.jvm;

import com.sun.management.GarbageCollectionNotificationInfo;
import com.sun.management.GcInfo;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.ListenerNotFoundException;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeData;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.metricsets.jvm.JvmUtils;
import org.apache.iotdb.metrics.type.Counter;
import org.apache.iotdb.metrics.type.Timer;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JvmGcMetrics
implements IMetricSet,
AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(JvmGcMetrics.class);
    private String youngGenPoolName;
    private String oldGenPoolName;
    private String nonGenerationalMemoryPool;
    private final List<Runnable> notificationListenerCleanUpRunnables = new CopyOnWriteArrayList<Runnable>();

    public JvmGcMetrics() {
        for (MemoryPoolMXBean mbean : ManagementFactory.getMemoryPoolMXBeans()) {
            String name = mbean.getName();
            if (JvmGcMetrics.isYoungGenPool(name)) {
                this.youngGenPoolName = name;
                continue;
            }
            if (JvmGcMetrics.isOldGenPool(name)) {
                this.oldGenPoolName = name;
                continue;
            }
            if (!JvmGcMetrics.isNonGenerationalHeapPool(name)) continue;
            this.nonGenerationalMemoryPool = name;
        }
    }

    @Override
    public void bindTo(AbstractMetricService metricService) {
        if (!this.preCheck()) {
            return;
        }
        double maxLongLivedPoolBytes = ManagementFactory.getPlatformMXBeans(MemoryPoolMXBean.class).stream().filter(mem -> MemoryType.HEAP.equals((Object)mem.getType())).filter(mem -> JvmGcMetrics.isOldGenPool(mem.getName()) || JvmGcMetrics.isNonGenerationalHeapPool(mem.getName())).findAny().map(mem -> JvmUtils.getUsageValue(mem, MemoryUsage::getMax)).orElse(0.0);
        AtomicLong maxDataSize = new AtomicLong((long)maxLongLivedPoolBytes);
        metricService.createAutoGauge("jvm_gc_max_data_size_bytes", MetricLevel.IMPORTANT, maxDataSize, AtomicLong::get, new String[0]);
        AtomicLong liveDataSize = new AtomicLong();
        metricService.createAutoGauge("jvm_gc_live_data_size_bytes", MetricLevel.IMPORTANT, liveDataSize, AtomicLong::get, new String[0]);
        Counter allocatedBytes = metricService.getOrCreateCounter("jvm_gc_memory_allocated_bytes", MetricLevel.IMPORTANT, new String[0]);
        Counter promotedBytes = this.oldGenPoolName == null ? null : metricService.getOrCreateCounter("jvm_gc_memory_promoted_bytes", MetricLevel.IMPORTANT, new String[0]);
        AtomicLong heapPoolSizeAfterGc = new AtomicLong();
        for (GarbageCollectorMXBean mbean : ManagementFactory.getGarbageCollectorMXBeans()) {
            if (!(mbean instanceof NotificationEmitter)) continue;
            NotificationListener notificationListener = (notification, ref) -> {
                CompositeData cd = (CompositeData)notification.getUserData();
                GarbageCollectionNotificationInfo notificationInfo = GarbageCollectionNotificationInfo.from(cd);
                String gcCause = notificationInfo.getGcCause();
                String gcAction = notificationInfo.getGcAction();
                GcInfo gcInfo = notificationInfo.getGcInfo();
                long duration = gcInfo.getDuration();
                String timerName = JvmGcMetrics.isConcurrentPhase(gcCause, notificationInfo.getGcName()) ? "jvm_gc_concurrent_phase_time" : "jvm_gc_pause";
                Timer timer = metricService.getOrCreateTimer(timerName, MetricLevel.IMPORTANT, "action", gcAction, "cause", gcCause);
                timer.update(duration, TimeUnit.MILLISECONDS);
                Map<String, MemoryUsage> before = gcInfo.getMemoryUsageBeforeGc();
                Map<String, MemoryUsage> after = gcInfo.getMemoryUsageAfterGc();
                if (this.nonGenerationalMemoryPool != null) {
                    this.countPoolSizeDelta(gcInfo.getMemoryUsageBeforeGc(), gcInfo.getMemoryUsageAfterGc(), allocatedBytes, heapPoolSizeAfterGc, this.nonGenerationalMemoryPool);
                    if (after.get(this.nonGenerationalMemoryPool).getUsed() < before.get(this.nonGenerationalMemoryPool).getUsed()) {
                        liveDataSize.set(after.get(this.nonGenerationalMemoryPool).getUsed());
                        long longLivedMaxAfter = after.get(this.nonGenerationalMemoryPool).getMax();
                        maxDataSize.set(longLivedMaxAfter);
                    }
                    return;
                }
                if (this.oldGenPoolName != null) {
                    long oldBefore = before.get(this.oldGenPoolName).getUsed();
                    long oldAfter = after.get(this.oldGenPoolName).getUsed();
                    long delta = oldAfter - oldBefore;
                    if (delta > 0L) {
                        promotedBytes.inc(delta);
                    }
                    if (oldAfter < oldBefore || GcGenerationAge.fromName(notificationInfo.getGcName()) == GcGenerationAge.OLD) {
                        liveDataSize.set(oldAfter);
                        long oldMaxAfter = after.get(this.oldGenPoolName).getMax();
                        maxDataSize.set(oldMaxAfter);
                    }
                }
                if (this.youngGenPoolName != null) {
                    this.countPoolSizeDelta(gcInfo.getMemoryUsageBeforeGc(), gcInfo.getMemoryUsageAfterGc(), allocatedBytes, heapPoolSizeAfterGc, this.youngGenPoolName);
                }
            };
            NotificationEmitter notificationEmitter = (NotificationEmitter)((Object)mbean);
            notificationEmitter.addNotificationListener(notificationListener, notification -> notification.getType().equals("com.sun.management.gc.notification"), null);
            this.notificationListenerCleanUpRunnables.add(() -> {
                try {
                    notificationEmitter.removeNotificationListener(notificationListener);
                }
                catch (ListenerNotFoundException listenerNotFoundException) {
                    // empty catch block
                }
            });
        }
    }

    @Override
    public void unbindFrom(AbstractMetricService metricService) {
        if (!this.preCheck()) {
            return;
        }
        metricService.remove(MetricType.AUTO_GAUGE, "jvm_gc_max_data_size_bytes", new String[0]);
        metricService.remove(MetricType.AUTO_GAUGE, "jvm_gc_live_data_size_bytes", new String[0]);
        metricService.remove(MetricType.COUNTER, "jvm_gc_memory_allocated_bytes", new String[0]);
        if (this.oldGenPoolName != null) {
            metricService.remove(MetricType.COUNTER, "jvm_gc_memory_promoted_bytes", new String[0]);
        }
        for (GarbageCollectorMXBean mbean : ManagementFactory.getGarbageCollectorMXBeans()) {
            if (!(mbean instanceof NotificationEmitter)) continue;
            NotificationListener notificationListener = (notification, ref) -> {
                CompositeData cd = (CompositeData)notification.getUserData();
                GarbageCollectionNotificationInfo notificationInfo = GarbageCollectionNotificationInfo.from(cd);
                String gcCause = notificationInfo.getGcCause();
                String gcAction = notificationInfo.getGcAction();
                String timerName = JvmGcMetrics.isConcurrentPhase(gcCause, notificationInfo.getGcName()) ? "jvm_gc_concurrent_phase_time" : "jvm_gc_pause";
                metricService.remove(MetricType.TIMER, timerName, "action", gcAction, "cause", gcCause);
            };
            NotificationEmitter notificationEmitter = (NotificationEmitter)((Object)mbean);
            notificationEmitter.addNotificationListener(notificationListener, notification -> notification.getType().equals("com.sun.management.gc.notification"), null);
            this.notificationListenerCleanUpRunnables.add(() -> {
                try {
                    notificationEmitter.removeNotificationListener(notificationListener);
                }
                catch (ListenerNotFoundException listenerNotFoundException) {
                    // empty catch block
                }
            });
        }
    }

    private boolean preCheck() {
        if (ManagementFactory.getMemoryPoolMXBeans().isEmpty()) {
            logger.warn("GC notifications will not be available because MemoryPoolMXBeans are not provided by the JVM");
            return false;
        }
        try {
            Class.forName("com.sun.management.GarbageCollectionNotificationInfo", false, MemoryPoolMXBean.class.getClassLoader());
        }
        catch (Throwable e) {
            logger.warn("GC notifications will not be available because com.sun.management.GarbageCollectionNotificationInfo is not present");
            return false;
        }
        return true;
    }

    private void countPoolSizeDelta(Map<String, MemoryUsage> before, Map<String, MemoryUsage> after, Counter counter, AtomicLong previousPoolSize, String poolName) {
        long beforeBytes = before.get(poolName).getUsed();
        long afterBytes = after.get(poolName).getUsed();
        long delta = beforeBytes - previousPoolSize.get();
        previousPoolSize.set(afterBytes);
        if (delta > 0L) {
            counter.inc(delta);
        }
    }

    @Override
    public void close() {
        this.notificationListenerCleanUpRunnables.forEach(Runnable::run);
    }

    private static Optional<MemoryPoolMXBean> getLongLivedHeapPool() {
        return ManagementFactory.getPlatformMXBeans(MemoryPoolMXBean.class).stream().filter(JvmGcMetrics::isHeap).filter(mem -> JvmGcMetrics.isOldGenPool(mem.getName()) || JvmGcMetrics.isNonGenerationalHeapPool(mem.getName())).findAny();
    }

    private static boolean isConcurrentPhase(String cause, String name) {
        return "No GC".equals(cause) || "Shenandoah Cycles".equals(name);
    }

    private static boolean isYoungGenPool(String name) {
        return name != null && name.endsWith("Eden Space");
    }

    private static boolean isOldGenPool(String name) {
        return name != null && (name.endsWith("Old Gen") || name.endsWith("Tenured Gen"));
    }

    private static boolean isNonGenerationalHeapPool(String name) {
        return "Shenandoah".equals(name) || "ZHeap".equals(name);
    }

    private static boolean isHeap(MemoryPoolMXBean memoryPoolBean) {
        return MemoryType.HEAP.equals((Object)memoryPoolBean.getType());
    }

    static enum GcGenerationAge {
        OLD,
        YOUNG,
        UNKNOWN;

        private static Map<String, GcGenerationAge> knownCollectors;

        static GcGenerationAge fromName(String name) {
            return knownCollectors.getOrDefault(name, UNKNOWN);
        }

        static {
            knownCollectors = new HashMap<String, GcGenerationAge>(){
                {
                    this.put("ConcurrentMarkSweep", OLD);
                    this.put("Copy", YOUNG);
                    this.put("G1 Old Generation", OLD);
                    this.put("G1 Young Generation", YOUNG);
                    this.put("MarkSweepCompact", OLD);
                    this.put("PS MarkSweep", OLD);
                    this.put("PS Scavenge", YOUNG);
                    this.put("ParNew", YOUNG);
                }
            };
        }
    }
}

