/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.udf.builtin.String;

import java.io.IOException;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.AccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.MappableRowByRowAccessStrategy;
import org.apache.iotdb.udf.api.type.Type;

public class UDTFEndsWith
implements UDTF {
    private String target;

    public void validate(UDFParameterValidator validator) throws Exception {
        validator.validateInputSeriesNumber(1).validateInputSeriesDataType(0, Type.TEXT);
    }

    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) throws Exception {
        this.target = parameters.getString("target");
        configurations.setAccessStrategy((AccessStrategy)new MappableRowByRowAccessStrategy()).setOutputDataType(Type.BOOLEAN);
    }

    public void transform(Row row, PointCollector collector) throws Exception {
        collector.putBoolean(row.getTime(), row.getString(0).endsWith(this.target));
    }

    public Object transform(Row row) throws IOException {
        if (row.isNull(0)) {
            return null;
        }
        return row.getString(0).endsWith(this.target);
    }
}

