/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.service.metric;

import org.apache.iotdb.commons.exception.StartupException;
import org.apache.iotdb.commons.service.IService;
import org.apache.iotdb.commons.service.JMXService;
import org.apache.iotdb.commons.service.ServiceType;
import org.apache.iotdb.commons.service.metric.MetricServiceMBean;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.config.ReloadLevel;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.reporter.iotdb.InternalIoTDBReporter;
import org.apache.iotdb.metrics.reporter.iotdb.MemoryInternalIoTDBReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricService
extends AbstractMetricService
implements MetricServiceMBean,
IService {
    private static final Logger logger = LoggerFactory.getLogger(MetricService.class);
    private final String mbeanName = String.format("%s:%s=%s", "org.apache.iotdb.service", "type", this.getID().getJmxName());

    private MetricService() {
    }

    @Override
    public void start() throws StartupException {
        try {
            logger.info("Start to start metric Service.");
            JMXService.registerMBean(MetricService.getInstance(), this.mbeanName);
            this.startService();
            logger.info("Finish start metric Service");
        }
        catch (Exception e) {
            logger.error("Failed to start {} because: ", (Object)this.getID().getName(), (Object)e);
            throw new StartupException(this.getID().getName(), e.getMessage());
        }
    }

    @Override
    public void restartService() {
        logger.info("Restart metric service");
        this.stopCoreModule();
        this.internalReporter.clear();
        this.startCoreModule();
        for (IMetricSet metricSet : this.metricSets) {
            logger.info("Restart metricSet: {}", (Object)metricSet.getClass().getName());
            metricSet.unbindFrom((AbstractMetricService)this);
            metricSet.bindTo((AbstractMetricService)this);
        }
        logger.info("Finish restarting metric service");
    }

    @Override
    public void stop() {
        logger.info("Stop metric service");
        this.internalReporter.stop();
        this.internalReporter = new MemoryInternalIoTDBReporter();
        this.stopService();
        JMXService.deregisterMBean(this.mbeanName);
        logger.info("Finish stopping metric service");
    }

    public void reloadInternalReporter(InternalIoTDBReporter internalReporter) {
        logger.info("Reload internal reporter");
        internalReporter.addAutoGauge(this.internalReporter.getAllAutoGauge());
        this.internalReporter.stop();
        this.internalReporter = internalReporter;
        this.internalReporter.start();
        logger.info("Finish reloading internal reporter");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadService(ReloadLevel reloadLevel) {
        MetricService metricService = this;
        synchronized (metricService) {
            switch (reloadLevel) {
                case RESTART_METRIC: {
                    this.restartService();
                    break;
                }
                case RESTART_REPORTER: {
                    this.stopAllReporter();
                    this.loadReporter();
                    this.startAllReporter();
                    logger.info("Finish restart metric reporters.");
                    break;
                }
                case NOTHING: {
                    logger.debug("There are nothing change in metric module.");
                    break;
                }
            }
        }
    }

    @Override
    public ServiceType getID() {
        return ServiceType.METRIC_SERVICE;
    }

    public void updateInternalReporter(InternalIoTDBReporter InternalReporter) {
        this.internalReporter = InternalReporter;
    }

    public void startInternalReporter() {
        this.internalReporter.start();
    }

    public static MetricService getInstance() {
        return MetricsServiceHolder.INSTANCE;
    }

    private static class MetricsServiceHolder {
        private static final MetricService INSTANCE = new MetricService();

        private MetricsServiceHolder() {
        }
    }
}

