/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.service;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.commons.exception.StartupException;
import org.apache.iotdb.commons.service.StartupCheck;
import org.apache.iotdb.commons.utils.JVMCommonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartupChecks {
    private static final Logger logger = LoggerFactory.getLogger(StartupChecks.class);
    public static final StartupCheck checkJDK = () -> {
        int version = JVMCommonUtils.getJdkVersion();
        if (version < 8) {
            throw new StartupException(String.format("Requires JDK version >= %d, current version is %d.", 8, version));
        }
        logger.info("JDK version is {}.", (Object)version);
    };
    private final List<StartupCheck> preChecks = new ArrayList<StartupCheck>();
    private final List<StartupCheck> defaultTests = new ArrayList<StartupCheck>();

    public StartupChecks(String nodeRole) {
        this.defaultTests.add(() -> this.checkJMXPort(nodeRole));
        this.defaultTests.add(checkJDK);
    }

    private void checkJMXPort(String nodeRole) {
        Boolean jmxLocal = Boolean.valueOf(System.getProperty("iotdb.jmx.local"));
        String jmxPort = System.getProperty("com.sun.management.jmxremote.port");
        if (jmxLocal.booleanValue()) {
            logger.info("Start JMX locally.");
            return;
        }
        if (jmxPort == null) {
            String filename = nodeRole.equals("datanode") ? "datanode-env" : "confignode-env";
            logger.warn("{} missing from {}.sh(Unix or OS X, if you use Windows, check conf/{}.bat)", new Object[]{"com.sun.management.jmxremote.port", filename, filename});
        } else {
            logger.info("Start JMX remotely: JMX is enabled to receive remote connection on port {}", (Object)jmxPort);
        }
    }

    public StartupChecks withDefaultTest() {
        this.preChecks.addAll(this.defaultTests);
        return this;
    }

    public void verify() throws StartupException {
        for (StartupCheck check : this.preChecks) {
            check.execute();
        }
    }
}

