/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.wal;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.concurrent.threadpool.ScheduledExecutorUtil;
import org.apache.iotdb.commons.exception.StartupException;
import org.apache.iotdb.commons.service.IService;
import org.apache.iotdb.commons.service.ServiceType;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.wal.allocation.ElasticStrategy;
import org.apache.iotdb.db.wal.allocation.FirstCreateStrategy;
import org.apache.iotdb.db.wal.allocation.NodeAllocationStrategy;
import org.apache.iotdb.db.wal.allocation.RoundRobinStrategy;
import org.apache.iotdb.db.wal.node.IWALNode;
import org.apache.iotdb.db.wal.node.WALFakeNode;
import org.apache.iotdb.db.wal.node.WALNode;
import org.apache.iotdb.db.wal.utils.WALMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WALManager
implements IService {
    private static final Logger logger = LoggerFactory.getLogger(WALManager.class);
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private final NodeAllocationStrategy walNodesManager;
    private ScheduledExecutorService walDeleteThread;
    private final AtomicLong totalDiskUsage = new AtomicLong();

    private WALManager() {
        this.walNodesManager = config.isClusterMode() && config.getDataRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.iot.IoTConsensus") ? new FirstCreateStrategy() : (config.getMaxWalNodesNum() == 0 ? new ElasticStrategy() : new RoundRobinStrategy(config.getMaxWalNodesNum()));
    }

    public static String getApplicantUniqueId(String storageGroupName, boolean sequence) {
        return config.getDataRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.iot.IoTConsensus") ? storageGroupName : storageGroupName + "-" + (sequence ? "sequence" : "unsequence");
    }

    public IWALNode applyForWALNode(String applicantUniqueId) {
        if (config.getWalMode() == WALMode.DISABLE) {
            return WALFakeNode.getSuccessInstance();
        }
        return this.walNodesManager.applyForWALNode(applicantUniqueId);
    }

    public void registerWALNode(String applicantUniqueId, String logDirectory, long startFileVersion, long startSearchIndex) {
        if (config.getWalMode() == WALMode.DISABLE || !config.isClusterMode() || !config.getDataRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.iot.IoTConsensus")) {
            return;
        }
        ((FirstCreateStrategy)this.walNodesManager).registerWALNode(applicantUniqueId, logDirectory, startFileVersion, startSearchIndex);
    }

    public void deleteWALNode(String applicantUniqueId) {
        if (config.getWalMode() == WALMode.DISABLE || !config.isClusterMode() || !config.getDataRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.iot.IoTConsensus")) {
            return;
        }
        ((FirstCreateStrategy)this.walNodesManager).deleteWALNode(applicantUniqueId);
    }

    public void start() throws StartupException {
        if (config.getWalMode() == WALMode.DISABLE) {
            return;
        }
        try {
            this.registerScheduleTask(config.getDeleteWalFilesPeriodInMs(), config.getDeleteWalFilesPeriodInMs());
        }
        catch (Exception e) {
            throw new StartupException(this.getID().getName(), e.getMessage());
        }
    }

    public void rebootWALDeleteThread() {
        if (config.getWalMode() == WALMode.DISABLE) {
            return;
        }
        logger.info("Start rebooting wal delete thread.");
        if (this.walDeleteThread != null) {
            this.shutdownThread(this.walDeleteThread, ThreadName.WAL_DELETE);
        }
        logger.info("Stop wal delete thread successfully, and now restart it.");
        this.registerScheduleTask(0L, config.getDeleteWalFilesPeriodInMs());
        logger.info("Reboot wal delete thread successfully, current period is {} ms", (Object)config.getDeleteWalFilesPeriodInMs());
    }

    public void deleteOutdatedWALFiles() {
        if (config.getWalMode() == WALMode.DISABLE) {
            return;
        }
        if (this.walDeleteThread == null) {
            return;
        }
        Future<?> future = this.walDeleteThread.submit(this::deleteOutdatedFiles);
        try {
            future.get();
        }
        catch (ExecutionException e) {
            logger.warn("Exception occurs when deleting wal files", (Throwable)e);
        }
        catch (InterruptedException e) {
            logger.warn("Interrupted when deleting wal files", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    private void deleteOutdatedFiles() {
        for (WALNode walNode : this.walNodesManager.getNodesSnapshot()) {
            walNode.deleteOutdatedFiles();
        }
    }

    public void waitAllWALFlushed() {
        if (config.getWalMode() == WALMode.DISABLE) {
            return;
        }
        for (WALNode walNode : this.walNodesManager.getNodesSnapshot()) {
            while (!walNode.isAllWALEntriesConsumed()) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    logger.error("Interrupted when waiting for all write-ahead logs flushed.");
                }
            }
        }
    }

    public long getTotalDiskUsage() {
        return this.totalDiskUsage.get();
    }

    public void addTotalDiskUsage(long size) {
        this.totalDiskUsage.accumulateAndGet(size, Long::sum);
    }

    public void subtractTotalDiskUsage(long size) {
        this.totalDiskUsage.accumulateAndGet(size, (x, y) -> x - y);
    }

    public void stop() {
        if (config.getWalMode() == WALMode.DISABLE) {
            return;
        }
        if (this.walDeleteThread != null) {
            this.shutdownThread(this.walDeleteThread, ThreadName.WAL_DELETE);
            this.walDeleteThread = null;
        }
        this.clear();
    }

    private void shutdownThread(ExecutorService thread, ThreadName threadName) {
        thread.shutdown();
        try {
            if (!thread.awaitTermination(30L, TimeUnit.SECONDS)) {
                logger.warn("Waiting thread {} to be terminated is timeout", (Object)threadName.getName());
            }
        }
        catch (InterruptedException e) {
            logger.warn("Thread {} still doesn't exit after 30s", (Object)threadName.getName());
            Thread.currentThread().interrupt();
        }
    }

    private void registerScheduleTask(long initDelayMs, long periodMs) {
        this.walDeleteThread = IoTDBThreadPoolFactory.newSingleThreadScheduledExecutor((String)ThreadName.WAL_DELETE.getName());
        ScheduledExecutorUtil.safelyScheduleWithFixedDelay((ScheduledExecutorService)this.walDeleteThread, this::deleteOutdatedFiles, (long)initDelayMs, (long)periodMs, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public void clear() {
        this.totalDiskUsage.set(0L);
        this.walNodesManager.clear();
    }

    public ServiceType getID() {
        return ServiceType.WAL_SERVICE;
    }

    public static WALManager getInstance() {
        return InstanceHolder.INSTANCE;
    }

    private static class InstanceHolder {
        private static final WALManager INSTANCE = new WALManager();

        private InstanceHolder() {
        }
    }
}

