/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service.thrift.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.auth.AuthException;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.conf.IoTDBConstant;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Operation;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.auth.AuthorizerManager;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.conf.OperationType;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.QueryPlan;
import org.apache.iotdb.db.qp.physical.crud.UDFPlan;
import org.apache.iotdb.db.qp.physical.sys.AppendTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.CreateAlignedTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateMultiTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.DeleteStorageGroupPlan;
import org.apache.iotdb.db.qp.physical.sys.DeleteTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.DropTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.PruneTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.SetStorageGroupPlan;
import org.apache.iotdb.db.qp.physical.sys.SetTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.ShowQueryProcesslistPlan;
import org.apache.iotdb.db.qp.physical.sys.UnsetTemplatePlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.SessionManager;
import org.apache.iotdb.db.query.control.clientsession.IClientSession;
import org.apache.iotdb.db.query.dataset.DirectAlignByTimeDataSet;
import org.apache.iotdb.db.query.dataset.DirectNonAlignDataSet;
import org.apache.iotdb.db.query.pool.QueryTaskManager;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.service.StaticResps;
import org.apache.iotdb.db.service.basic.BasicOpenSessionResp;
import org.apache.iotdb.db.service.basic.ServiceProvider;
import org.apache.iotdb.db.service.thrift.impl.IClientRPCServiceWithHandler;
import org.apache.iotdb.db.sync.SyncService;
import org.apache.iotdb.db.tools.watermark.GroupedLSBWatermarkEncoder;
import org.apache.iotdb.db.tools.watermark.WatermarkEncoder;
import org.apache.iotdb.db.utils.ErrorHandlingUtils;
import org.apache.iotdb.db.utils.QueryDataSetUtils;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.rpc.RedirectException;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.ServerProperties;
import org.apache.iotdb.service.rpc.thrift.TSAppendSchemaTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSCancelOperationReq;
import org.apache.iotdb.service.rpc.thrift.TSCloseOperationReq;
import org.apache.iotdb.service.rpc.thrift.TSCloseSessionReq;
import org.apache.iotdb.service.rpc.thrift.TSConnectionInfoResp;
import org.apache.iotdb.service.rpc.thrift.TSCreateAlignedTimeseriesReq;
import org.apache.iotdb.service.rpc.thrift.TSCreateMultiTimeseriesReq;
import org.apache.iotdb.service.rpc.thrift.TSCreateSchemaTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSCreateTimeseriesReq;
import org.apache.iotdb.service.rpc.thrift.TSDeleteDataReq;
import org.apache.iotdb.service.rpc.thrift.TSDropSchemaTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSExecuteBatchStatementReq;
import org.apache.iotdb.service.rpc.thrift.TSExecuteStatementReq;
import org.apache.iotdb.service.rpc.thrift.TSExecuteStatementResp;
import org.apache.iotdb.service.rpc.thrift.TSFetchMetadataReq;
import org.apache.iotdb.service.rpc.thrift.TSFetchMetadataResp;
import org.apache.iotdb.service.rpc.thrift.TSFetchResultsReq;
import org.apache.iotdb.service.rpc.thrift.TSFetchResultsResp;
import org.apache.iotdb.service.rpc.thrift.TSGetTimeZoneResp;
import org.apache.iotdb.service.rpc.thrift.TSInsertRecordReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertRecordsOfOneDeviceReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertRecordsReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertStringRecordReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertStringRecordsOfOneDeviceReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertStringRecordsReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertTabletReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertTabletsReq;
import org.apache.iotdb.service.rpc.thrift.TSLastDataQueryReq;
import org.apache.iotdb.service.rpc.thrift.TSOpenSessionReq;
import org.apache.iotdb.service.rpc.thrift.TSOpenSessionResp;
import org.apache.iotdb.service.rpc.thrift.TSPruneSchemaTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSQueryDataSet;
import org.apache.iotdb.service.rpc.thrift.TSQueryNonAlignDataSet;
import org.apache.iotdb.service.rpc.thrift.TSQueryTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSQueryTemplateResp;
import org.apache.iotdb.service.rpc.thrift.TSRawDataQueryReq;
import org.apache.iotdb.service.rpc.thrift.TSSetSchemaTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSSetTimeZoneReq;
import org.apache.iotdb.service.rpc.thrift.TSTracingInfo;
import org.apache.iotdb.service.rpc.thrift.TSUnsetSchemaTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSyncIdentityInfo;
import org.apache.iotdb.service.rpc.thrift.TSyncTransportMetaInfo;
import org.apache.iotdb.tsfile.exception.filter.QueryFilterOptimizationException;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TSServiceImpl
implements IClientRPCServiceWithHandler {
    private static final SessionManager SESSION_MANAGER = SessionManager.getInstance();
    private static final Logger LOGGER = LoggerFactory.getLogger(TSServiceImpl.class);
    private static final String INFO_INTERRUPT_ERROR = "Current Thread interrupted when dealing with request {}";
    protected final ServiceProvider serviceProvider = IoTDB.serviceProvider;

    public TSExecuteStatementResp executeQueryStatementV2(TSExecuteStatementReq req) throws TException {
        return null;
    }

    public TSExecuteStatementResp executeUpdateStatementV2(TSExecuteStatementReq req) throws TException {
        return null;
    }

    public TSExecuteStatementResp executeStatementV2(TSExecuteStatementReq req) throws TException {
        return null;
    }

    public TSExecuteStatementResp executeRawDataQueryV2(TSRawDataQueryReq req) throws TException {
        return null;
    }

    public TSExecuteStatementResp executeLastDataQueryV2(TSLastDataQueryReq req) throws TException {
        return null;
    }

    public TSFetchResultsResp fetchResultsV2(TSFetchResultsReq req) throws TException {
        return null;
    }

    public TSOpenSessionResp openSession(TSOpenSessionReq req) throws TException {
        IoTDBConstant.ClientVersion clientVersion = this.parseClientVersion(req);
        BasicOpenSessionResp openSessionResp = SESSION_MANAGER.login(SESSION_MANAGER.getCurrSession(), req.username, req.password, req.zoneId, req.client_protocol, clientVersion);
        TSStatus tsStatus = RpcUtils.getStatus((int)openSessionResp.getCode(), (String)openSessionResp.getMessage());
        TSOpenSessionResp resp = new TSOpenSessionResp(tsStatus, ServiceProvider.CURRENT_RPC_VERSION);
        return resp.setSessionId(openSessionResp.getSessionId());
    }

    private IoTDBConstant.ClientVersion parseClientVersion(TSOpenSessionReq req) {
        Map configuration = req.configuration;
        if (configuration != null && configuration.containsKey("version")) {
            return IoTDBConstant.ClientVersion.valueOf((String)((String)configuration.get("version")));
        }
        return IoTDBConstant.ClientVersion.V_0_12;
    }

    public TSStatus closeSession(TSCloseSessionReq req) {
        throw new UnsupportedOperationException();
    }

    public TSStatus cancelOperation(TSCancelOperationReq req) {
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.QUERY_NOT_ALLOWED, (String)"Cancellation is not implemented");
    }

    public TSStatus closeOperation(TSCloseOperationReq req) {
        throw new UnsupportedOperationException();
    }

    public TSFetchMetadataResp fetchMetadata(TSFetchMetadataReq req) {
        TSStatus status;
        TSFetchMetadataResp resp = new TSFetchMetadataResp();
        if (!SESSION_MANAGER.checkLogin(SESSION_MANAGER.getCurrSession())) {
            return resp.setStatus(this.getNotLoggedInStatus());
        }
        try {
            switch (req.getType()) {
                case "METADATA_IN_JSON": {
                    resp.setMetadataInJson("{}");
                    status = RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
                    break;
                }
                case "COLUMN": {
                    resp.setDataType(this.getSeriesTypeByPath(new PartialPath(req.getColumnPath())).toString());
                    status = RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
                    break;
                }
                case "ALL_COLUMNS": {
                    resp.setColumnsList(this.getPaths(new PartialPath(req.getColumnPath())).stream().map(PartialPath::getFullPath).collect(Collectors.toList()));
                    status = RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
                    break;
                }
                default: {
                    status = RpcUtils.getStatus((TSStatusCode)TSStatusCode.METADATA_ERROR, (String)req.getType());
                    break;
                }
            }
        }
        catch (MetadataException e) {
            LOGGER.error(String.format("Failed to fetch timeseries %s's metadata", req.getColumnPath()), (Throwable)e);
            status = RpcUtils.getStatus((TSStatusCode)TSStatusCode.METADATA_ERROR, (String)e.getMessage());
        }
        catch (Exception e) {
            status = ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.FETCH_METADATA, TSStatusCode.INTERNAL_SERVER_ERROR);
        }
        return resp.setStatus(status);
    }

    protected List<MeasurementPath> getPaths(PartialPath path) throws MetadataException {
        return IoTDB.schemaProcessor.getMeasurementPaths(path);
    }

    protected TSDataType getSeriesTypeByPath(PartialPath path) throws MetadataException {
        return IoTDB.schemaProcessor.getSeriesType(path);
    }

    public TSStatus executeBatchStatement(TSExecuteBatchStatementReq req) {
        return null;
    }

    public TSExecuteStatementResp executeStatement(TSExecuteStatementReq req) {
        String statement = req.getStatement();
        try {
            if (!SESSION_MANAGER.checkLogin(SESSION_MANAGER.getCurrSession())) {
                return RpcUtils.getTSExecuteStatementResp((TSStatus)this.getNotLoggedInStatus());
            }
            long startTime = System.currentTimeMillis();
            PhysicalPlan physicalPlan = this.serviceProvider.getPlanner().parseSQLToPhysicalPlan(statement, SESSION_MANAGER.getCurrSession().getZoneId(), SESSION_MANAGER.getCurrSession().getClientVersion());
            if (physicalPlan.isQuery()) {
                return this.submitQueryTask(physicalPlan, startTime, req);
            }
            return this.executeUpdateStatement(statement, req.statementId, physicalPlan, req.fetchSize, req.timeout, req.getSessionId());
        }
        catch (InterruptedException e) {
            LOGGER.error(INFO_INTERRUPT_ERROR, (Object)req, (Object)e);
            Thread.currentThread().interrupt();
            return RpcUtils.getTSExecuteStatementResp((TSStatus)ErrorHandlingUtils.onQueryException((Exception)e, "\"" + statement + "\". " + (Object)((Object)OperationType.EXECUTE_STATEMENT)));
        }
        catch (Exception e) {
            return RpcUtils.getTSExecuteStatementResp((TSStatus)ErrorHandlingUtils.onQueryException(e, "\"" + statement + "\". " + (Object)((Object)OperationType.EXECUTE_STATEMENT)));
        }
    }

    public TSExecuteStatementResp executeQueryStatement(TSExecuteStatementReq req) {
        try {
            if (!SESSION_MANAGER.checkLogin(SESSION_MANAGER.getCurrSession())) {
                return RpcUtils.getTSExecuteStatementResp((TSStatus)this.getNotLoggedInStatus());
            }
            long startTime = System.currentTimeMillis();
            String statement = req.getStatement();
            PhysicalPlan physicalPlan = this.serviceProvider.getPlanner().parseSQLToPhysicalPlan(statement, SESSION_MANAGER.getCurrSession().getZoneId(), SESSION_MANAGER.getCurrSession().getClientVersion());
            if (physicalPlan.isQuery()) {
                return this.submitQueryTask(physicalPlan, startTime, req);
            }
            return RpcUtils.getTSExecuteStatementResp((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)"Statement is not a query statement.");
        }
        catch (InterruptedException e) {
            LOGGER.error(INFO_INTERRUPT_ERROR, (Object)req, (Object)e);
            Thread.currentThread().interrupt();
            return RpcUtils.getTSExecuteStatementResp((TSStatus)ErrorHandlingUtils.onQueryException((Exception)e, "\"" + req.getStatement() + "\". " + (Object)((Object)OperationType.EXECUTE_QUERY_STATEMENT)));
        }
        catch (Exception e) {
            return RpcUtils.getTSExecuteStatementResp((TSStatus)ErrorHandlingUtils.onQueryException(e, "\"" + req.getStatement() + "\". " + (Object)((Object)OperationType.EXECUTE_QUERY_STATEMENT)));
        }
    }

    public TSExecuteStatementResp executeRawDataQuery(TSRawDataQueryReq req) {
        try {
            if (!SESSION_MANAGER.checkLogin(SESSION_MANAGER.getCurrSession())) {
                return RpcUtils.getTSExecuteStatementResp((TSStatus)this.getNotLoggedInStatus());
            }
            long startTime = System.currentTimeMillis();
            PhysicalPlan physicalPlan = this.serviceProvider.getPlanner().rawDataQueryReqToPhysicalPlan(req, SESSION_MANAGER.getCurrSession().getZoneId(), SESSION_MANAGER.getCurrSession().getClientVersion());
            if (physicalPlan.isQuery()) {
                Future<TSExecuteStatementResp> resp = QueryTaskManager.getInstance().submit(new QueryTask(physicalPlan, startTime, SESSION_MANAGER.getCurrSession(), "", req.statementId, ServiceProvider.CONFIG.getQueryTimeoutThreshold(), req.fetchSize, req.isJdbcQuery(), req.enableRedirectQuery));
                return resp.get();
            }
            return RpcUtils.getTSExecuteStatementResp((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)"Statement is not a query statement.");
        }
        catch (InterruptedException e) {
            LOGGER.error(INFO_INTERRUPT_ERROR, (Object)req, (Object)e);
            Thread.currentThread().interrupt();
            return RpcUtils.getTSExecuteStatementResp((TSStatus)ErrorHandlingUtils.onQueryException((Exception)e, OperationType.EXECUTE_RAW_DATA_QUERY));
        }
        catch (Exception e) {
            return RpcUtils.getTSExecuteStatementResp((TSStatus)ErrorHandlingUtils.onQueryException(e, OperationType.EXECUTE_RAW_DATA_QUERY));
        }
    }

    public TSExecuteStatementResp executeLastDataQuery(TSLastDataQueryReq req) {
        try {
            if (!SESSION_MANAGER.checkLogin(SESSION_MANAGER.getCurrSession())) {
                return RpcUtils.getTSExecuteStatementResp((TSStatus)this.getNotLoggedInStatus());
            }
            long startTime = System.currentTimeMillis();
            PhysicalPlan physicalPlan = this.serviceProvider.getPlanner().lastDataQueryReqToPhysicalPlan(req, SESSION_MANAGER.getCurrSession().getZoneId(), SESSION_MANAGER.getCurrSession().getClientVersion());
            if (physicalPlan.isQuery()) {
                Future<TSExecuteStatementResp> resp = QueryTaskManager.getInstance().submit(new QueryTask(physicalPlan, startTime, SESSION_MANAGER.getCurrSession(), "", req.statementId, ServiceProvider.CONFIG.getQueryTimeoutThreshold(), req.fetchSize, req.isJdbcQuery(), req.enableRedirectQuery));
                return resp.get();
            }
            return RpcUtils.getTSExecuteStatementResp((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)"Statement is not a query statement.");
        }
        catch (InterruptedException e) {
            LOGGER.error(INFO_INTERRUPT_ERROR, (Object)req, (Object)e);
            Thread.currentThread().interrupt();
            return RpcUtils.getTSExecuteStatementResp((TSStatus)ErrorHandlingUtils.onQueryException((Exception)e, OperationType.EXECUTE_LAST_DATA_QUERY));
        }
        catch (Exception e) {
            return RpcUtils.getTSExecuteStatementResp((TSStatus)ErrorHandlingUtils.onQueryException(e, OperationType.EXECUTE_LAST_DATA_QUERY));
        }
    }

    private TSExecuteStatementResp submitQueryTask(PhysicalPlan physicalPlan, long startTime, TSExecuteStatementReq req) throws Exception {
        TSStatus status = SESSION_MANAGER.checkAuthority(physicalPlan, SESSION_MANAGER.getCurrSession());
        if (status != null) {
            return new TSExecuteStatementResp(status);
        }
        QueryTask queryTask = new QueryTask(physicalPlan, startTime, SESSION_MANAGER.getCurrSession(), req.statement, req.statementId, req.timeout, req.fetchSize, req.jdbcQuery, req.enableRedirectQuery);
        TSExecuteStatementResp resp = physicalPlan instanceof ShowQueryProcesslistPlan ? queryTask.call() : QueryTaskManager.getInstance().submit(queryTask).get();
        return resp;
    }

    private TSExecuteStatementResp executeQueryPlan(QueryPlan plan, QueryContext context, boolean isJdbcQuery, int fetchSize, String username) throws TException, MetadataException, QueryProcessException, StorageEngineException, SQLException, IOException, InterruptedException, QueryFilterOptimizationException, AuthException {
        List<? extends PartialPath> authPaths = plan.getAuthPaths();
        if (authPaths != null && !authPaths.isEmpty() && !SESSION_MANAGER.checkAuthorization(plan, username)) {
            return RpcUtils.getTSExecuteStatementResp((TSStatus)RpcUtils.getStatus((TSStatusCode)TSStatusCode.NO_PERMISSION, (String)("No permissions for this operation, please add privilege " + (Object)((Object)Operator.OperatorType.values()[AuthorityChecker.translateToPermissionId(plan.getOperatorType())]))));
        }
        long queryId = context.getQueryId();
        if (plan.isEnableTracing()) {
            context.setEnableTracing(true);
            ServiceProvider.TRACING_MANAGER.setStartTime(queryId, context.getStartTime(), context.getStatement());
            ServiceProvider.TRACING_MANAGER.registerActivity(queryId, "Parse SQL to physical plan", System.currentTimeMillis());
            ServiceProvider.TRACING_MANAGER.setSeriesPathNum(queryId, plan.getPaths().size());
        }
        TSExecuteStatementResp resp = null;
        if (!(plan instanceof UDFPlan)) {
            resp = plan.getTSExecuteStatementResp(isJdbcQuery);
        }
        QueryDataSet newDataSet = this.serviceProvider.createQueryDataSet(context, plan, fetchSize);
        if (plan.isEnableTracing()) {
            ServiceProvider.TRACING_MANAGER.registerActivity(queryId, "Create and cache dataset", System.currentTimeMillis());
        }
        if (newDataSet.getEndPoint() != null && plan.isEnableRedirect()) {
            QueryDataSet.EndPoint endPoint = newDataSet.getEndPoint();
            return this.redirectQueryToAnotherNode(resp, context, endPoint.getIp(), endPoint.getPort());
        }
        if (plan instanceof UDFPlan || plan.isGroupByLevel()) {
            resp = plan.getTSExecuteStatementResp(isJdbcQuery);
        }
        if (newDataSet instanceof DirectNonAlignDataSet) {
            resp.setNonAlignQueryDataSet(this.fillRpcNonAlignReturnData(fetchSize, newDataSet, username));
        } else {
            try {
                TSQueryDataSet tsQueryDataSet = this.fillRpcReturnData(fetchSize, newDataSet, username);
                resp.setQueryDataSet(tsQueryDataSet);
            }
            catch (RedirectException e) {
                if (plan.isEnableRedirect()) {
                    TEndPoint endPoint = e.getEndPoint();
                    return this.redirectQueryToAnotherNode(resp, context, endPoint.ip, endPoint.port);
                }
                LOGGER.error("execute {} error, if session does not support redirect, should not throw redirection exception.", (Object)context.getStatement(), (Object)e);
            }
        }
        if (plan.isEnableTracing()) {
            ServiceProvider.TRACING_MANAGER.registerActivity(queryId, "Request complete", System.currentTimeMillis());
            TSTracingInfo tsTracingInfo = this.fillRpcReturnTracingInfo(queryId);
            resp.setTracingInfo(tsTracingInfo);
        }
        return resp;
    }

    private TSExecuteStatementResp executeShowOrAuthorPlan(PhysicalPlan plan, QueryContext context, int fetchSize, String username) throws QueryProcessException, TException, StorageEngineException, SQLException, IOException, InterruptedException, QueryFilterOptimizationException, MetadataException, AuthException {
        QueryDataSet newDataSet = this.serviceProvider.createQueryDataSet(context, plan, fetchSize);
        TSExecuteStatementResp resp = this.getListDataSetResp(plan, newDataSet);
        resp.setQueryDataSet(this.fillRpcReturnData(fetchSize, newDataSet, username));
        return resp;
    }

    private TSExecuteStatementResp getListDataSetResp(PhysicalPlan plan, QueryDataSet dataSet) {
        TSExecuteStatementResp resp = StaticResps.getNoTimeExecuteResp(dataSet.getPaths().stream().map(Path::getFullPath).collect(Collectors.toList()), dataSet.getDataTypes().stream().map(Enum::toString).collect(Collectors.toList()));
        if (plan instanceof ShowQueryProcesslistPlan) {
            resp.setIgnoreTimeStamp(false);
        }
        return resp;
    }

    private TSExecuteStatementResp redirectQueryToAnotherNode(TSExecuteStatementResp resp, QueryContext context, String ip, int port) {
        LOGGER.debug("need to redirect {} {} to node {}:{}", new Object[]{context.getStatement(), context.getQueryId(), ip, port});
        TSStatus status = new TSStatus();
        status.setRedirectNode(new TEndPoint(ip, port));
        status.setCode(TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode());
        resp.setStatus(status);
        resp.setQueryId(context.getQueryId());
        return resp;
    }

    public TSFetchResultsResp fetchResults(TSFetchResultsReq req) {
        try {
            if (!SESSION_MANAGER.checkLogin(SESSION_MANAGER.getCurrSession())) {
                return RpcUtils.getTSFetchResultsResp((TSStatus)this.getNotLoggedInStatus());
            }
            Future<TSFetchResultsResp> resp = QueryTaskManager.getInstance().submit(new FetchResultsTask(SESSION_MANAGER.getCurrSession(), req.queryId, req.fetchSize, req.isAlign));
            return resp.get();
        }
        catch (InterruptedException e) {
            LOGGER.error(INFO_INTERRUPT_ERROR, (Object)req, (Object)e);
            Thread.currentThread().interrupt();
            return RpcUtils.getTSFetchResultsResp((TSStatus)ErrorHandlingUtils.onQueryException((Exception)e, OperationType.FETCH_RESULTS));
        }
        catch (Exception e) {
            return RpcUtils.getTSFetchResultsResp((TSStatus)ErrorHandlingUtils.onQueryException(e, OperationType.FETCH_RESULTS));
        }
    }

    private TSQueryDataSet fillRpcReturnData(int fetchSize, QueryDataSet queryDataSet, String userName) throws TException, AuthException, IOException, InterruptedException, QueryProcessException {
        WatermarkEncoder encoder = this.getWatermarkEncoder(userName);
        return queryDataSet instanceof DirectAlignByTimeDataSet ? ((DirectAlignByTimeDataSet)queryDataSet).fillBuffer(fetchSize, encoder) : QueryDataSetUtils.convertQueryDataSetByFetchSize(queryDataSet, fetchSize, encoder);
    }

    private TSQueryNonAlignDataSet fillRpcNonAlignReturnData(int fetchSize, QueryDataSet queryDataSet, String userName) throws TException, AuthException, IOException, QueryProcessException, InterruptedException {
        WatermarkEncoder encoder = this.getWatermarkEncoder(userName);
        return ((DirectNonAlignDataSet)queryDataSet).fillBuffer(fetchSize, encoder);
    }

    private TSTracingInfo fillRpcReturnTracingInfo(long queryId) {
        return ServiceProvider.TRACING_MANAGER.fillRpcReturnTracingInfo(queryId);
    }

    private WatermarkEncoder getWatermarkEncoder(String userName) throws TException, AuthException {
        AuthorizerManager authorizer = AuthorizerManager.getInstance();
        GroupedLSBWatermarkEncoder encoder = null;
        if (ServiceProvider.CONFIG.isEnableWatermark() && authorizer.isUserUseWaterMark(userName)) {
            if (ServiceProvider.CONFIG.getWatermarkMethodName().equals("GroupBasedLSBMethod")) {
                encoder = new GroupedLSBWatermarkEncoder(ServiceProvider.CONFIG);
            } else {
                throw new UnSupportedDataTypeException(String.format("Watermark method is not supported yet: %s", ServiceProvider.CONFIG.getWatermarkMethodName()));
            }
        }
        return encoder;
    }

    public TSExecuteStatementResp executeUpdateStatement(TSExecuteStatementReq req) {
        if (!SESSION_MANAGER.checkLogin(SESSION_MANAGER.getCurrSession())) {
            return RpcUtils.getTSExecuteStatementResp((TSStatus)this.getNotLoggedInStatus());
        }
        try {
            PhysicalPlan physicalPlan = this.serviceProvider.getPlanner().parseSQLToPhysicalPlan(req.statement, SESSION_MANAGER.getCurrSession().getZoneId(), SESSION_MANAGER.getCurrSession().getClientVersion());
            return physicalPlan.isQuery() ? RpcUtils.getTSExecuteStatementResp((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)"Statement is a query statement.") : this.executeUpdateStatement(req.statement, req.statementId, physicalPlan, req.fetchSize, req.timeout, req.getSessionId());
        }
        catch (InterruptedException e) {
            LOGGER.error(INFO_INTERRUPT_ERROR, (Object)req, (Object)e);
            Thread.currentThread().interrupt();
            return RpcUtils.getTSExecuteStatementResp((TSStatus)ErrorHandlingUtils.onQueryException((Exception)e, "\"" + req.statement + "\". " + (Object)((Object)OperationType.EXECUTE_UPDATE_STATEMENT)));
        }
        catch (Exception e) {
            return RpcUtils.getTSExecuteStatementResp((TSStatus)ErrorHandlingUtils.onQueryException(e, "\"" + req.statement + "\". " + (Object)((Object)OperationType.EXECUTE_UPDATE_STATEMENT)));
        }
    }

    private TSExecuteStatementResp executeUpdateStatement(String statement, long statementId, PhysicalPlan plan, int fetchSize, long timeout, long sessionId) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    private TSExecuteStatementResp executeNonQueryStatement(PhysicalPlan plan) {
        TSStatus status = SESSION_MANAGER.checkAuthority(plan, SESSION_MANAGER.getCurrSession());
        return status != null ? new TSExecuteStatementResp(status) : RpcUtils.getTSExecuteStatementResp((TSStatus)this.executeNonQueryPlan(plan)).setQueryId(SESSION_MANAGER.requestQueryId());
    }

    @Override
    public void handleClientExit() {
        IClientSession session = SESSION_MANAGER.getCurrSession();
        if (session != null) {
            TSCloseSessionReq req = new TSCloseSessionReq();
            this.closeSession(req);
        }
        SyncService.getInstance().handleClientExit();
    }

    public TSGetTimeZoneResp getTimeZone(long sessionId) {
        try {
            ZoneId zoneId = SESSION_MANAGER.getCurrSession().getZoneId();
            return new TSGetTimeZoneResp(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS), zoneId != null ? zoneId.toString() : "Unknown time zone");
        }
        catch (Exception e) {
            return new TSGetTimeZoneResp(ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.GET_TIME_ZONE, TSStatusCode.GENERATE_TIME_ZONE_ERROR), "Unknown time zone");
        }
    }

    public TSStatus setTimeZone(TSSetTimeZoneReq req) {
        try {
            SESSION_MANAGER.getCurrSession().setZoneId(ZoneId.of(req.timeZone));
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
        }
        catch (Exception e) {
            return ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.SET_TIME_ZONE, TSStatusCode.SET_TIME_ZONE_ERROR);
        }
    }

    public ServerProperties getProperties() {
        ServerProperties properties = new ServerProperties();
        properties.setVersion(IoTDBConstant.VERSION);
        properties.setBuildInfo(IoTDBConstant.BUILD_INFO);
        LOGGER.info("IoTDB server version: {}", (Object)IoTDBConstant.VERSION_WITH_BUILD);
        properties.setSupportedTimeAggregationOperations(new ArrayList());
        properties.getSupportedTimeAggregationOperations().add("max_time");
        properties.getSupportedTimeAggregationOperations().add("min_time");
        properties.setTimestampPrecision(IoTDBDescriptor.getInstance().getConfig().getTimestampPrecision());
        properties.setMaxConcurrentClientNum(IoTDBDescriptor.getInstance().getConfig().getRpcMaxConcurrentClientNum());
        properties.setWatermarkSecretKey(IoTDBDescriptor.getInstance().getConfig().getWatermarkSecretKey());
        properties.setWatermarkBitString(IoTDBDescriptor.getInstance().getConfig().getWatermarkBitString());
        properties.setWatermarkParamMarkRate(IoTDBDescriptor.getInstance().getConfig().getWatermarkParamMarkRate());
        properties.setWatermarkParamMaxRightBit(IoTDBDescriptor.getInstance().getConfig().getWatermarkParamMaxRightBit());
        properties.setIsReadOnly(CommonDescriptor.getInstance().getConfig().isReadOnly());
        properties.setThriftMaxFrameSize(IoTDBDescriptor.getInstance().getConfig().getThriftMaxFrameSize());
        return properties;
    }

    public TSStatus insertRecords(TSInsertRecordsReq req) {
        return null;
    }

    private TSStatus judgeFinalTsStatus(boolean allCheckSuccess, TSStatus executeTsStatus, Map<Integer, TSStatus> checkTsStatus, int totalRowCount) {
        if (allCheckSuccess) {
            return executeTsStatus;
        }
        if (executeTsStatus.subStatus == null) {
            Object[] tmpSubTsStatus = new TSStatus[totalRowCount];
            Arrays.fill(tmpSubTsStatus, RpcUtils.SUCCESS_STATUS);
            executeTsStatus.subStatus = Arrays.asList(tmpSubTsStatus);
        }
        for (Map.Entry<Integer, TSStatus> entry : checkTsStatus.entrySet()) {
            executeTsStatus.subStatus.set(entry.getKey(), entry.getValue());
        }
        return RpcUtils.getStatus((List)executeTsStatus.subStatus);
    }

    public TSStatus insertRecordsOfOneDevice(TSInsertRecordsOfOneDeviceReq req) {
        return null;
    }

    public TSStatus insertStringRecordsOfOneDevice(TSInsertStringRecordsOfOneDeviceReq req) {
        return null;
    }

    public TSStatus insertStringRecords(TSInsertStringRecordsReq req) {
        return null;
    }

    public TSStatus testInsertTablet(TSInsertTabletReq req) {
        LOGGER.debug("Test insert batch request receive.");
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus testInsertTablets(TSInsertTabletsReq req) {
        LOGGER.debug("Test insert batch request receive.");
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus testInsertRecord(TSInsertRecordReq req) {
        LOGGER.debug("Test insert row request receive.");
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus testInsertStringRecord(TSInsertStringRecordReq req) {
        LOGGER.debug("Test insert string record request receive.");
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus testInsertRecords(TSInsertRecordsReq req) {
        LOGGER.debug("Test insert row in batch request receive.");
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus testInsertRecordsOfOneDevice(TSInsertRecordsOfOneDeviceReq req) {
        LOGGER.debug("Test insert rows in batch request receive.");
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus testInsertStringRecords(TSInsertStringRecordsReq req) {
        LOGGER.debug("Test insert string records request receive.");
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus insertRecord(TSInsertRecordReq req) {
        return null;
    }

    public TSStatus insertStringRecord(TSInsertStringRecordReq req) {
        return null;
    }

    public TSStatus deleteData(TSDeleteDataReq req) {
        return null;
    }

    public TSStatus insertTablet(TSInsertTabletReq req) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus insertTablets(TSInsertTabletsReq req) {
        long t1 = System.currentTimeMillis();
        try {
            if (!SESSION_MANAGER.checkLogin(SESSION_MANAGER.getCurrSession())) {
                TSStatus tSStatus = this.getNotLoggedInStatus();
                return tSStatus;
            }
            TSStatus tSStatus = this.insertTabletsInternally(req);
            return tSStatus;
        }
        catch (IoTDBException e) {
            TSStatus tSStatus = ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.INSERT_TABLETS, e.getErrorCode());
            return tSStatus;
        }
        catch (NullPointerException e) {
            LOGGER.error("{}: error occurs when insertTablets", (Object)"IoTDB", (Object)e);
            TSStatus tSStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR);
            return tSStatus;
        }
        catch (Exception e) {
            TSStatus tSStatus = ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.INSERT_TABLETS, TSStatusCode.EXECUTE_STATEMENT_ERROR);
            return tSStatus;
        }
        finally {
            this.addOperationLatency(Operation.EXECUTE_RPC_BATCH_INSERT, t1);
        }
    }

    public TSStatus insertTabletsInternally(TSInsertTabletsReq req) throws MetadataException {
        return null;
    }

    public TSStatus setStorageGroup(long sessionId, String storageGroup) {
        try {
            if (!SESSION_MANAGER.checkLogin(SESSION_MANAGER.getCurrSession())) {
                return this.getNotLoggedInStatus();
            }
            SetStorageGroupPlan plan = new SetStorageGroupPlan(new PartialPath(storageGroup));
            TSStatus status = SESSION_MANAGER.checkAuthority(plan, SESSION_MANAGER.getCurrSession());
            return status != null ? status : this.executeNonQueryPlan(plan);
        }
        catch (IoTDBException e) {
            return ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.SET_STORAGE_GROUP, e.getErrorCode());
        }
        catch (Exception e) {
            return ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.SET_STORAGE_GROUP, TSStatusCode.EXECUTE_STATEMENT_ERROR);
        }
    }

    public TSStatus deleteStorageGroups(long sessionId, List<String> storageGroups) {
        try {
            if (!SESSION_MANAGER.checkLogin(SESSION_MANAGER.getCurrSession())) {
                return this.getNotLoggedInStatus();
            }
            ArrayList<PartialPath> storageGroupList = new ArrayList<PartialPath>();
            for (String storageGroup : storageGroups) {
                storageGroupList.add(new PartialPath(storageGroup));
            }
            DeleteStorageGroupPlan plan = new DeleteStorageGroupPlan(storageGroupList);
            TSStatus status = SESSION_MANAGER.checkAuthority(plan, SESSION_MANAGER.getCurrSession());
            return status != null ? status : this.executeNonQueryPlan(plan);
        }
        catch (IoTDBException e) {
            return ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.DELETE_STORAGE_GROUPS, e.getErrorCode());
        }
        catch (Exception e) {
            return ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.DELETE_STORAGE_GROUPS, TSStatusCode.EXECUTE_STATEMENT_ERROR);
        }
    }

    public TSStatus createTimeseries(TSCreateTimeseriesReq req) {
        try {
            if (!SESSION_MANAGER.checkLogin(SESSION_MANAGER.getCurrSession())) {
                return this.getNotLoggedInStatus();
            }
            if (ServiceProvider.AUDIT_LOGGER.isDebugEnabled()) {
                ServiceProvider.AUDIT_LOGGER.debug("Session-{} create timeseries {}", (Object)SESSION_MANAGER.getCurrSession(), (Object)req.getPath());
            }
            PathUtils.isLegalSingleMeasurements(Collections.singletonList(req.getMeasurementAlias()));
            CreateTimeSeriesPlan plan = new CreateTimeSeriesPlan(new PartialPath(req.path), TSDataType.values()[req.dataType], TSEncoding.values()[req.encoding], CompressionType.deserialize((byte)((byte)req.compressor)), req.props, req.tags, req.attributes, req.measurementAlias);
            TSStatus status = SESSION_MANAGER.checkAuthority(plan, SESSION_MANAGER.getCurrSession());
            return status != null ? status : this.executeNonQueryPlan(plan);
        }
        catch (IoTDBException e) {
            return ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.CREATE_TIMESERIES, e.getErrorCode());
        }
        catch (Exception e) {
            return ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.CREATE_TIMESERIES, TSStatusCode.EXECUTE_STATEMENT_ERROR);
        }
    }

    public TSStatus createAlignedTimeseries(TSCreateAlignedTimeseriesReq req) {
        try {
            if (!SESSION_MANAGER.checkLogin(SESSION_MANAGER.getCurrSession())) {
                return this.getNotLoggedInStatus();
            }
            PathUtils.isLegalSingleMeasurements((List)req.getMeasurements());
            PathUtils.isLegalSingleMeasurements((List)req.getMeasurementAlias());
            if (ServiceProvider.AUDIT_LOGGER.isDebugEnabled()) {
                ServiceProvider.AUDIT_LOGGER.debug("Session-{} create aligned timeseries {}.{}", new Object[]{SESSION_MANAGER.getCurrSession(), req.getPrefixPath(), req.getMeasurements()});
            }
            ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
            Iterator iterator = req.dataTypes.iterator();
            while (iterator.hasNext()) {
                int dataType = (Integer)iterator.next();
                dataTypes.add(TSDataType.values()[dataType]);
            }
            ArrayList<TSEncoding> encodings = new ArrayList<TSEncoding>();
            Iterator dataType = req.encodings.iterator();
            while (dataType.hasNext()) {
                int encoding = (Integer)dataType.next();
                encodings.add(TSEncoding.values()[encoding]);
            }
            ArrayList<CompressionType> compressors = new ArrayList<CompressionType>();
            Iterator encoding = req.compressors.iterator();
            while (encoding.hasNext()) {
                int compressor = (Integer)encoding.next();
                compressors.add(CompressionType.deserialize((byte)((byte)compressor)));
            }
            CreateAlignedTimeSeriesPlan plan = new CreateAlignedTimeSeriesPlan(new PartialPath(req.prefixPath), req.measurements, dataTypes, encodings, compressors, req.measurementAlias, req.tagsList, req.attributesList);
            TSStatus status = SESSION_MANAGER.checkAuthority(plan, SESSION_MANAGER.getCurrSession());
            return status != null ? status : this.executeNonQueryPlan(plan);
        }
        catch (IoTDBException e) {
            return ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.CREATE_ALIGNED_TIMESERIES, e.getErrorCode());
        }
        catch (Exception e) {
            return ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.CREATE_ALIGNED_TIMESERIES, TSStatusCode.EXECUTE_STATEMENT_ERROR);
        }
    }

    public TSStatus createMultiTimeseries(TSCreateMultiTimeseriesReq req) {
        try {
            int i;
            if (!SESSION_MANAGER.checkLogin(SESSION_MANAGER.getCurrSession())) {
                return this.getNotLoggedInStatus();
            }
            if (ServiceProvider.AUDIT_LOGGER.isDebugEnabled()) {
                ServiceProvider.AUDIT_LOGGER.debug("Session-{} create {} timeseries, the first is {}", new Object[]{SESSION_MANAGER.getCurrSession(), req.getPaths().size(), req.getPaths().get(0)});
            }
            PathUtils.isLegalSingleMeasurements((List)req.measurementAliasList);
            CreateMultiTimeSeriesPlan multiPlan = new CreateMultiTimeSeriesPlan();
            ArrayList<PartialPath> paths = new ArrayList<PartialPath>(req.paths.size());
            ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>(req.dataTypes.size());
            ArrayList<TSEncoding> encodings = new ArrayList<TSEncoding>(req.dataTypes.size());
            ArrayList<CompressionType> compressors = new ArrayList<CompressionType>(req.paths.size());
            ArrayList<String> alias = null;
            if (req.measurementAliasList != null) {
                alias = new ArrayList<String>(req.paths.size());
            }
            ArrayList<Map<String, String>> props = null;
            if (req.propsList != null) {
                props = new ArrayList<Map<String, String>>(req.paths.size());
            }
            ArrayList<Map<String, String>> tags = null;
            if (req.tagsList != null) {
                tags = new ArrayList<Map<String, String>>(req.paths.size());
            }
            ArrayList<Map<String, String>> attributes = null;
            if (req.attributesList != null) {
                attributes = new ArrayList<Map<String, String>>(req.paths.size());
            }
            CreateTimeSeriesPlan plan = new CreateTimeSeriesPlan();
            for (i = 0; i < req.paths.size(); ++i) {
                plan.setPath(new PartialPath((String)req.paths.get(i)));
                TSStatus status = SESSION_MANAGER.checkAuthority(plan, SESSION_MANAGER.getCurrSession());
                if (status != null) {
                    multiPlan.getResults().put(i, status);
                }
                paths.add(new PartialPath((String)req.paths.get(i)));
                compressors.add(CompressionType.deserialize((byte)((Integer)req.compressors.get(i)).byteValue()));
                if (alias != null) {
                    alias.add((String)req.measurementAliasList.get(i));
                }
                if (props != null) {
                    props.add((Map)req.propsList.get(i));
                }
                if (tags != null) {
                    tags.add((Map)req.tagsList.get(i));
                }
                if (attributes == null) continue;
                attributes.add((Map)req.attributesList.get(i));
            }
            for (i = 0; i < req.dataTypes.size(); ++i) {
                dataTypes.add(TSDataType.values()[(Integer)req.dataTypes.get(i)]);
                encodings.add(TSEncoding.values()[(Integer)req.encodings.get(i)]);
            }
            multiPlan.setPaths(paths);
            multiPlan.setDataTypes(dataTypes);
            multiPlan.setEncodings(encodings);
            multiPlan.setCompressors(compressors);
            multiPlan.setAlias(alias);
            multiPlan.setProps(props);
            multiPlan.setTags(tags);
            multiPlan.setAttributes(attributes);
            multiPlan.setIndexes(new ArrayList<Integer>());
            return this.executeNonQueryPlan(multiPlan);
        }
        catch (IoTDBException e) {
            return ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.CREATE_MULTI_TIMESERIES, e.getErrorCode());
        }
        catch (Exception e) {
            LOGGER.error("creating multi timeseries fails", (Throwable)e);
            return ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.CREATE_MULTI_TIMESERIES, TSStatusCode.EXECUTE_STATEMENT_ERROR);
        }
    }

    public TSStatus deleteTimeseries(long sessionId, List<String> paths) {
        try {
            if (!SESSION_MANAGER.checkLogin(SESSION_MANAGER.getCurrSession())) {
                return this.getNotLoggedInStatus();
            }
            ArrayList<PartialPath> pathList = new ArrayList<PartialPath>();
            for (String path : paths) {
                pathList.add(new PartialPath(path));
            }
            DeleteTimeSeriesPlan plan = new DeleteTimeSeriesPlan(pathList);
            TSStatus status = SESSION_MANAGER.checkAuthority(plan, SESSION_MANAGER.getCurrSession());
            return status != null ? status : this.executeNonQueryPlan(plan);
        }
        catch (IoTDBException e) {
            return ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.DELETE_TIMESERIES, e.getErrorCode());
        }
        catch (Exception e) {
            return ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.DELETE_TIMESERIES, TSStatusCode.EXECUTE_STATEMENT_ERROR);
        }
    }

    public long requestStatementId(long sessionId) {
        return SESSION_MANAGER.requestStatementId(SESSION_MANAGER.getCurrSession());
    }

    public TSStatus createSchemaTemplate(TSCreateSchemaTemplateReq req) throws TException {
        try {
            if (!SESSION_MANAGER.checkLogin(SESSION_MANAGER.getCurrSession())) {
                return this.getNotLoggedInStatus();
            }
            if (ServiceProvider.AUDIT_LOGGER.isDebugEnabled()) {
                ServiceProvider.AUDIT_LOGGER.debug("Session-{} create schema template {}", (Object)SESSION_MANAGER.getCurrSession(), (Object)req.getName());
            }
            ByteBuffer buffer = ByteBuffer.wrap(req.getSerializedTemplate());
            CreateTemplatePlan plan = CreateTemplatePlan.deserializeFromReq(buffer);
            PathUtils.isLegalMeasurementLists(plan.getMeasurements());
            TSStatus status = SESSION_MANAGER.checkAuthority(plan, SESSION_MANAGER.getCurrSession());
            return status != null ? status : this.executeNonQueryPlan(plan);
        }
        catch (IoTDBException e) {
            return ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.CREATE_SCHEMA_TEMPLATE, e.getErrorCode());
        }
        catch (Exception e) {
            return ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.CREATE_SCHEMA_TEMPLATE, TSStatusCode.EXECUTE_STATEMENT_ERROR);
        }
    }

    public TSStatus appendSchemaTemplate(TSAppendSchemaTemplateReq req) {
        try {
            PathUtils.isLegalMeasurements((List)req.getMeasurements());
        }
        catch (IoTDBException e) {
            ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.EXECUTE_NON_QUERY_PLAN, e.getErrorCode());
        }
        int size = req.getMeasurementsSize();
        String[] measurements = new String[size];
        TSDataType[] dataTypes = new TSDataType[size];
        TSEncoding[] encodings = new TSEncoding[size];
        CompressionType[] compressionTypes = new CompressionType[size];
        for (int i = 0; i < req.getDataTypesSize(); ++i) {
            measurements[i] = (String)req.getMeasurements().get(i);
            dataTypes[i] = TSDataType.values()[(Integer)req.getDataTypes().get(i)];
            encodings[i] = TSEncoding.values()[(Integer)req.getEncodings().get(i)];
            compressionTypes[i] = CompressionType.deserialize((byte)((Integer)req.getCompressors().get(i)).byteValue());
        }
        AppendTemplatePlan plan = new AppendTemplatePlan(req.getName(), req.isAligned, measurements, dataTypes, encodings, compressionTypes);
        TSStatus status = SESSION_MANAGER.checkAuthority(plan, SESSION_MANAGER.getCurrSession());
        return status != null ? status : this.executeNonQueryPlan(plan);
    }

    public TSStatus pruneSchemaTemplate(TSPruneSchemaTemplateReq req) {
        PruneTemplatePlan plan = new PruneTemplatePlan(req.getName(), Collections.singletonList(req.getPath()));
        TSStatus status = SESSION_MANAGER.checkAuthority(plan, SESSION_MANAGER.getCurrSession());
        return status != null ? status : this.executeNonQueryPlan(plan);
    }

    public TSQueryTemplateResp querySchemaTemplate(TSQueryTemplateReq req) {
        return null;
    }

    public TSStatus setSchemaTemplate(TSSetSchemaTemplateReq req) throws TException {
        if (!SESSION_MANAGER.checkLogin(SESSION_MANAGER.getCurrSession())) {
            return this.getNotLoggedInStatus();
        }
        if (ServiceProvider.AUDIT_LOGGER.isDebugEnabled()) {
            ServiceProvider.AUDIT_LOGGER.debug("Session-{} set device template {}.{}", new Object[]{SESSION_MANAGER.getCurrSession(), req.getTemplateName(), req.getPrefixPath()});
        }
        try {
            SetTemplatePlan plan = new SetTemplatePlan(req.templateName, req.prefixPath);
            TSStatus status = SESSION_MANAGER.checkAuthority(plan, SESSION_MANAGER.getCurrSession());
            return status != null ? status : this.executeNonQueryPlan(plan);
        }
        catch (IllegalPathException e) {
            return ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.EXECUTE_STATEMENT, e.getErrorCode());
        }
    }

    public TSStatus unsetSchemaTemplate(TSUnsetSchemaTemplateReq req) throws TException {
        if (!SESSION_MANAGER.checkLogin(SESSION_MANAGER.getCurrSession())) {
            return this.getNotLoggedInStatus();
        }
        if (ServiceProvider.AUDIT_LOGGER.isDebugEnabled()) {
            ServiceProvider.AUDIT_LOGGER.debug("Session-{} unset schema template {}.{}", new Object[]{SESSION_MANAGER.getCurrSession(), req.getPrefixPath(), req.getTemplateName()});
        }
        try {
            UnsetTemplatePlan plan = new UnsetTemplatePlan(req.prefixPath, req.templateName);
            TSStatus status = SESSION_MANAGER.checkAuthority(plan, SESSION_MANAGER.getCurrSession());
            return status != null ? status : this.executeNonQueryPlan(plan);
        }
        catch (IllegalPathException e) {
            return ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.EXECUTE_STATEMENT, e.getErrorCode());
        }
    }

    public TSStatus dropSchemaTemplate(TSDropSchemaTemplateReq req) throws TException {
        DropTemplatePlan plan;
        TSStatus status;
        if (!SESSION_MANAGER.checkLogin(SESSION_MANAGER.getCurrSession())) {
            return this.getNotLoggedInStatus();
        }
        if (ServiceProvider.AUDIT_LOGGER.isDebugEnabled()) {
            ServiceProvider.AUDIT_LOGGER.debug("Session-{} drop schema template {}.", (Object)SESSION_MANAGER.getCurrSession(), (Object)req.getTemplateName());
        }
        return (status = SESSION_MANAGER.checkAuthority(plan = new DropTemplatePlan(req.templateName), SESSION_MANAGER.getCurrSession())) != null ? status : this.executeNonQueryPlan(plan);
    }

    public TSStatus handshake(TSyncIdentityInfo info) throws TException {
        return SyncService.getInstance().handshake(info, SESSION_MANAGER.getCurrSession().getClientAddress(), null, null);
    }

    public TSStatus sendPipeData(ByteBuffer buff) throws TException {
        return SyncService.getInstance().transportPipeData(buff);
    }

    public TSStatus sendFile(TSyncTransportMetaInfo metaInfo, ByteBuffer buff) throws TException {
        return SyncService.getInstance().transportFile(metaInfo, buff);
    }

    public TSConnectionInfoResp fetchAllConnectionsInfo() {
        throw new UnsupportedOperationException();
    }

    protected TSStatus executeNonQueryPlan(PhysicalPlan plan) {
        try {
            return this.serviceProvider.executeNonQuery(plan) ? RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS, (String)"Execute successfully") : RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR);
        }
        catch (Exception e) {
            return ErrorHandlingUtils.onNonQueryException(e, OperationType.EXECUTE_NON_QUERY_PLAN);
        }
    }

    private TSStatus getNotLoggedInStatus() {
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.NOT_LOGIN, (String)"Log in failed. Either you are not authorized or the session has timed out.");
    }

    private void addOperationLatency(Operation operation, long startTime) {
        MetricService.getInstance().histogram(System.currentTimeMillis() - startTime, Metric.OPERATION.toString(), MetricLevel.IMPORTANT, new String[]{"name", operation.getName()});
    }

    private class FetchResultsTask
    implements Callable<TSFetchResultsResp> {
        private final IClientSession session;
        private final long queryId;
        private final int fetchSize;
        private final boolean isAlign;

        public FetchResultsTask(IClientSession session, long queryId, int fetchSize, boolean isAlign) {
            this.session = session;
            this.queryId = queryId;
            this.fetchSize = fetchSize;
            this.isAlign = isAlign;
        }

        @Override
        public TSFetchResultsResp call() throws Exception {
            return null;
        }
    }

    private class QueryTask
    implements Callable<TSExecuteStatementResp> {
        private final PhysicalPlan plan;
        private final long queryStartTime;
        private final IClientSession session;
        private final String statement;
        private final long statementId;
        private final long timeout;
        private final int fetchSize;
        private final boolean isJdbcQuery;
        private final boolean enableRedirectQuery;

        public QueryTask(PhysicalPlan plan, long queryStartTime, IClientSession session, String statement, long statementId, long timeout, int fetchSize, boolean isJdbcQuery, boolean enableRedirectQuery) {
            this.plan = plan;
            this.queryStartTime = queryStartTime;
            this.session = session;
            this.statement = statement;
            this.statementId = statementId;
            this.timeout = timeout;
            this.fetchSize = fetchSize;
            this.isJdbcQuery = isJdbcQuery;
            this.enableRedirectQuery = enableRedirectQuery;
        }

        @Override
        public TSExecuteStatementResp call() throws Exception {
            return null;
        }
    }
}

