/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner.plan.node.process;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.ProcessNode;

public abstract class SingleChildProcessNode
extends ProcessNode {
    protected PlanNode child;

    public SingleChildProcessNode(PlanNodeId id) {
        super(id);
    }

    public SingleChildProcessNode(PlanNodeId id, PlanNode child) {
        super(id);
        this.child = child;
    }

    public PlanNode getChild() {
        return this.child;
    }

    public void setChild(PlanNode child) {
        this.child = child;
    }

    public void cleanChildren() {
        this.child = null;
    }

    @Override
    public List<PlanNode> getChildren() {
        if (this.child == null) {
            return ImmutableList.of();
        }
        return ImmutableList.of((Object)this.child);
    }

    @Override
    public void addChild(PlanNode child) {
        this.child = child;
    }

    @Override
    public int allowedChildCount() {
        return 1;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SingleChildProcessNode that = (SingleChildProcessNode)o;
        return Objects.equals(this.child, that.child);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.child);
    }
}

