/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner.plan;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.exception.runtime.SerializationRunTimeException;
import org.apache.iotdb.commons.utils.ThriftCommonsSerDeUtils;
import org.apache.iotdb.consensus.common.request.IConsensusRequest;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.mpp.common.FragmentInstanceId;
import org.apache.iotdb.db.mpp.common.SessionInfo;
import org.apache.iotdb.db.mpp.plan.analyze.QueryType;
import org.apache.iotdb.db.mpp.plan.planner.plan.PlanFragment;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeUtil;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.sink.FragmentSinkNode;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.factory.FilterFactory;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FragmentInstance
implements IConsensusRequest {
    private final Logger logger = LoggerFactory.getLogger(FragmentInstance.class);
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private final FragmentInstanceId id;
    private final QueryType type;
    private final PlanFragment fragment;
    private TRegionReplicaSet regionReplicaSet;
    private TDataNodeLocation hostDataNode;
    private Filter timeFilter;
    private final long timeOut;
    private boolean isRoot;
    private final SessionInfo sessionInfo;

    public FragmentInstance(PlanFragment fragment, FragmentInstanceId id, Filter timeFilter, QueryType type, long timeOut, SessionInfo sessionInfo) {
        this.fragment = fragment;
        this.timeFilter = timeFilter;
        this.id = id;
        this.type = type;
        this.timeOut = timeOut > 0L ? timeOut : config.getQueryTimeoutThreshold();
        this.isRoot = false;
        this.sessionInfo = sessionInfo;
    }

    public FragmentInstance(PlanFragment fragment, FragmentInstanceId id, Filter timeFilter, QueryType type, long timeOut, SessionInfo sessionInfo, boolean isRoot) {
        this(fragment, id, timeFilter, type, timeOut, sessionInfo);
        this.isRoot = isRoot;
    }

    public TRegionReplicaSet getDataRegionId() {
        return this.regionReplicaSet;
    }

    public void setDataRegionAndHost(TRegionReplicaSet regionReplicaSet) {
        if (regionReplicaSet == null) {
            return;
        }
        this.regionReplicaSet = regionReplicaSet;
        this.hostDataNode = IoTDBDescriptor.getInstance().getConfig().isClusterMode() ? (TDataNodeLocation)regionReplicaSet.getDataNodeLocations().get(0) : (TDataNodeLocation)regionReplicaSet.getDataNodeLocations().get(0);
    }

    public void setHostDataNode(TDataNodeLocation hostDataNode) {
        this.hostDataNode = hostDataNode;
    }

    public TRegionReplicaSet getRegionReplicaSet() {
        return this.regionReplicaSet;
    }

    public void setRegionReplicaSet(TRegionReplicaSet regionReplicaSet) {
        this.regionReplicaSet = regionReplicaSet;
    }

    public PlanFragment getFragment() {
        return this.fragment;
    }

    public FragmentInstanceId getId() {
        return this.id;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public String getDownstreamInfo() {
        PlanNode root = this.getFragment().getPlanNodeTree();
        if (root instanceof FragmentSinkNode) {
            FragmentSinkNode sink = (FragmentSinkNode)root;
            return String.format("(%s, %s, %s)", sink.getDownStreamEndpoint(), sink.getDownStreamInstanceId(), sink.getDownStreamPlanNodeId());
        }
        return "<No downstream>";
    }

    public void setTimeFilter(Filter timeFilter) {
        this.timeFilter = timeFilter;
    }

    public Filter getTimeFilter() {
        return this.timeFilter;
    }

    public QueryType getType() {
        return this.type;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append(String.format("FragmentInstance-%s:", this.getId()));
        ret.append(String.format("Host: %s ", this.getHostDataNode() == null ? "Not set" : this.getHostDataNode().dataNodeId + " - " + this.getHostDataNode().internalEndPoint));
        ret.append(String.format("Region: %s ", this.getRegionReplicaSet() == null ? "Not set" : this.getRegionReplicaSet().getRegionId()));
        ret.append("\n---- Plan Node Tree ----\n");
        ret.append(PlanNodeUtil.nodeToString(this.getFragment().getPlanNodeTree()));
        ret.append(String.format("timeOut-%s:", this.getTimeOut()));
        return ret.toString();
    }

    public static FragmentInstance deserializeFrom(ByteBuffer buffer) {
        FragmentInstanceId id = FragmentInstanceId.deserialize(buffer);
        PlanFragment planFragment = PlanFragment.deserialize(buffer);
        long timeOut = ReadWriteIOUtils.readLong((ByteBuffer)buffer);
        boolean hasSessionInfo = ReadWriteIOUtils.readBool((ByteBuffer)buffer);
        SessionInfo sessionInfo = hasSessionInfo ? SessionInfo.deserializeFrom(buffer) : null;
        boolean hasTimeFilter = ReadWriteIOUtils.readBool((ByteBuffer)buffer);
        Filter timeFilter = hasTimeFilter ? FilterFactory.deserialize((ByteBuffer)buffer) : null;
        QueryType queryType = QueryType.values()[ReadWriteIOUtils.readInt((ByteBuffer)buffer)];
        FragmentInstance fragmentInstance = new FragmentInstance(planFragment, id, timeFilter, queryType, timeOut, sessionInfo);
        boolean hasHostDataNode = ReadWriteIOUtils.readBool((ByteBuffer)buffer);
        fragmentInstance.hostDataNode = hasHostDataNode ? ThriftCommonsSerDeUtils.deserializeTDataNodeLocation((ByteBuffer)buffer) : null;
        return fragmentInstance;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public ByteBuffer serializeToByteBuffer() {
        try (PublicBAOS publicBAOS = new PublicBAOS();){
            ByteBuffer byteBuffer;
            try (DataOutputStream outputStream = new DataOutputStream((OutputStream)publicBAOS);){
                this.id.serialize(outputStream);
                this.fragment.serialize(outputStream);
                ReadWriteIOUtils.write((long)this.timeOut, (OutputStream)outputStream);
                ReadWriteIOUtils.write((Boolean)(this.sessionInfo != null ? 1 : 0), (OutputStream)outputStream);
                if (this.sessionInfo != null) {
                    this.sessionInfo.serialize(outputStream);
                }
                ReadWriteIOUtils.write((Boolean)(this.timeFilter != null ? 1 : 0), (OutputStream)outputStream);
                if (this.timeFilter != null) {
                    this.timeFilter.serialize(outputStream);
                }
                ReadWriteIOUtils.write((int)this.type.ordinal(), (OutputStream)outputStream);
                ReadWriteIOUtils.write((Boolean)(this.hostDataNode != null ? 1 : 0), (OutputStream)outputStream);
                if (this.hostDataNode != null) {
                    ThriftCommonsSerDeUtils.serializeTDataNodeLocation((TDataNodeLocation)this.hostDataNode, (DataOutputStream)outputStream);
                }
                byteBuffer = ByteBuffer.wrap(publicBAOS.getBuf(), 0, publicBAOS.size());
            }
            return byteBuffer;
        }
        catch (IOException e) {
            this.logger.error("Unexpected error occurs when serializing this FragmentInstance.", (Throwable)e);
            throw new SerializationRunTimeException((Throwable)e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FragmentInstance instance = (FragmentInstance)o;
        return Objects.equals(this.id, instance.id) && this.type == instance.type && Objects.equals(this.fragment, instance.fragment) && Objects.equals(this.regionReplicaSet, instance.regionReplicaSet) && Objects.equals(this.hostDataNode, instance.hostDataNode) && Objects.equals(this.timeFilter, instance.timeFilter);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.type, this.fragment, this.regionReplicaSet, this.hostDataNode, this.timeFilter});
    }

    public TDataNodeLocation getHostDataNode() {
        return this.hostDataNode;
    }

    public long getTimeOut() {
        return this.timeOut;
    }

    public SessionInfo getSessionInfo() {
        return this.sessionInfo;
    }
}

