/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.analyze;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TSchemaNode;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.partition.DataPartition;
import org.apache.iotdb.commons.partition.DataPartitionQueryParam;
import org.apache.iotdb.commons.partition.SchemaNodeManagementPartition;
import org.apache.iotdb.commons.partition.SchemaPartition;
import org.apache.iotdb.commons.partition.executor.SeriesPartitionExecutor;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.StorageEngineV2;
import org.apache.iotdb.db.exception.DataRegionException;
import org.apache.iotdb.db.exception.sql.StatementAnalyzeException;
import org.apache.iotdb.db.localconfignode.LocalConfigNode;
import org.apache.iotdb.db.metadata.mnode.MNodeType;
import org.apache.iotdb.db.metadata.utils.MetaUtils;
import org.apache.iotdb.db.mpp.plan.analyze.IPartitionFetcher;
import org.apache.iotdb.mpp.rpc.thrift.TRegionRouteReq;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandalonePartitionFetcher
implements IPartitionFetcher {
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final Logger logger = LoggerFactory.getLogger(StandalonePartitionFetcher.class);
    private final LocalConfigNode localConfigNode = LocalConfigNode.getInstance();
    private final StorageEngineV2 storageEngine = StorageEngineV2.getInstance();
    private final SeriesPartitionExecutor executor = SeriesPartitionExecutor.getSeriesPartitionExecutor((String)config.getSeriesPartitionExecutorClass(), (int)config.getSeriesPartitionSlotNum());

    public static StandalonePartitionFetcher getInstance() {
        return StandalonePartitionFetcherHolder.INSTANCE;
    }

    @Override
    public SchemaPartition getSchemaPartition(PathPatternTree patternTree) {
        patternTree.constructTree();
        return new SchemaPartition(this.localConfigNode.getSchemaPartition(patternTree), IoTDBDescriptor.getInstance().getConfig().getSeriesPartitionExecutorClass(), IoTDBDescriptor.getInstance().getConfig().getSeriesPartitionSlotNum());
    }

    @Override
    public SchemaPartition getOrCreateSchemaPartition(PathPatternTree patternTree) {
        patternTree.constructTree();
        return new SchemaPartition(this.localConfigNode.getOrCreateSchemaPartition(patternTree), IoTDBDescriptor.getInstance().getConfig().getSeriesPartitionExecutorClass(), IoTDBDescriptor.getInstance().getConfig().getSeriesPartitionSlotNum());
    }

    @Override
    public SchemaNodeManagementPartition getSchemaNodeManagementPartitionWithLevel(PathPatternTree patternTree, Integer level) {
        try {
            patternTree.constructTree();
            HashSet matchedNodes = new HashSet();
            HashSet involvedStorageGroup = new HashSet();
            if (level == null) {
                for (PartialPath pathPattern : patternTree.getAllPathPatterns()) {
                    Pair<Set<TSchemaNode>, Set<PartialPath>> result = this.localConfigNode.getChildNodePathInNextLevel(pathPattern);
                    matchedNodes.addAll((Collection)result.left);
                    involvedStorageGroup.addAll((Collection)result.right);
                }
            } else {
                for (PartialPath pathPattern : patternTree.getAllPathPatterns()) {
                    Pair<List<PartialPath>, Set<PartialPath>> result = this.localConfigNode.getNodesListInGivenLevel(pathPattern, level, false);
                    matchedNodes.addAll(((List)result.left).stream().map(path -> new TSchemaNode(path.getFullPath(), MNodeType.UNIMPLEMENT.getNodeType())).collect(Collectors.toList()));
                    involvedStorageGroup.addAll((Collection)result.right);
                }
            }
            PathPatternTree partitionReq = new PathPatternTree();
            involvedStorageGroup.forEach(storageGroup -> partitionReq.appendPathPattern(storageGroup.concatNode("**")));
            return new SchemaNodeManagementPartition(this.localConfigNode.getSchemaPartition(patternTree), IoTDBDescriptor.getInstance().getConfig().getSeriesPartitionExecutorClass(), IoTDBDescriptor.getInstance().getConfig().getSeriesPartitionSlotNum(), matchedNodes);
        }
        catch (MetadataException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public DataPartition getDataPartition(Map<String, List<DataPartitionQueryParam>> sgNameToQueryParamsMap) {
        try {
            return this.localConfigNode.getDataPartition(sgNameToQueryParamsMap);
        }
        catch (MetadataException | DataRegionException e) {
            logger.error("Meet error when get DataPartition", (Throwable)e);
            throw new StatementAnalyzeException("An error occurred when executing getDataPartition()");
        }
    }

    @Override
    public DataPartition getDataPartitionWithUnclosedTimeRange(Map<String, List<DataPartitionQueryParam>> sgNameToQueryParamsMap) {
        throw new UnsupportedOperationException("getDataPartitionWithUnclosedTimeRange is not supported");
    }

    @Override
    public DataPartition getOrCreateDataPartition(Map<String, List<DataPartitionQueryParam>> sgNameToQueryParamsMap) {
        try {
            return this.localConfigNode.getOrCreateDataPartition(sgNameToQueryParamsMap);
        }
        catch (MetadataException | DataRegionException e) {
            throw new StatementAnalyzeException("An error occurred when executing getDataPartition()");
        }
    }

    @Override
    public DataPartition getOrCreateDataPartition(List<DataPartitionQueryParam> dataPartitionQueryParams) {
        try {
            Map<String, List<DataPartitionQueryParam>> splitDataPartitionQueryParams = this.splitDataPartitionQueryParam(dataPartitionQueryParams, true);
            return this.getOrCreateDataPartition(splitDataPartitionQueryParams);
        }
        catch (MetadataException e) {
            throw new StatementAnalyzeException("An error occurred when executing getOrCreateDataPartition():" + e.getMessage());
        }
    }

    @Override
    public boolean updateRegionCache(TRegionRouteReq req) {
        return true;
    }

    @Override
    public void invalidAllCache() {
    }

    private Map<String, List<DataPartitionQueryParam>> splitDataPartitionQueryParam(List<DataPartitionQueryParam> dataPartitionQueryParams, boolean isAutoCreate) throws MetadataException {
        ArrayList<String> devicePaths = new ArrayList<String>();
        for (DataPartitionQueryParam dataPartitionQueryParam : dataPartitionQueryParams) {
            devicePaths.add(dataPartitionQueryParam.getDevicePath());
        }
        Map<String, String> deviceToStorageGroup = this.getDeviceToStorageGroup(devicePaths, isAutoCreate);
        HashMap<String, List<DataPartitionQueryParam>> result = new HashMap<String, List<DataPartitionQueryParam>>();
        for (DataPartitionQueryParam dataPartitionQueryParam : dataPartitionQueryParams) {
            String devicePath = dataPartitionQueryParam.getDevicePath();
            if (!deviceToStorageGroup.containsKey(devicePath)) continue;
            String storageGroup = deviceToStorageGroup.get(devicePath);
            result.computeIfAbsent(storageGroup, v -> new ArrayList());
            ((List)result.get(storageGroup)).add(dataPartitionQueryParam);
        }
        return result;
    }

    private Map<String, String> getDeviceToStorageGroup(List<String> devicePaths, boolean isAutoCreate) throws MetadataException {
        HashMap<String, String> deviceToStorageGroup = new HashMap<String, String>();
        for (String string : devicePaths) {
            if (!string.contains("*")) continue;
            return deviceToStorageGroup;
        }
        try {
            deviceToStorageGroup = new HashMap();
            List<PartialPath> allStorageGroups = this.localConfigNode.getAllStorageGroupPaths();
            for (String devicePath : devicePaths) {
                for (PartialPath storageGroup : allStorageGroups) {
                    if (!PathUtils.isStartWith((String)devicePath, (String)storageGroup.getFullPath())) continue;
                    deviceToStorageGroup.put(devicePath, storageGroup.getFullPath());
                }
            }
            if (isAutoCreate) {
                HashSet<PartialPath> hashSet = new HashSet<PartialPath>();
                for (String devicePath : devicePaths) {
                    if (deviceToStorageGroup.containsKey(devicePath)) continue;
                    PartialPath storageGroupNameNeedCreated = MetaUtils.getStorageGroupPathByLevel(new PartialPath(devicePath), config.getDefaultStorageGroupLevel());
                    hashSet.add(storageGroupNameNeedCreated);
                    deviceToStorageGroup.put(devicePath, storageGroupNameNeedCreated.getFullPath());
                }
                for (PartialPath storageGroupName : hashSet) {
                    this.localConfigNode.setStorageGroup(storageGroupName);
                }
            }
        }
        catch (MetadataException e) {
            throw new StatementAnalyzeException("An error occurred when executing getOrCreateDataPartition():" + e.getMessage());
        }
        return deviceToStorageGroup;
    }

    private static final class StandalonePartitionFetcherHolder {
        private static final StandalonePartitionFetcher INSTANCE = new StandalonePartitionFetcher();

        private StandalonePartitionFetcherHolder() {
        }
    }
}

