/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.source;

import com.google.common.util.concurrent.ListenableFuture;
import org.apache.iotdb.db.mpp.execution.exchange.ISourceHandle;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.source.SourceOperator;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilderStatus;

public class ExchangeOperator
implements SourceOperator {
    private final OperatorContext operatorContext;
    private final ISourceHandle sourceHandle;
    private final PlanNodeId sourceId;
    private ListenableFuture<?> isBlocked = NOT_BLOCKED;

    public ExchangeOperator(OperatorContext operatorContext, ISourceHandle sourceHandle, PlanNodeId sourceId) {
        this.operatorContext = operatorContext;
        this.sourceHandle = sourceHandle;
        this.sourceId = sourceId;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public TsBlock next() {
        return this.sourceHandle.receive();
    }

    @Override
    public boolean hasNext() {
        return !this.sourceHandle.isFinished();
    }

    @Override
    public boolean isFinished() {
        return this.sourceHandle.isFinished();
    }

    @Override
    public long calculateMaxPeekMemory() {
        return TsBlockBuilderStatus.DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES;
    }

    @Override
    public long calculateMaxReturnSize() {
        return TsBlockBuilderStatus.DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES;
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return 0L;
    }

    @Override
    public PlanNodeId getSourceId() {
        return this.sourceId;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        if (this.isBlocked.isDone()) {
            this.isBlocked = this.sourceHandle.isBlocked();
            if (this.isBlocked.isDone()) {
                this.isBlocked = NOT_BLOCKED;
            }
        }
        return this.isBlocked;
    }

    @Override
    public void close() throws Exception {
        this.sourceHandle.close();
    }
}

