/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.schema;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.mpp.common.header.ColumnHeader;
import org.apache.iotdb.db.mpp.common.header.ColumnHeaderConstant;
import org.apache.iotdb.db.mpp.execution.driver.SchemaDriverContext;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.schema.SchemaQueryScanOperator;
import org.apache.iotdb.db.mpp.execution.operator.schema.SchemaTsBlockUtil;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.utils.Binary;

public class PathsUsingTemplateScanOperator
extends SchemaQueryScanOperator {
    private final List<PartialPath> pathPatternList;
    private final int templateId;
    private final List<TSDataType> outputDataTypes;

    public PathsUsingTemplateScanOperator(PlanNodeId planNodeId, OperatorContext context, List<PartialPath> pathPatternList, int templateId) {
        super(planNodeId, context, 0, 0, null, false);
        this.pathPatternList = pathPatternList;
        this.templateId = templateId;
        this.outputDataTypes = ColumnHeaderConstant.showPathsUsingTemplateHeaders.stream().map(ColumnHeader::getColumnType).collect(Collectors.toList());
    }

    @Override
    protected List<TsBlock> createTsBlockList() {
        try {
            LinkedList<String> schemaRegionResult = new LinkedList<String>();
            for (PartialPath pathPattern : this.pathPatternList) {
                schemaRegionResult.addAll(((SchemaDriverContext)this.operatorContext.getInstanceContext().getDriverContext()).getSchemaRegion().getPathsUsingTemplate(pathPattern, this.templateId));
            }
            return SchemaTsBlockUtil.transferSchemaResultToTsBlockList(schemaRegionResult.iterator(), this.outputDataTypes, this::setColumns);
        }
        catch (MetadataException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private void setColumns(String path, TsBlockBuilder builder) {
        builder.getTimeColumnBuilder().writeLong(0L);
        builder.getColumnBuilder(0).writeBinary(new Binary(path));
        builder.declarePosition();
    }
}

