/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.process;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.mpp.execution.operator.Operator;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.process.ProcessOperator;
import org.apache.iotdb.db.mpp.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.mpp.transformation.dag.column.binary.BinaryColumnTransformer;
import org.apache.iotdb.db.mpp.transformation.dag.column.leaf.IdentityColumnTransformer;
import org.apache.iotdb.db.mpp.transformation.dag.column.leaf.LeafColumnTransformer;
import org.apache.iotdb.db.mpp.transformation.dag.column.multi.MappableUDFColumnTransformer;
import org.apache.iotdb.db.mpp.transformation.dag.column.ternary.TernaryColumnTransformer;
import org.apache.iotdb.db.mpp.transformation.dag.column.unary.UnaryColumnTransformer;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumn;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumnBuilder;

public class FilterAndProjectOperator
implements ProcessOperator {
    private final Operator inputOperator;
    private List<LeafColumnTransformer> filterLeafColumnTransformerList;
    private ColumnTransformer filterOutputTransformer;
    private List<ColumnTransformer> commonTransformerList;
    private List<LeafColumnTransformer> projectLeafColumnTransformerList;
    private List<ColumnTransformer> projectOutputTransformerList;
    private final TsBlockBuilder filterTsBlockBuilder;
    private final boolean hasNonMappableUDF;
    private final OperatorContext operatorContext;
    private final boolean hasFilter;

    public FilterAndProjectOperator(OperatorContext operatorContext, Operator inputOperator, List<TSDataType> filterOutputDataTypes, List<LeafColumnTransformer> filterLeafColumnTransformerList, ColumnTransformer filterOutputTransformer, List<ColumnTransformer> commonTransformerList, List<LeafColumnTransformer> projectLeafColumnTransformerList, List<ColumnTransformer> projectOutputTransformerList, boolean hasNonMappableUDF, boolean hasFilter) {
        this.operatorContext = operatorContext;
        this.inputOperator = inputOperator;
        this.filterLeafColumnTransformerList = filterLeafColumnTransformerList;
        this.filterOutputTransformer = filterOutputTransformer;
        this.commonTransformerList = commonTransformerList;
        this.projectLeafColumnTransformerList = projectLeafColumnTransformerList;
        this.projectOutputTransformerList = projectOutputTransformerList;
        this.hasNonMappableUDF = hasNonMappableUDF;
        this.filterTsBlockBuilder = new TsBlockBuilder(8, filterOutputDataTypes);
        this.hasFilter = hasFilter;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public TsBlock next() {
        TsBlock input = this.inputOperator.next();
        if (input == null) {
            return null;
        }
        if (!this.hasFilter) {
            return this.getTransformedTsBlock(input);
        }
        TsBlock filterResult = this.getFilterTsBlock(input);
        if (this.hasNonMappableUDF) {
            return filterResult;
        }
        return this.getTransformedTsBlock(filterResult);
    }

    private TsBlock getFilterTsBlock(TsBlock input) {
        TimeColumn originTimeColumn = input.getTimeColumn();
        int positionCount = originTimeColumn.getPositionCount();
        for (LeafColumnTransformer leafColumnTransformer : this.filterLeafColumnTransformerList) {
            leafColumnTransformer.initFromTsBlock(input);
        }
        this.filterOutputTransformer.tryEvaluate();
        Column filterColumn = this.filterOutputTransformer.getColumn();
        this.filterTsBlockBuilder.reset();
        TimeColumnBuilder timeBuilder = this.filterTsBlockBuilder.getTimeColumnBuilder();
        ColumnBuilder[] columnBuilders = this.filterTsBlockBuilder.getValueColumnBuilders();
        ArrayList<Column> resultColumns = new ArrayList<Column>();
        int n = input.getValueColumnCount();
        for (int i = 0; i < n; ++i) {
            resultColumns.add(input.getColumn(i));
        }
        if (!this.hasNonMappableUDF) {
            for (ColumnTransformer columnTransformer : this.commonTransformerList) {
                resultColumns.add(columnTransformer.getColumn());
            }
        }
        int rowCount = 0;
        int n2 = resultColumns.size();
        for (int i = 0; i < n2; ++i) {
            Column curColumn = (Column)resultColumns.get(i);
            for (int j = 0; j < positionCount; ++j) {
                if (filterColumn.isNull(j) || !filterColumn.getBoolean(j)) continue;
                if (i == 0) {
                    ++rowCount;
                    timeBuilder.writeLong(originTimeColumn.getLong(j));
                }
                if (curColumn.isNull(j)) {
                    columnBuilders[i].appendNull();
                    continue;
                }
                columnBuilders[i].write(curColumn, j);
            }
        }
        this.filterTsBlockBuilder.declarePositions(rowCount);
        return this.filterTsBlockBuilder.build();
    }

    private TsBlock getTransformedTsBlock(TsBlock input) {
        TimeColumn originTimeColumn = input.getTimeColumn();
        int positionCount = originTimeColumn.getPositionCount();
        for (LeafColumnTransformer leafColumnTransformer : this.projectLeafColumnTransformerList) {
            leafColumnTransformer.initFromTsBlock(input);
        }
        ArrayList<Column> resultColumns = new ArrayList<Column>();
        for (ColumnTransformer columnTransformer : this.projectOutputTransformerList) {
            columnTransformer.tryEvaluate();
            resultColumns.add(columnTransformer.getColumn());
        }
        return TsBlock.wrapBlocksWithoutCopy((int)positionCount, (TimeColumn)originTimeColumn, (Column[])resultColumns.toArray(new Column[0]));
    }

    @Override
    public boolean hasNext() {
        return this.inputOperator.hasNext();
    }

    @Override
    public boolean isFinished() {
        return this.inputOperator.isFinished();
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return this.inputOperator.isBlocked();
    }

    @Override
    public void close() throws Exception {
        for (ColumnTransformer columnTransformer : this.projectOutputTransformerList) {
            columnTransformer.close();
        }
        if (this.filterOutputTransformer != null) {
            this.filterOutputTransformer.close();
        }
        this.inputOperator.close();
    }

    @Override
    public long calculateMaxPeekMemory() {
        long maxPeekMemory = this.inputOperator.calculateMaxReturnSize();
        int maxCachedColumn = 0;
        if (!this.hasFilter) {
            for (int i = 0; i < this.projectOutputTransformerList.size(); ++i) {
                ColumnTransformer c = this.projectOutputTransformerList.get(i);
                maxCachedColumn = Math.max(maxCachedColumn, 1 + i + this.getMaxLevelOfColumnTransformerTree(c));
            }
            return Math.max(maxPeekMemory, (long)maxCachedColumn * (long)TSFileDescriptor.getInstance().getConfig().getPageSizeInByte()) + this.inputOperator.calculateRetainedSizeAfterCallingNext();
        }
        maxCachedColumn = Math.max(1 + this.getMaxLevelOfColumnTransformerTree(this.filterOutputTransformer), 1 + this.commonTransformerList.size());
        if (!this.hasNonMappableUDF) {
            for (int i = 0; i < this.projectOutputTransformerList.size(); ++i) {
                ColumnTransformer c = this.projectOutputTransformerList.get(i);
                maxCachedColumn = Math.max(maxCachedColumn, 1 + i + this.getMaxLevelOfColumnTransformerTree(c));
            }
        }
        return Math.max(maxPeekMemory, (long)maxCachedColumn * (long)TSFileDescriptor.getInstance().getConfig().getPageSizeInByte()) + this.inputOperator.calculateRetainedSizeAfterCallingNext();
    }

    @Override
    public long calculateMaxReturnSize() {
        if (!this.hasFilter || !this.hasNonMappableUDF) {
            return (long)(1 + this.projectOutputTransformerList.size()) * (long)TSFileDescriptor.getInstance().getConfig().getPageSizeInByte();
        }
        return (long)(1 + this.filterTsBlockBuilder.getValueColumnBuilders().length) * (long)TSFileDescriptor.getInstance().getConfig().getPageSizeInByte();
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return this.inputOperator.calculateRetainedSizeAfterCallingNext();
    }

    private int getMaxLevelOfColumnTransformerTree(ColumnTransformer columnTransformer) {
        if (columnTransformer instanceof LeafColumnTransformer) {
            if (columnTransformer instanceof IdentityColumnTransformer) {
                return 1;
            }
            return 0;
        }
        if (columnTransformer instanceof UnaryColumnTransformer) {
            return Math.max(2, this.getMaxLevelOfColumnTransformerTree(((UnaryColumnTransformer)columnTransformer).getChildColumnTransformer()));
        }
        if (columnTransformer instanceof BinaryColumnTransformer) {
            int childMaxLevel = Math.max(this.getMaxLevelOfColumnTransformerTree(((BinaryColumnTransformer)columnTransformer).getLeftTransformer()), this.getMaxLevelOfColumnTransformerTree(((BinaryColumnTransformer)columnTransformer).getRightTransformer()));
            return Math.max(3, childMaxLevel);
        }
        if (columnTransformer instanceof TernaryColumnTransformer) {
            int childMaxLevel = Math.max(this.getMaxLevelOfColumnTransformerTree(((TernaryColumnTransformer)columnTransformer).getFirstColumnTransformer()), Math.max(this.getMaxLevelOfColumnTransformerTree(((TernaryColumnTransformer)columnTransformer).getSecondColumnTransformer()), this.getMaxLevelOfColumnTransformerTree(((TernaryColumnTransformer)columnTransformer).getThirdColumnTransformer())));
            return Math.max(4, childMaxLevel);
        }
        if (columnTransformer instanceof MappableUDFColumnTransformer) {
            int childMaxLevel = 0;
            for (ColumnTransformer c : ((MappableUDFColumnTransformer)columnTransformer).getInputColumnTransformers()) {
                childMaxLevel = Math.max(childMaxLevel, this.getMaxLevelOfColumnTransformerTree(c));
            }
            return Math.max(1 + ((MappableUDFColumnTransformer)columnTransformer).getInputColumnTransformers().length, childMaxLevel);
        }
        throw new UnsupportedOperationException("Unsupported ColumnTransformer");
    }
}

