/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree.store.disk.memcontrol;

import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mtree.store.disk.memcontrol.CachedMNodeSizeEstimator;
import org.apache.iotdb.db.metadata.mtree.store.disk.memcontrol.IMemManager;
import org.apache.iotdb.db.metadata.rescon.MemoryStatistics;

public class MemManagerNodeEstimatedSizeBasedImpl
implements IMemManager {
    private static final double RELEASE_THRESHOLD_RATIO = 0.6;
    private static final double FLUSH_THRESHOLD_RATION = 0.75;
    private final MemoryStatistics memoryStatistics = MemoryStatistics.getInstance();
    private long releaseThreshold;
    private long flushThreshold;
    private final AtomicLong size = new AtomicLong(0L);
    private final AtomicLong pinnedSize = new AtomicLong(0L);
    private final CachedMNodeSizeEstimator estimator = new CachedMNodeSizeEstimator();

    @Override
    public void init() {
        this.size.getAndSet(0L);
        this.pinnedSize.getAndSet(0L);
        this.releaseThreshold = (long)((double)this.memoryStatistics.getMemoryCapacity() * 0.6);
        this.flushThreshold = (long)((double)this.memoryStatistics.getMemoryCapacity() * 0.75);
    }

    @Override
    public boolean isEmpty() {
        return this.size.get() == 0L;
    }

    @Override
    public boolean isExceedReleaseThreshold() {
        return this.memoryStatistics.getMemoryUsage() > this.releaseThreshold;
    }

    @Override
    public boolean isExceedFlushThreshold() {
        return this.memoryStatistics.getMemoryUsage() > this.flushThreshold;
    }

    @Override
    public void requestPinnedMemResource(IMNode node) {
        int size = this.estimator.estimateSize(node);
        this.memoryStatistics.requestMemory(size);
        this.pinnedSize.getAndUpdate(v -> v += (long)size);
    }

    @Override
    public void upgradeMemResource(IMNode node) {
        int size = this.estimator.estimateSize(node);
        this.pinnedSize.getAndUpdate(v -> v += (long)size);
        this.size.getAndUpdate(v -> v -= (long)size);
    }

    @Override
    public void releasePinnedMemResource(IMNode node) {
        int size = this.estimator.estimateSize(node);
        this.size.getAndUpdate(v -> v += (long)size);
        this.pinnedSize.getAndUpdate(v -> v -= (long)size);
    }

    @Override
    public void releaseMemResource(IMNode node) {
        int size = this.estimator.estimateSize(node);
        this.size.getAndUpdate(v -> v -= (long)size);
        this.memoryStatistics.releaseMemory(size);
    }

    @Override
    public void releaseMemResource(List<IMNode> evictedNodes) {
        int size = 0;
        for (IMNode node : evictedNodes) {
            size += this.estimator.estimateSize(node);
        }
        int finalSize = size;
        this.size.getAndUpdate(v -> v -= (long)finalSize);
        this.memoryStatistics.releaseMemory(size);
    }

    @Override
    public void updatePinnedSize(int deltaSize) {
        if (deltaSize > 0) {
            this.memoryStatistics.requestMemory(deltaSize);
        } else {
            this.memoryStatistics.releaseMemory(deltaSize);
        }
        this.pinnedSize.getAndUpdate(v -> v += (long)deltaSize);
    }

    @Override
    public void clear() {
        this.size.getAndSet(0L);
        this.pinnedSize.getAndSet(0L);
    }

    @Override
    public long getPinnedSize() {
        return this.pinnedSize.get();
    }

    @Override
    public long getCachedSize() {
        return this.size.get();
    }
}

