/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.localconfignode;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.localconfignode.LocalDataPartitionTable;

public class LocalDataPartitionInfo {
    private Map<PartialPath, LocalDataPartitionTable> partitionTableMap;

    private LocalDataPartitionInfo() {
    }

    public static LocalDataPartitionInfo getInstance() {
        return LocalDataPartitionTableHolder.INSTANCE;
    }

    public synchronized void init(Map<String, List<DataRegionId>> regionInfos) throws IllegalPathException {
        this.partitionTableMap = new ConcurrentHashMap<PartialPath, LocalDataPartitionTable>();
        for (Map.Entry<String, List<DataRegionId>> entry : regionInfos.entrySet()) {
            String storageGroupName = entry.getKey();
            List<DataRegionId> regionIds = entry.getValue();
            LocalDataPartitionTable table = new LocalDataPartitionTable(storageGroupName, regionIds);
            this.partitionTableMap.put(new PartialPath(storageGroupName), table);
        }
    }

    public synchronized void clear() {
        if (this.partitionTableMap != null) {
            this.partitionTableMap.clear();
            this.partitionTableMap = null;
        }
    }

    public DataRegionId getDataRegionId(PartialPath storageGroup, PartialPath path) {
        if (!this.partitionTableMap.containsKey(storageGroup)) {
            return null;
        }
        LocalDataPartitionTable table = this.partitionTableMap.get(storageGroup);
        return table.getDataRegionId(path);
    }

    public DataRegionId allocateDataRegionForNewSlot(PartialPath storageGroup, PartialPath path) {
        LocalDataPartitionTable table = this.partitionTableMap.get(storageGroup);
        return table.getDataRegionWithAutoExtension(path);
    }

    public List<DataRegionId> getDataRegionIdsByStorageGroup(PartialPath storageGroup) {
        if (this.partitionTableMap.containsKey(storageGroup)) {
            LocalDataPartitionTable partitionTable = this.partitionTableMap.get(storageGroup);
            return partitionTable.getAllDataRegionId();
        }
        return Collections.emptyList();
    }

    public synchronized void registerStorageGroup(PartialPath storageGroup) {
        if (this.partitionTableMap.containsKey(storageGroup)) {
            return;
        }
        this.partitionTableMap.put(storageGroup, new LocalDataPartitionTable(storageGroup.getFullPath()));
    }

    public synchronized void deleteStorageGroup(PartialPath storageGroup) {
        LocalDataPartitionTable partitionTable = this.partitionTableMap.remove(storageGroup);
        if (partitionTable != null) {
            partitionTable.clear();
        }
    }

    private static class LocalDataPartitionTableHolder {
        private static final LocalDataPartitionInfo INSTANCE = new LocalDataPartitionInfo();

        private LocalDataPartitionTableHolder() {
        }
    }
}

