/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.storagegroup;

import java.util.Objects;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.db.engine.storagegroup.DataRegion;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class DataRegionMetrics
implements IMetricSet {
    private DataRegion dataRegion;
    private String storageGroupName;

    public DataRegionMetrics(DataRegion dataRegion) {
        this.dataRegion = dataRegion;
        this.storageGroupName = dataRegion.getStorageGroupName();
    }

    public void bindTo(AbstractMetricService metricService) {
        metricService.createAutoGauge(Metric.MEM.toString(), MetricLevel.IMPORTANT, (Object)this.dataRegion, DataRegion::getMemCost, new String[]{Tag.NAME.toString(), "database_" + this.storageGroupName});
    }

    public void unbindFrom(AbstractMetricService metricService) {
        metricService.remove(MetricType.AUTO_GAUGE, Metric.MEM.toString(), new String[]{Tag.NAME.toString(), "database_" + this.storageGroupName});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataRegionMetrics that = (DataRegionMetrics)o;
        return Objects.equals(this.dataRegion, that.dataRegion) && Objects.equals(this.storageGroupName, that.storageGroupName);
    }

    public int hashCode() {
        return Objects.hash(this.dataRegion, this.storageGroupName);
    }
}

