/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.reader;

import java.io.IOException;
import java.util.ArrayList;
import java.util.PriorityQueue;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.db.engine.compaction.cross.utils.PageElement;
import org.apache.iotdb.db.engine.compaction.cross.utils.PointElement;
import org.apache.iotdb.db.engine.compaction.cross.utils.SeriesCompactionExecutor;
import org.apache.iotdb.db.exception.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.reader.IPointReader;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;

public class PointPriorityReader {
    private long lastTime;
    private final PriorityQueue<PointElement> pointQueue;
    private final SeriesCompactionExecutor.RemovePage removePage;
    private TimeValuePair currentPoint;
    private boolean shouldReadNextPoint = true;

    public PointPriorityReader(SeriesCompactionExecutor.RemovePage removePage) {
        this.removePage = removePage;
        this.pointQueue = new PriorityQueue((o1, o2) -> {
            int timeCompare = Long.compare(o1.timestamp, o2.timestamp);
            return timeCompare != 0 ? timeCompare : Long.compare(o2.priority, o1.priority);
        });
    }

    public TimeValuePair currentPoint() {
        if (this.shouldReadNextPoint) {
            this.currentPoint = this.pointQueue.peek().timeValuePair;
            this.lastTime = this.currentPoint.getTimestamp();
            if (this.currentPoint.getValue().getDataType().equals((Object)TSDataType.VECTOR)) {
                this.fillAlignedNullValue();
            }
            this.shouldReadNextPoint = false;
        }
        return this.currentPoint;
    }

    private void fillAlignedNullValue() {
        ArrayList<PointElement> pointElementsWithSameTimestamp = new ArrayList<PointElement>();
        pointElementsWithSameTimestamp.add(this.pointQueue.poll());
        TsPrimitiveType[] currentValues = this.currentPoint.getValue().getVector();
        int nullValueNum = currentValues.length;
        while (!this.pointQueue.isEmpty() && this.pointQueue.peek().timestamp <= this.lastTime) {
            PointElement pointElement = this.pointQueue.poll();
            pointElementsWithSameTimestamp.add(pointElement);
            TsPrimitiveType[] values = pointElement.timeValuePair.getValue().getVector();
            for (int i = 0; i < values.length; ++i) {
                if (currentValues[i] == null) {
                    if (values[i] == null) continue;
                    currentValues[i] = values[i];
                    --nullValueNum;
                    continue;
                }
                --nullValueNum;
            }
            if (nullValueNum != 0) continue;
        }
        this.pointQueue.addAll(pointElementsWithSameTimestamp);
    }

    public void next() throws IllegalPathException, IOException, WriteProcessException {
        while (!this.pointQueue.isEmpty() && this.pointQueue.peek().timestamp <= this.lastTime) {
            PointElement pointElement = this.pointQueue.poll();
            IPointReader pointReader = pointElement.pointReader;
            if (pointReader.hasNextTimeValuePair()) {
                pointElement.setPoint(pointReader.nextTimeValuePair());
                this.pointQueue.add(pointElement);
                continue;
            }
            this.removePage.call(pointElement.pageElement);
        }
        this.shouldReadNextPoint = true;
    }

    public boolean hasNext() {
        return !this.pointQueue.isEmpty();
    }

    public void addNewPage(PageElement pageElement) throws IOException {
        pageElement.deserializePage();
        this.pointQueue.add(new PointElement(pageElement));
        this.shouldReadNextPoint = true;
    }
}

