/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.transport.client;

import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.sync.pipesink.IoTDBPipeSink;
import org.apache.iotdb.commons.sync.pipesink.PipeSink;
import org.apache.iotdb.db.engine.StorageEngineV2;
import org.apache.iotdb.db.engine.storagegroup.DataRegion;
import org.apache.iotdb.db.sync.sender.pipe.Pipe;
import org.apache.iotdb.db.sync.transport.client.ISyncClient;
import org.apache.iotdb.db.sync.transport.client.IoTDBSyncClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncClientFactory {
    private static final Logger logger = LoggerFactory.getLogger(SyncClientFactory.class);

    public static ISyncClient createSyncClient(Pipe pipe, PipeSink pipeSink, String dataRegionId) {
        DataRegion dataRegion = StorageEngineV2.getInstance().getDataRegion(new DataRegionId(Integer.parseInt(dataRegionId)));
        switch (pipeSink.getType()) {
            case IoTDB: {
                IoTDBPipeSink ioTDBPipeSink = (IoTDBPipeSink)pipeSink;
                return new IoTDBSyncClient(pipe, ioTDBPipeSink.getIp(), ioTDBPipeSink.getPort(), dataRegion.getStorageGroupName());
            }
        }
        throw new UnsupportedOperationException();
    }

    public static ISyncClient createHeartbeatClient(Pipe pipe, PipeSink pipeSink) {
        switch (pipeSink.getType()) {
            case IoTDB: {
                IoTDBPipeSink ioTDBPipeSink = (IoTDBPipeSink)pipeSink;
                return new IoTDBSyncClient(pipe, ioTDBPipeSink.getIp(), ioTDBPipeSink.getPort());
            }
        }
        throw new UnsupportedOperationException();
    }
}

