/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service.basic;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.threadpool.ScheduledExecutorUtil;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryFrequencyRecorder {
    private static final Logger QUERY_FREQUENCY_LOGGER = LoggerFactory.getLogger((String)"QUERY_FREQUENCY");
    private static final AtomicInteger QUERY_COUNT = new AtomicInteger(0);

    public QueryFrequencyRecorder(IoTDBConfig config) {
        ScheduledExecutorService timedQuerySqlCountThread = IoTDBThreadPoolFactory.newSingleThreadScheduledExecutor((String)"timedQuerySqlCount");
        ScheduledExecutorUtil.safelyScheduleAtFixedRate((ScheduledExecutorService)timedQuerySqlCountThread, () -> {
            if (QUERY_COUNT.get() != 0) {
                QUERY_FREQUENCY_LOGGER.info("Query count in current 1 minute {} ", (Object)QUERY_COUNT.getAndSet(0));
            }
        }, (long)config.getFrequencyIntervalInMinute(), (long)config.getFrequencyIntervalInMinute(), (TimeUnit)TimeUnit.MINUTES);
    }

    public void incrementAndGet() {
        QUERY_COUNT.incrementAndGet();
    }
}

