/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.strategy;

import java.time.ZoneId;
import java.util.HashSet;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.apache.iotdb.commons.conf.IoTDBConstant;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.mpp.plan.expression.ResultColumn;
import org.apache.iotdb.db.mpp.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.qp.constant.FilterConstant;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.logical.crud.BasicFunctionOperator;
import org.apache.iotdb.db.qp.logical.crud.FilterOperator;
import org.apache.iotdb.db.qp.logical.crud.FromComponent;
import org.apache.iotdb.db.qp.logical.crud.LastQueryOperator;
import org.apache.iotdb.db.qp.logical.crud.QueryOperator;
import org.apache.iotdb.db.qp.logical.crud.SelectComponent;
import org.apache.iotdb.db.qp.logical.crud.WhereComponent;
import org.apache.iotdb.service.rpc.thrift.TSLastDataQueryReq;
import org.apache.iotdb.service.rpc.thrift.TSRawDataQueryReq;

public class LogicalGenerator {
    public static Operator generate(String sql, ZoneId zoneId, IoTDBConstant.ClientVersion clientVersion) throws ParseCancellationException {
        throw new UnsupportedOperationException();
    }

    public static Operator generate(TSRawDataQueryReq rawDataQueryReq, ZoneId zoneId) throws IllegalPathException {
        QueryOperator queryOp = new QueryOperator();
        FromComponent fromOp = new FromComponent();
        SelectComponent selectOp = new SelectComponent(zoneId);
        for (String p : rawDataQueryReq.getPaths()) {
            PartialPath path = new PartialPath(p);
            fromOp.addPrefixTablePath(path);
        }
        selectOp.addResultColumn(new ResultColumn(new TimeSeriesOperand(new PartialPath("", false))));
        queryOp.setSelectComponent(selectOp);
        queryOp.setFromComponent(fromOp);
        FilterOperator filterOp = new FilterOperator(FilterConstant.FilterType.KW_AND);
        PartialPath timePath = new PartialPath("time", false);
        filterOp.setSinglePath(timePath);
        HashSet<PartialPath> pathSet = new HashSet<PartialPath>();
        pathSet.add(timePath);
        filterOp.setIsSingle(true);
        filterOp.setPathSet(pathSet);
        BasicFunctionOperator left = new BasicFunctionOperator(FilterConstant.FilterType.GREATERTHANOREQUALTO, timePath, Long.toString(rawDataQueryReq.getStartTime()));
        BasicFunctionOperator right = new BasicFunctionOperator(FilterConstant.FilterType.LESSTHAN, timePath, Long.toString(rawDataQueryReq.getEndTime()));
        filterOp.addChildOperator(left);
        filterOp.addChildOperator(right);
        queryOp.setWhereComponent(new WhereComponent(filterOp));
        return queryOp;
    }

    public static Operator generate(TSLastDataQueryReq req, ZoneId zoneId) throws IllegalPathException {
        LastQueryOperator queryOp = new LastQueryOperator();
        FromComponent fromOp = new FromComponent();
        SelectComponent selectOp = new SelectComponent(zoneId);
        selectOp.addResultColumn(new ResultColumn(new TimeSeriesOperand(new PartialPath("", false))));
        for (String p : req.getPaths()) {
            PartialPath path = new PartialPath(p);
            fromOp.addPrefixTablePath(path);
        }
        queryOp.setSelectComponent(selectOp);
        queryOp.setFromComponent(fromOp);
        PartialPath timePath = new PartialPath("time", false);
        BasicFunctionOperator basicFunctionOperator = new BasicFunctionOperator(FilterConstant.FilterType.GREATERTHANOREQUALTO, timePath, Long.toString(req.getTime()));
        queryOp.setWhereComponent(new WhereComponent(basicFunctionOperator));
        return queryOp;
    }

    public static Operator generate(String sql, ZoneId zoneId) throws ParseCancellationException {
        return LogicalGenerator.generate(sql, zoneId, IoTDBConstant.ClientVersion.V_0_13);
    }

    private LogicalGenerator() {
    }
}

