/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.logical.sys;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.exception.sql.SQLParserException;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateAlignedTimeSeriesPlan;
import org.apache.iotdb.db.qp.strategy.PhysicalGenerator;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;

public class CreateAlignedTimeSeriesOperator
extends Operator {
    private PartialPath prefixPath;
    private List<String> measurements = new ArrayList<String>();
    private List<TSDataType> dataTypes = new ArrayList<TSDataType>();
    private List<TSEncoding> encodings = new ArrayList<TSEncoding>();
    private List<CompressionType> compressors = new ArrayList<CompressionType>();
    private List<String> aliasList = new ArrayList<String>();
    private List<Map<String, String>> tagsList = new ArrayList<Map<String, String>>();
    private List<Map<String, String>> attributesList = new ArrayList<Map<String, String>>();
    private List<Long> tagOffsets = null;

    public CreateAlignedTimeSeriesOperator(int tokenIntType) {
        super(tokenIntType);
        this.operatorType = Operator.OperatorType.CREATE_ALIGNED_TIMESERIES;
    }

    public PartialPath getPrefixPath() {
        return this.prefixPath;
    }

    public void setPrefixPath(PartialPath prefixPath) {
        this.prefixPath = prefixPath;
    }

    public List<String> getMeasurements() {
        return this.measurements;
    }

    public void setMeasurements(List<String> measurements) {
        this.measurements = measurements;
    }

    public void addMeasurement(String measurement) {
        this.measurements.add(measurement);
    }

    public List<TSDataType> getDataTypes() {
        return this.dataTypes;
    }

    public void setDataTypes(List<TSDataType> dataTypes) {
        this.dataTypes = dataTypes;
    }

    public void addDataType(TSDataType dataType) {
        this.dataTypes.add(dataType);
    }

    public List<TSEncoding> getEncodings() {
        return this.encodings;
    }

    public void setEncodings(List<TSEncoding> encodings) {
        this.encodings = encodings;
    }

    public void addEncoding(TSEncoding encoding) {
        this.encodings.add(encoding);
    }

    public List<CompressionType> getCompressors() {
        return this.compressors;
    }

    public void setCompressors(List<CompressionType> compressors) {
        this.compressors = compressors;
    }

    public void addCompressor(CompressionType compression) {
        this.compressors.add(compression);
    }

    public List<String> getAliasList() {
        return this.aliasList;
    }

    public void setAliasList(List<String> aliasList) {
        this.aliasList = aliasList;
    }

    public void addAliasList(String alias) {
        this.aliasList.add(alias);
    }

    public List<Map<String, String>> getTagsList() {
        return this.tagsList;
    }

    public void setTagsList(List<Map<String, String>> tagsList) {
        this.tagsList = tagsList;
    }

    public void addTagsList(Map<String, String> tags) {
        this.tagsList.add(tags);
    }

    public List<Map<String, String>> getAttributesList() {
        return this.attributesList;
    }

    public void setAttributesList(List<Map<String, String>> attributesList) {
        this.attributesList = attributesList;
    }

    public void addAttributesList(Map<String, String> attributes) {
        this.attributesList.add(attributes);
    }

    public List<Long> getTagOffsets() {
        if (this.tagOffsets == null) {
            this.tagOffsets = new ArrayList<Long>();
            for (int i = 0; i < this.measurements.size(); ++i) {
                this.tagOffsets.add(Long.parseLong("-1"));
            }
        }
        return this.tagOffsets;
    }

    public void setTagOffsets(List<Long> tagOffsets) {
        this.tagOffsets = tagOffsets;
    }

    public void addTagOffsets(Long tagsOffset) {
        this.tagOffsets.add(tagsOffset);
    }

    @Override
    public PhysicalPlan generatePhysicalPlan(PhysicalGenerator generator) throws QueryProcessException {
        HashSet<String> measurementSet = new HashSet<String>(this.measurements);
        if (measurementSet.size() < this.measurements.size()) {
            throw new SQLParserException("the measurement under an aligned device is not allowed to have the same measurement name");
        }
        return new CreateAlignedTimeSeriesPlan(this.prefixPath, this.measurements, this.dataTypes, this.encodings, this.compressors, this.aliasList, this.tagsList, this.attributesList);
    }
}

