/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.analyze;

import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.mpp.common.MPPQueryContext;
import org.apache.iotdb.db.mpp.common.QueryId;
import org.apache.iotdb.db.mpp.plan.analyze.Analysis;
import org.apache.iotdb.db.mpp.plan.analyze.AnalyzeVisitor;
import org.apache.iotdb.db.mpp.plan.analyze.ClusterPartitionFetcher;
import org.apache.iotdb.db.mpp.plan.analyze.ClusterSchemaFetcher;
import org.apache.iotdb.db.mpp.plan.analyze.IPartitionFetcher;
import org.apache.iotdb.db.mpp.plan.analyze.ISchemaFetcher;
import org.apache.iotdb.db.mpp.plan.analyze.StandalonePartitionFetcher;
import org.apache.iotdb.db.mpp.plan.analyze.StandaloneSchemaFetcher;
import org.apache.iotdb.db.mpp.plan.statement.Statement;

public class Analyzer {
    private final MPPQueryContext context;
    private final IPartitionFetcher partitionFetcher;
    private final ISchemaFetcher schemaFetcher;

    public Analyzer(MPPQueryContext context, IPartitionFetcher partitionFetcher, ISchemaFetcher schemaFetcher) {
        this.context = context;
        this.partitionFetcher = partitionFetcher;
        this.schemaFetcher = schemaFetcher;
    }

    public Analysis analyze(Statement statement) {
        return (Analysis)new AnalyzeVisitor(this.partitionFetcher, this.schemaFetcher).process(statement, this.context);
    }

    public static void validate(Statement statement) {
        ISchemaFetcher schemaFetcher;
        IPartitionFetcher partitionFetcher;
        MPPQueryContext context = new MPPQueryContext(QueryId.mockQueryId);
        if (IoTDBDescriptor.getInstance().getConfig().isClusterMode()) {
            partitionFetcher = ClusterPartitionFetcher.getInstance();
            schemaFetcher = ClusterSchemaFetcher.getInstance();
        } else {
            partitionFetcher = StandalonePartitionFetcher.getInstance();
            schemaFetcher = StandaloneSchemaFetcher.getInstance();
        }
        Analyzer analyzer = new Analyzer(context, partitionFetcher, schemaFetcher);
        analyzer.analyze(statement);
    }
}

