/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.schema;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.metadata.template.Template;
import org.apache.iotdb.db.mpp.common.header.ColumnHeader;
import org.apache.iotdb.db.mpp.common.header.ColumnHeaderConstant;
import org.apache.iotdb.db.mpp.execution.driver.SchemaDriverContext;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.schema.SchemaQueryScanOperator;
import org.apache.iotdb.db.mpp.execution.operator.schema.SchemaTsBlockUtil;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.qp.physical.sys.ShowTimeSeriesPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.dataset.ShowTimeSeriesResult;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;

public class TimeSeriesSchemaScanOperator
extends SchemaQueryScanOperator {
    private final String key;
    private final String value;
    private final boolean isContains;
    private final boolean orderByHeat;
    private final Map<Integer, Template> templateMap;
    private final List<TSDataType> outputDataTypes;

    public TimeSeriesSchemaScanOperator(PlanNodeId planNodeId, OperatorContext operatorContext, int limit, int offset, PartialPath partialPath, String key, String value, boolean isContains, boolean orderByHeat, boolean isPrefixPath, Map<Integer, Template> templateMap) {
        super(planNodeId, operatorContext, limit, offset, partialPath, isPrefixPath);
        this.isContains = isContains;
        this.key = key;
        this.value = value;
        this.orderByHeat = orderByHeat;
        this.templateMap = templateMap;
        this.outputDataTypes = ColumnHeaderConstant.showTimeSeriesColumnHeaders.stream().map(ColumnHeader::getColumnType).collect(Collectors.toList());
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isContains() {
        return this.isContains;
    }

    public boolean isOrderByHeat() {
        return this.orderByHeat;
    }

    @Override
    protected List<TsBlock> createTsBlockList() {
        try {
            List schemaRegionResult = (List)((SchemaDriverContext)this.operatorContext.getInstanceContext().getDriverContext()).getSchemaRegion().showTimeseries((ShowTimeSeriesPlan)this.convertToPhysicalPlan(), (QueryContext)this.operatorContext.getInstanceContext()).left;
            return SchemaTsBlockUtil.transferSchemaResultToTsBlockList(schemaRegionResult.iterator(), this.outputDataTypes, this::setColumns);
        }
        catch (MetadataException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private ShowTimeSeriesPlan convertToPhysicalPlan() {
        ShowTimeSeriesPlan plan = new ShowTimeSeriesPlan(this.partialPath, this.isContains, this.key, this.value, this.limit, this.offset, false);
        plan.setRelatedTemplate(this.templateMap);
        return plan;
    }

    private void setColumns(ShowTimeSeriesResult series, TsBlockBuilder builder) {
        builder.getTimeColumnBuilder().writeLong(series.getLastTime());
        builder.writeNullableText(0, series.getName());
        builder.writeNullableText(1, series.getAlias());
        builder.writeNullableText(2, series.getSgName());
        builder.writeNullableText(3, series.getDataType().toString());
        builder.writeNullableText(4, series.getEncoding().toString());
        builder.writeNullableText(5, series.getCompressor().toString());
        builder.writeNullableText(6, this.mapToString(series.getTag()));
        builder.writeNullableText(7, this.mapToString(series.getAttribute()));
        builder.writeNullableText(8, series.getDeadband());
        builder.writeNullableText(9, series.getDeadbandParameters());
        builder.declarePosition();
    }

    private String mapToString(Map<String, String> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        String content = map.entrySet().stream().map(e -> "\"" + (String)e.getKey() + "\":\"" + (String)e.getValue() + "\"").collect(Collectors.joining(","));
        return "{" + content + "}";
    }
}

