/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.exchange;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.Validate;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.sync.SyncDataNodeMPPDataExchangeServiceClient;
import org.apache.iotdb.db.mpp.execution.exchange.ISourceHandle;
import org.apache.iotdb.db.mpp.execution.exchange.MPPDataExchangeManager;
import org.apache.iotdb.db.mpp.execution.memory.LocalMemoryManager;
import org.apache.iotdb.db.utils.SetThreadName;
import org.apache.iotdb.mpp.rpc.thrift.TAcknowledgeDataBlockEvent;
import org.apache.iotdb.mpp.rpc.thrift.TFragmentInstanceId;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.column.TsBlockSerde;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceHandle
implements ISourceHandle {
    private static final Logger logger = LoggerFactory.getLogger(SourceHandle.class);
    public static final int MAX_ATTEMPT_TIMES = 3;
    private static final long DEFAULT_RETRY_INTERVAL_IN_MS = 1000L;
    private final TEndPoint remoteEndpoint;
    private final TFragmentInstanceId remoteFragmentInstanceId;
    private final TFragmentInstanceId localFragmentInstanceId;
    private final String localPlanNodeId;
    private final LocalMemoryManager localMemoryManager;
    private final ExecutorService executorService;
    private final TsBlockSerde serde;
    private final MPPDataExchangeManager.SourceHandleListener sourceHandleListener;
    private final Map<Integer, Long> sequenceIdToDataBlockSize = new HashMap<Integer, Long>();
    private final Map<Integer, ByteBuffer> sequenceIdToTsBlock = new HashMap<Integer, ByteBuffer>();
    private final String threadName;
    private long retryIntervalInMs;
    private final IClientManager<TEndPoint, SyncDataNodeMPPDataExchangeServiceClient> mppDataExchangeServiceClientManager;
    private SettableFuture<Void> blocked = SettableFuture.create();
    private ListenableFuture<Void> blockedOnMemory;
    private long bufferRetainedSizeInBytes = 0L;
    private int currSequenceId = 0;
    private int nextSequenceId = 0;
    private int lastSequenceId = Integer.MAX_VALUE;
    private boolean aborted = false;
    private boolean closed = false;

    public SourceHandle(TEndPoint remoteEndpoint, TFragmentInstanceId remoteFragmentInstanceId, TFragmentInstanceId localFragmentInstanceId, String localPlanNodeId, LocalMemoryManager localMemoryManager, ExecutorService executorService, TsBlockSerde serde, MPPDataExchangeManager.SourceHandleListener sourceHandleListener, IClientManager<TEndPoint, SyncDataNodeMPPDataExchangeServiceClient> mppDataExchangeServiceClientManager) {
        this.remoteEndpoint = (TEndPoint)Validate.notNull((Object)remoteEndpoint);
        this.remoteFragmentInstanceId = (TFragmentInstanceId)Validate.notNull((Object)remoteFragmentInstanceId);
        this.localFragmentInstanceId = (TFragmentInstanceId)Validate.notNull((Object)localFragmentInstanceId);
        this.localPlanNodeId = (String)Validate.notNull((Object)localPlanNodeId);
        this.localMemoryManager = (LocalMemoryManager)Validate.notNull((Object)localMemoryManager);
        this.executorService = (ExecutorService)Validate.notNull((Object)executorService);
        this.serde = (TsBlockSerde)Validate.notNull((Object)serde);
        this.sourceHandleListener = (MPPDataExchangeManager.SourceHandleListener)Validate.notNull((Object)sourceHandleListener);
        this.bufferRetainedSizeInBytes = 0L;
        this.mppDataExchangeServiceClientManager = mppDataExchangeServiceClientManager;
        this.retryIntervalInMs = 1000L;
        this.threadName = MPPDataExchangeManager.createFullIdFrom(localFragmentInstanceId, localPlanNodeId);
    }

    @Override
    public synchronized TsBlock receive() {
        ByteBuffer tsBlock = this.getSerializedTsBlock();
        if (tsBlock != null) {
            return this.serde.deserialize(tsBlock);
        }
        return null;
    }

    @Override
    public synchronized ByteBuffer getSerializedTsBlock() {
        try (SetThreadName sourceHandleName = new SetThreadName(this.threadName);){
            this.checkState();
            if (!this.blocked.isDone()) {
                throw new IllegalStateException("Source handle is blocked.");
            }
            ByteBuffer tsBlock = this.sequenceIdToTsBlock.remove(this.currSequenceId);
            if (tsBlock == null) {
                ByteBuffer byteBuffer = null;
                return byteBuffer;
            }
            long retainedSize = this.sequenceIdToDataBlockSize.remove(this.currSequenceId);
            logger.debug("[GetTsBlockFromBuffer] sequenceId:{}, size:{}", (Object)this.currSequenceId, (Object)retainedSize);
            ++this.currSequenceId;
            this.bufferRetainedSizeInBytes -= retainedSize;
            this.localMemoryManager.getQueryPool().free(this.localFragmentInstanceId.getQueryId(), retainedSize);
            if (this.sequenceIdToTsBlock.isEmpty() && !this.isFinished()) {
                logger.debug("[WaitForMoreTsBlock]");
                this.blocked = SettableFuture.create();
            }
            if (this.isFinished()) {
                this.sourceHandleListener.onFinished(this);
            }
            this.trySubmitGetDataBlocksTask();
            ByteBuffer byteBuffer = tsBlock;
            return byteBuffer;
        }
    }

    private synchronized void trySubmitGetDataBlocksTask() {
        if (this.aborted || this.closed) {
            return;
        }
        if (this.blockedOnMemory != null && !this.blockedOnMemory.isDone()) {
            return;
        }
        int startSequenceId = this.nextSequenceId;
        int endSequenceId = this.nextSequenceId;
        long reservedBytes = 0L;
        Pair<ListenableFuture<Void>, Boolean> pair = null;
        long blockedSize = 0L;
        while (this.sequenceIdToDataBlockSize.containsKey(endSequenceId)) {
            Long bytesToReserve = this.sequenceIdToDataBlockSize.get(endSequenceId);
            if (bytesToReserve == null) {
                throw new IllegalStateException("Data block size is null.");
            }
            pair = this.localMemoryManager.getQueryPool().reserve(this.localFragmentInstanceId.getQueryId(), bytesToReserve);
            this.bufferRetainedSizeInBytes += bytesToReserve.longValue();
            ++endSequenceId;
            reservedBytes += bytesToReserve.longValue();
            if (((Boolean)pair.right).booleanValue()) continue;
            blockedSize = bytesToReserve;
            break;
        }
        if (pair == null) {
            return;
        }
        this.nextSequenceId = endSequenceId--;
        if (!((Boolean)pair.right).booleanValue()) {
            reservedBytes -= blockedSize;
            this.blockedOnMemory = (ListenableFuture)pair.left;
            int blockedSequenceId = endSequenceId;
            long blockedRetainedSize = blockedSize;
            this.blockedOnMemory.addListener(() -> this.executorService.submit(new GetDataBlocksTask(blockedSequenceId, blockedSequenceId + 1, blockedRetainedSize)), (Executor)this.executorService);
        }
        if (endSequenceId > startSequenceId) {
            this.executorService.submit(new GetDataBlocksTask(startSequenceId, endSequenceId, reservedBytes));
        }
    }

    @Override
    public synchronized ListenableFuture<?> isBlocked() {
        this.checkState();
        return Futures.nonCancellationPropagating(this.blocked);
    }

    synchronized void setNoMoreTsBlocks(int lastSequenceId) {
        logger.debug("[ReceiveNoMoreTsBlockEvent]");
        this.lastSequenceId = lastSequenceId;
        if (!this.blocked.isDone() && this.remoteTsBlockedConsumedUp()) {
            this.blocked.set(null);
        }
        if (this.isFinished()) {
            this.sourceHandleListener.onFinished(this);
        }
    }

    synchronized void updatePendingDataBlockInfo(int startSequenceId, List<Long> dataBlockSizes) {
        logger.debug("[ReceiveNewTsBlockNotification] [{}, {}), each size is: {}", new Object[]{startSequenceId, startSequenceId + dataBlockSizes.size(), dataBlockSizes});
        for (int i = 0; i < dataBlockSizes.size(); ++i) {
            this.sequenceIdToDataBlockSize.put(i + startSequenceId, dataBlockSizes.get(i));
        }
        this.trySubmitGetDataBlocksTask();
    }

    @Override
    public synchronized void abort() {
        try (SetThreadName sourceHandleName = new SetThreadName(this.threadName);){
            if (this.aborted || this.closed) {
                return;
            }
            if (this.blocked != null && !this.blocked.isDone()) {
                this.blocked.cancel(true);
            }
            if (this.blockedOnMemory != null) {
                this.bufferRetainedSizeInBytes -= this.localMemoryManager.getQueryPool().tryCancel(this.blockedOnMemory);
            }
            this.sequenceIdToDataBlockSize.clear();
            if (this.bufferRetainedSizeInBytes > 0L) {
                this.localMemoryManager.getQueryPool().free(this.localFragmentInstanceId.getQueryId(), this.bufferRetainedSizeInBytes);
                this.bufferRetainedSizeInBytes = 0L;
            }
            this.aborted = true;
            this.sourceHandleListener.onAborted(this);
        }
    }

    @Override
    public void abort(Throwable t) {
        this.abort();
    }

    @Override
    public synchronized void close() {
        try (SetThreadName sourceHandleName = new SetThreadName(this.threadName);){
            if (this.aborted || this.closed) {
                return;
            }
            if (this.blocked != null && !this.blocked.isDone()) {
                this.blocked.set(null);
            }
            if (this.blockedOnMemory != null) {
                this.bufferRetainedSizeInBytes -= this.localMemoryManager.getQueryPool().tryCancel(this.blockedOnMemory);
            }
            this.sequenceIdToDataBlockSize.clear();
            if (this.bufferRetainedSizeInBytes > 0L) {
                this.localMemoryManager.getQueryPool().free(this.localFragmentInstanceId.getQueryId(), this.bufferRetainedSizeInBytes);
                this.bufferRetainedSizeInBytes = 0L;
            }
            this.closed = true;
            this.currSequenceId = this.lastSequenceId + 1;
            this.sourceHandleListener.onFinished(this);
        }
    }

    @Override
    public boolean isFinished() {
        return this.remoteTsBlockedConsumedUp();
    }

    private synchronized boolean remoteTsBlockedConsumedUp() {
        return this.currSequenceId - 1 == this.lastSequenceId;
    }

    public TEndPoint getRemoteEndpoint() {
        return this.remoteEndpoint;
    }

    public TFragmentInstanceId getRemoteFragmentInstanceId() {
        return this.remoteFragmentInstanceId.deepCopy();
    }

    @Override
    public TFragmentInstanceId getLocalFragmentInstanceId() {
        return this.localFragmentInstanceId;
    }

    @Override
    public String getLocalPlanNodeId() {
        return this.localPlanNodeId;
    }

    @Override
    public long getBufferRetainedSizeInBytes() {
        return this.bufferRetainedSizeInBytes;
    }

    @Override
    public boolean isAborted() {
        return this.aborted;
    }

    private void checkState() {
        if (this.aborted) {
            throw new IllegalStateException("Source handle is aborted.");
        }
        if (this.closed) {
            throw new IllegalStateException("SourceHandle is closed.");
        }
    }

    public String toString() {
        return String.format("Query[%s]-[%s-%s-SourceHandle-%s]", this.localFragmentInstanceId.getQueryId(), this.localFragmentInstanceId.getFragmentId(), this.localFragmentInstanceId.getInstanceId(), this.localPlanNodeId);
    }

    public void setRetryIntervalInMs(long retryIntervalInMs) {
        this.retryIntervalInMs = retryIntervalInMs;
    }

    static /* synthetic */ ExecutorService access$500(SourceHandle x0) {
        return x0.executorService;
    }

    static /* synthetic */ Map access$800(SourceHandle x0) {
        return x0.sequenceIdToTsBlock;
    }

    static /* synthetic */ SettableFuture access$900(SourceHandle x0) {
        return x0.blocked;
    }

    class SendAcknowledgeDataBlockEventTask
    implements Runnable {
        private final int startSequenceId;
        private final int endSequenceId;

        public SendAcknowledgeDataBlockEventTask(int startSequenceId, int endSequenceId) {
            this.startSequenceId = startSequenceId;
            this.endSequenceId = endSequenceId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            try (SetThreadName sourceHandleName = new SetThreadName(SourceHandle.this.threadName);){
                logger.debug("[SendACKTsBlock] [{}, {}).", (Object)this.startSequenceId, (Object)this.endSequenceId);
                int attempt = 0;
                TAcknowledgeDataBlockEvent acknowledgeDataBlockEvent = new TAcknowledgeDataBlockEvent(SourceHandle.this.remoteFragmentInstanceId, this.startSequenceId, this.endSequenceId);
                while (attempt < 3) {
                    ++attempt;
                    try (SyncDataNodeMPPDataExchangeServiceClient client = (SyncDataNodeMPPDataExchangeServiceClient)SourceHandle.this.mppDataExchangeServiceClientManager.borrowClient((Object)SourceHandle.this.remoteEndpoint);){
                        client.onAcknowledgeDataBlockEvent(acknowledgeDataBlockEvent);
                        return;
                    }
                    catch (Throwable e) {
                        logger.warn("failed to send ack data block event [{}, {}), attempt times: {}", new Object[]{this.startSequenceId, this.endSequenceId, attempt, e});
                        if (attempt == 3) {
                            SourceHandle sourceHandle = SourceHandle.this;
                            // MONITORENTER : sourceHandle
                            SourceHandle.this.sourceHandleListener.onFailure(SourceHandle.this, e);
                            // MONITOREXIT : sourceHandle
                        }
                        try {
                            Thread.sleep(SourceHandle.this.retryIntervalInMs);
                        }
                        catch (InterruptedException ex) {
                            Thread.currentThread().interrupt();
                            SourceHandle sourceHandle = SourceHandle.this;
                            // MONITORENTER : sourceHandle
                            SourceHandle.this.sourceHandleListener.onFailure(SourceHandle.this, e);
                            // MONITOREXIT : sourceHandle
                        }
                    }
                }
                return;
            }
        }
    }

    class GetDataBlocksTask
    implements Runnable {
        private final int startSequenceId;
        private final int endSequenceId;
        private final long reservedBytes;

        GetDataBlocksTask(int startSequenceId, int endSequenceId, long reservedBytes) {
            Validate.isTrue((startSequenceId >= 0 ? 1 : 0) != 0, (String)("Start sequence ID should be greater than or equal to zero. Start sequence ID: " + startSequenceId), (Object[])new Object[0]);
            this.startSequenceId = startSequenceId;
            Validate.isTrue((endSequenceId > startSequenceId ? 1 : 0) != 0, (String)("End sequence ID should be greater than the start sequence ID. Start sequence ID: " + startSequenceId + ", end sequence ID: " + endSequenceId), (Object[])new Object[0]);
            this.endSequenceId = endSequenceId;
            Validate.isTrue((reservedBytes > 0L ? 1 : 0) != 0, (String)"Reserved bytes should be greater than zero.", (Object[])new Object[0]);
            this.reservedBytes = reservedBytes;
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [13[MONITOR]], but top level block is 2[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fail(Throwable t) {
            SourceHandle sourceHandle = SourceHandle.this;
            synchronized (sourceHandle) {
                if (SourceHandle.this.aborted || SourceHandle.this.closed) {
                    return;
                }
                SourceHandle.this.bufferRetainedSizeInBytes -= this.reservedBytes;
                SourceHandle.this.localMemoryManager.getQueryPool().free(SourceHandle.this.localFragmentInstanceId.getQueryId(), this.reservedBytes);
                SourceHandle.this.sourceHandleListener.onFailure(SourceHandle.this, t);
            }
        }
    }
}

