/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.exchange;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.nio.ByteBuffer;
import org.apache.commons.lang3.Validate;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.db.mpp.execution.exchange.ISourceHandle;
import org.apache.iotdb.db.mpp.execution.exchange.MPPDataExchangeManager;
import org.apache.iotdb.db.mpp.execution.exchange.SharedTsBlockQueue;
import org.apache.iotdb.db.utils.SetThreadName;
import org.apache.iotdb.mpp.rpc.thrift.TFragmentInstanceId;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.column.TsBlockSerde;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalSourceHandle
implements ISourceHandle {
    private static final Logger logger = LoggerFactory.getLogger(LocalSourceHandle.class);
    private final TFragmentInstanceId remoteFragmentInstanceId;
    private final TFragmentInstanceId localFragmentInstanceId;
    private final String localPlanNodeId;
    private final MPPDataExchangeManager.SourceHandleListener sourceHandleListener;
    private final SharedTsBlockQueue queue;
    private boolean aborted = false;
    private boolean closed = false;
    private int currSequenceId;
    private final String threadName;
    private static final TsBlockSerde serde = new TsBlockSerde();

    public LocalSourceHandle(TFragmentInstanceId remoteFragmentInstanceId, TFragmentInstanceId localFragmentInstanceId, String localPlanNodeId, SharedTsBlockQueue queue, MPPDataExchangeManager.SourceHandleListener sourceHandleListener) {
        this.remoteFragmentInstanceId = (TFragmentInstanceId)Validate.notNull((Object)remoteFragmentInstanceId);
        this.localFragmentInstanceId = (TFragmentInstanceId)Validate.notNull((Object)localFragmentInstanceId);
        this.localPlanNodeId = (String)Validate.notNull((Object)localPlanNodeId);
        this.queue = (SharedTsBlockQueue)Validate.notNull((Object)queue);
        this.queue.setSourceHandle(this);
        this.sourceHandleListener = (MPPDataExchangeManager.SourceHandleListener)Validate.notNull((Object)sourceHandleListener);
        this.threadName = MPPDataExchangeManager.createFullIdFrom(localFragmentInstanceId, localPlanNodeId);
    }

    @Override
    public TFragmentInstanceId getLocalFragmentInstanceId() {
        return this.localFragmentInstanceId;
    }

    @Override
    public String getLocalPlanNodeId() {
        return this.localPlanNodeId;
    }

    @Override
    public long getBufferRetainedSizeInBytes() {
        return this.queue.getBufferRetainedSizeInBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TsBlock receive() {
        try (SetThreadName sourceHandleName = new SetThreadName(this.threadName);){
            TsBlock tsBlock;
            this.checkState();
            if (!this.queue.isBlocked().isDone()) {
                throw new IllegalStateException("Source handle is blocked.");
            }
            SharedTsBlockQueue sharedTsBlockQueue = this.queue;
            synchronized (sharedTsBlockQueue) {
                tsBlock = this.queue.remove();
            }
            if (tsBlock != null) {
                logger.debug("[GetTsBlockFromQueue] TsBlock:{} size:{}", (Object)this.currSequenceId, (Object)tsBlock.getRetainedSizeInBytes());
                ++this.currSequenceId;
            }
            this.checkAndInvokeOnFinished();
            sharedTsBlockQueue = tsBlock;
            return sharedTsBlockQueue;
        }
    }

    @Override
    public ByteBuffer getSerializedTsBlock() throws IoTDBException {
        TsBlock tsBlock = this.receive();
        if (tsBlock != null) {
            try {
                return serde.serialize(tsBlock);
            }
            catch (Exception e) {
                throw new IoTDBException((Throwable)e, TSStatusCode.TSBLOCK_SERIALIZE_ERROR.getStatusCode());
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFinished() {
        SharedTsBlockQueue sharedTsBlockQueue = this.queue;
        synchronized (sharedTsBlockQueue) {
            return this.queue.hasNoMoreTsBlocks() && this.queue.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkAndInvokeOnFinished() {
        SharedTsBlockQueue sharedTsBlockQueue = this.queue;
        synchronized (sharedTsBlockQueue) {
            if (this.isFinished()) {
                LocalSourceHandle localSourceHandle = this;
                synchronized (localSourceHandle) {
                    this.sourceHandleListener.onFinished(this);
                }
            }
        }
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        this.checkState();
        return Futures.nonCancellationPropagating(this.queue.isBlocked());
    }

    @Override
    public boolean isAborted() {
        return this.aborted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void abort() {
        if (this.aborted) return;
        if (this.closed) {
            return;
        }
        try (SetThreadName sourceHandleName = new SetThreadName(this.threadName);){
            logger.debug("[StartAbortLocalSourceHandle]");
            SharedTsBlockQueue sharedTsBlockQueue = this.queue;
            synchronized (sharedTsBlockQueue) {
                LocalSourceHandle localSourceHandle = this;
                synchronized (localSourceHandle) {
                    if (this.aborted) return;
                    if (this.closed) {
                        return;
                    }
                    this.queue.abort();
                    this.aborted = true;
                    this.sourceHandleListener.onAborted(this);
                }
            }
            logger.debug("[EndAbortLocalSourceHandle]");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void abort(Throwable t) {
        if (this.aborted) return;
        if (this.closed) {
            return;
        }
        try (SetThreadName sourceHandleName = new SetThreadName(this.threadName);){
            logger.debug("[StartAbortLocalSourceHandle]");
            SharedTsBlockQueue sharedTsBlockQueue = this.queue;
            synchronized (sharedTsBlockQueue) {
                LocalSourceHandle localSourceHandle = this;
                synchronized (localSourceHandle) {
                    if (this.aborted) return;
                    if (this.closed) {
                        return;
                    }
                    this.queue.abort(t);
                    this.aborted = true;
                    this.sourceHandleListener.onAborted(this);
                }
            }
            logger.debug("[EndAbortLocalSourceHandle]");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() {
        if (this.aborted) return;
        if (this.closed) {
            return;
        }
        try (SetThreadName sourceHandleName = new SetThreadName(this.threadName);){
            logger.debug("[StartCloseLocalSourceHandle]");
            SharedTsBlockQueue sharedTsBlockQueue = this.queue;
            synchronized (sharedTsBlockQueue) {
                LocalSourceHandle localSourceHandle = this;
                synchronized (localSourceHandle) {
                    if (this.aborted) return;
                    if (this.closed) {
                        return;
                    }
                    this.queue.close();
                    this.closed = true;
                    this.sourceHandleListener.onFinished(this);
                }
            }
            logger.debug("[EndCloseLocalSourceHandle]");
            return;
        }
    }

    private void checkState() {
        if (this.aborted) {
            throw new IllegalStateException("Source handle is aborted.");
        }
        if (this.closed) {
            throw new IllegalStateException("Source Handle is closed.");
        }
    }

    public TFragmentInstanceId getRemoteFragmentInstanceId() {
        return this.remoteFragmentInstanceId;
    }

    SharedTsBlockQueue getSharedTsBlockQueue() {
        return this.queue;
    }
}

