/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree.store.disk.schemafile.pagemgr;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Queue;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.db.exception.metadata.schemafile.ColossalRecordException;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mtree.store.disk.schemafile.ISchemaPage;
import org.apache.iotdb.db.metadata.mtree.store.disk.schemafile.ISegmentedPage;
import org.apache.iotdb.db.metadata.mtree.store.disk.schemafile.SchemaFile;
import org.apache.iotdb.db.metadata.mtree.store.disk.schemafile.SchemaFileConfig;
import org.apache.iotdb.db.metadata.mtree.store.disk.schemafile.SchemaPage;
import org.apache.iotdb.db.metadata.mtree.store.disk.schemafile.pagemgr.PageManager;

public class BTreePageManager
extends PageManager {
    public BTreePageManager(FileChannel channel, int lastPageIndex, String logPath) throws IOException, MetadataException {
        super(channel, lastPageIndex, logPath);
    }

    @Override
    protected void multiPageInsertOverflowOperation(ISchemaPage curPage, String key, ByteBuffer childBuffer) throws MetadataException, IOException {
        ISegmentedPage newPage = this.getMinApplSegmentedPageInMem((short)16350);
        newPage.allocNewSegment((short)16350);
        String sk = curPage.getAsSegmentedPage().splitWrappedSegment(key, childBuffer, newPage, true);
        curPage.getAsSegmentedPage().setNextSegAddress((short)0, SchemaFile.getGlobalIndex(newPage.getPageIndex(), (short)0));
        this.markDirty(curPage);
        this.insertIndexEntryEntrance(curPage, newPage, sk);
    }

    @Override
    protected void multiPageUpdateOverflowOperation(ISchemaPage curPage, String key, ByteBuffer childBuffer) throws MetadataException, IOException {
        ISegmentedPage splPage = this.getMinApplSegmentedPageInMem((short)16350);
        splPage.allocNewSegment((short)16350);
        String sk = curPage.getAsSegmentedPage().splitWrappedSegment(null, null, splPage, false);
        curPage.getAsSegmentedPage().setNextSegAddress((short)0, SchemaFile.getGlobalIndex(splPage.getPageIndex(), (short)0));
        if (key.compareTo(sk) >= 0) {
            splPage.update((short)0, key, childBuffer);
        } else {
            curPage.getAsSegmentedPage().update((short)0, key, childBuffer);
        }
        this.insertIndexEntryEntrance(curPage, splPage, sk);
    }

    @Override
    protected void buildSubIndex(IMNode parNode) throws MetadataException, IOException {
        ISchemaPage cursorPage = this.getPageInstance(SchemaFile.getPageIndex(SchemaFile.getNodeAddress(parNode)));
        if (cursorPage.getAsInternalPage() == null) {
            throw new MetadataException("Subordinate index shall not build upon single page segment.");
        }
        ISchemaPage tPage = cursorPage;
        ISchemaPage subIndexPage = ISchemaPage.initAliasIndexPage(ByteBuffer.allocate(16384), -1);
        this.registerAsNewPage(subIndexPage);
        while (cursorPage.getAsInternalPage() != null) {
            cursorPage = this.getPageInstance(SchemaFile.getPageIndex(cursorPage.getAsInternalPage().getNextSegAddress()));
        }
        long nextAddr = cursorPage.getAsSegmentedPage().getNextSegAddress((short)0);
        Queue<IMNode> children = cursorPage.getAsSegmentedPage().getChildren((short)0);
        while (children.size() != 0 || nextAddr != -1L) {
            IMNode child;
            if (children.size() == 0) {
                cursorPage = this.getPageInstance(SchemaFile.getPageIndex(nextAddr));
                nextAddr = cursorPage.getAsSegmentedPage().getNextSegAddress((short)0);
                children = cursorPage.getAsSegmentedPage().getChildren((short)0);
            }
            if ((child = children.poll()) == null || !child.isMeasurement() || child.getAsMeasurementMNode().getAlias() == null) continue;
            subIndexPage = this.insertAliasIndexEntry(subIndexPage, child.getAsMeasurementMNode().getAlias(), child.getName());
        }
        tPage.setSubIndex(subIndexPage.getPageIndex());
    }

    @Override
    protected void insertSubIndexEntry(int base, String key, String rec) throws MetadataException, IOException {
        this.insertAliasIndexEntry(this.getPageInstance(base), key, rec);
    }

    @Override
    protected void removeSubIndexEntry(int base, String oldAlias) throws MetadataException, IOException {
        ISchemaPage tarPage = this.getTargetLeafPage(this.getPageInstance(base), oldAlias);
        tarPage.getAsAliasIndexPage().removeRecord(oldAlias);
    }

    @Override
    protected String searchSubIndexAlias(int base, String alias) throws MetadataException, IOException {
        return this.getTargetLeafPage(this.getPageInstance(base), alias).getAsAliasIndexPage().getRecordByAlias(alias);
    }

    private ISchemaPage insertAliasIndexEntry(ISchemaPage topPage, String alias, String name) throws MetadataException, IOException {
        ISchemaPage tarPage = this.getTargetLeafPage(topPage, alias);
        if (tarPage.getAsAliasIndexPage() == null) {
            throw new MetadataException("File may be corrupted that subordinate index has broken.");
        }
        if (tarPage.getAsAliasIndexPage().insertRecord(alias, name) < 0) {
            ByteBuffer spltBuf = ByteBuffer.allocate(16384);
            String sk = tarPage.getAsAliasIndexPage().splitByKey(alias, name, spltBuf, true);
            SchemaPage splPage = ISchemaPage.loadSchemaPage(spltBuf);
            this.registerAsNewPage(splPage);
            if (this.treeTrace[0] < 1) {
                ByteBuffer trsBuf = ByteBuffer.allocate(16384);
                tarPage.getAsAliasIndexPage().extendsTo(trsBuf);
                SchemaPage trsPage = ISchemaPage.loadSchemaPage(trsBuf);
                this.registerAsNewPage(trsPage);
                SchemaPage repPage = ISchemaPage.initInternalPage(ByteBuffer.allocate(16384), tarPage.getPageIndex(), trsPage.getPageIndex());
                if (0 > repPage.getAsInternalPage().insertRecord(sk, splPage.getPageIndex())) {
                    throw new ColossalRecordException(sk, alias);
                }
                repPage.getAsInternalPage().setNextSegAddress(SchemaFile.getGlobalIndex(trsPage.getPageIndex(), (short)0));
                this.replacePageInCache(repPage);
                return repPage;
            }
            this.insertIndexEntryRecursiveUpwards(this.treeTrace[0], sk, splPage.getPageIndex());
            return this.getPageInstance(this.treeTrace[1]);
        }
        return topPage;
    }

    private void insertIndexEntryEntrance(ISchemaPage curPage, ISchemaPage splPage, String sk) throws MetadataException, IOException {
        if (this.treeTrace[0] < 1) {
            ISegmentedPage trsPage = this.getMinApplSegmentedPageInMem((short)16350);
            trsPage.transplantSegment(curPage.getAsSegmentedPage(), (short)0, (short)16350);
            SchemaPage repPage = ISchemaPage.initInternalPage(ByteBuffer.allocate(16384), curPage.getPageIndex(), trsPage.getPageIndex());
            if (0 > repPage.getAsInternalPage().insertRecord(sk, splPage.getPageIndex())) {
                throw new ColossalRecordException(sk);
            }
            repPage.getAsInternalPage().setNextSegAddress(SchemaFile.getGlobalIndex(trsPage.getPageIndex(), (short)0));
            this.replacePageInCache(repPage);
        } else {
            this.insertIndexEntryRecursiveUpwards(this.treeTrace[0], sk, splPage.getPageIndex());
        }
    }

    private void insertIndexEntryRecursiveUpwards(int treeTraceIndex, String key, int ptr) throws MetadataException, IOException {
        ISchemaPage idxPage = this.getPageInstance(this.treeTrace[treeTraceIndex]);
        if (idxPage.getAsInternalPage().insertRecord(key, ptr) < 0) {
            if (treeTraceIndex > 1) {
                ByteBuffer dstBuffer = ByteBuffer.allocate(16384);
                String splitKey = idxPage.getAsInternalPage().splitByKey(key, ptr, dstBuffer, true);
                SchemaPage dstPage = ISchemaPage.loadSchemaPage(dstBuffer);
                this.registerAsNewPage(dstPage);
                this.insertIndexEntryRecursiveUpwards(treeTraceIndex - 1, splitKey, dstPage.getPageIndex());
            } else {
                ByteBuffer splBuffer = ByteBuffer.allocate(16384);
                ByteBuffer trsBuffer = ByteBuffer.allocate(16384);
                String splitKey = idxPage.getAsInternalPage().splitByKey(key, ptr, splBuffer, true);
                idxPage.getAsInternalPage().extendsTo(trsBuffer);
                SchemaPage splPage = ISchemaPage.loadSchemaPage(splBuffer);
                SchemaPage trsPage = ISchemaPage.loadSchemaPage(trsBuffer);
                this.registerAsNewPage(splPage);
                this.registerAsNewPage(trsPage);
                idxPage.getAsInternalPage().resetBuffer(trsPage.getPageIndex());
                if (idxPage.getAsInternalPage().insertRecord(splitKey, splPage.getPageIndex()) < 0) {
                    throw new ColossalRecordException(splitKey);
                }
                idxPage.getAsInternalPage().setNextSegAddress(trsPage.getAsInternalPage().getNextSegAddress());
            }
        }
        this.markDirty(idxPage);
        this.addPageToCache(idxPage.getPageIndex(), idxPage);
    }

    @Override
    public void delete(IMNode node) throws IOException, MetadataException {
        long recSegAddr = SchemaFile.getNodeAddress(node.getParent());
        recSegAddr = this.getTargetSegmentAddress(recSegAddr, node.getName());
        ISchemaPage tarPage = this.getPageInstance(SchemaFile.getPageIndex(recSegAddr));
        this.markDirty(tarPage);
        tarPage.getAsSegmentedPage().removeRecord(SchemaFile.getSegIndex(recSegAddr), node.getName());
        if (!node.isMeasurement()) {
            long delSegAddr = SchemaFile.getNodeAddress(node);
            tarPage = this.getPageInstance(SchemaFile.getPageIndex(delSegAddr));
            if (tarPage.getAsSegmentedPage() != null) {
                this.markDirty(tarPage);
                tarPage.getAsSegmentedPage().deleteSegment(SchemaFile.getSegIndex(delSegAddr));
                if (tarPage.getAsSegmentedPage().validSegments() == 0) {
                    tarPage.getAsSegmentedPage().purgeSegments();
                }
            }
            if (tarPage.getAsInternalPage() != null) {
                ArrayDeque<Integer> cascadePages = new ArrayDeque<Integer>(tarPage.getAsInternalPage().getAllRecords());
                cascadePages.add(tarPage.getPageIndex());
                if (tarPage.getSubIndex() >= 0) {
                    cascadePages.add(tarPage.getSubIndex());
                }
                while (cascadePages.size() != 0) {
                    if (this.dirtyPages.size() > SchemaFileConfig.PAGE_CACHE_SIZE) {
                        this.flushDirtyPages();
                    }
                    if ((tarPage = this.getPageInstance((Integer)cascadePages.poll())).getAsSegmentedPage() != null) {
                        tarPage.getAsSegmentedPage().purgeSegments();
                        this.markDirty(tarPage);
                        this.addPageToCache(tarPage.getPageIndex(), tarPage);
                        continue;
                    }
                    if (tarPage.getAsInternalPage() != null) {
                        cascadePages.addAll(tarPage.getAsInternalPage().getAllRecords());
                    }
                    tarPage = ISchemaPage.initSegmentedPage(ByteBuffer.allocate(16384), tarPage.getPageIndex());
                    this.replacePageInCache(tarPage);
                }
            }
        }
        this.flushDirtyPages();
    }

    @Override
    public IMNode getChildNode(IMNode parent, String childName) throws MetadataException, IOException {
        if (SchemaFile.getNodeAddress(parent) < 0L) {
            throw new MetadataException(String.format("Node [%s] has no valid segment address in schema file.", parent.getFullPath()));
        }
        long actualSegAddr = this.getTargetSegmentAddress(SchemaFile.getNodeAddress(parent), childName);
        IMNode child = this.getPageInstance(SchemaFile.getPageIndex(actualSegAddr)).getAsSegmentedPage().read(SchemaFile.getSegIndex(actualSegAddr), childName);
        if (child == null && parent.isEntity()) {
            child = this.getPageInstance(SchemaFile.getPageIndex(actualSegAddr)).getAsSegmentedPage().readByAlias(SchemaFile.getSegIndex(actualSegAddr), childName);
            if (child != null) {
                return child;
            }
            return this.getChildWithAlias(parent, childName);
        }
        return child;
    }

    private IMNode getChildWithAlias(IMNode par, String alias) throws IOException, MetadataException {
        long srtAddr = SchemaFile.getNodeAddress(par);
        ISchemaPage page = this.getPageInstance(SchemaFile.getPageIndex(srtAddr));
        if (page.getAsInternalPage() == null || page.getSubIndex() < 0) {
            return null;
        }
        String name = this.searchSubIndexAlias(page.getSubIndex(), alias);
        if (name == null) {
            return null;
        }
        return this.getTargetLeafPage(page, name).getAsSegmentedPage().read((short)0, name);
    }

    @Override
    public Iterator<IMNode> getChildren(IMNode parent) throws MetadataException, IOException {
        int pageIdx = SchemaFile.getPageIndex(SchemaFile.getNodeAddress(parent));
        short segId = SchemaFile.getSegIndex(SchemaFile.getNodeAddress(parent));
        ISchemaPage page = this.getPageInstance(pageIdx);
        while (page.getAsSegmentedPage() == null) {
            page = this.getPageInstance(SchemaFile.getPageIndex(page.getAsInternalPage().getNextSegAddress()));
        }
        final long actualSegAddr = page.getAsSegmentedPage().getNextSegAddress(segId);
        final Queue<IMNode> initChildren = page.getAsSegmentedPage().getChildren(segId);
        return new Iterator<IMNode>(){
            long nextSeg;
            Queue<IMNode> children;
            {
                this.nextSeg = actualSegAddr;
                this.children = initChildren;
            }

            @Override
            public boolean hasNext() {
                if (this.children.size() > 0) {
                    return true;
                }
                if (this.nextSeg < 0L) {
                    return false;
                }
                try {
                    while (this.children.size() == 0 && this.nextSeg >= 0L) {
                        ISchemaPage nPage = BTreePageManager.this.getPageInstance(SchemaFile.getPageIndex(this.nextSeg));
                        this.children = nPage.getAsSegmentedPage().getChildren(SchemaFile.getSegIndex(this.nextSeg));
                        this.nextSeg = nPage.getAsSegmentedPage().getNextSegAddress(SchemaFile.getSegIndex(this.nextSeg));
                    }
                }
                catch (IOException | MetadataException e) {
                    PageManager.logger.error(e.getMessage());
                    return false;
                }
                return this.children.size() > 0;
            }

            @Override
            public IMNode next() {
                return this.children.poll();
            }
        };
    }

    private ISchemaPage getTargetLeafPage(ISchemaPage topPage, String recKey) throws IOException, MetadataException {
        this.treeTrace[0] = 0;
        if (topPage.getAsInternalPage() == null) {
            return topPage;
        }
        ISchemaPage curPage = topPage;
        int i = 0;
        while (curPage.getAsInternalPage() != null) {
            this.treeTrace[++i] = curPage.getPageIndex();
            curPage = this.getPageInstance(curPage.getAsInternalPage().getRecordByKey(recKey));
        }
        this.treeTrace[0] = i;
        return curPage;
    }

    @Override
    protected long getTargetSegmentAddress(long curSegAddr, String recKey) throws IOException, MetadataException {
        this.treeTrace[0] = 0;
        ISchemaPage curPage = this.getPageInstance(SchemaFile.getPageIndex(curSegAddr));
        if (curPage.getAsSegmentedPage() != null) {
            return curSegAddr;
        }
        int i = 0;
        while (curPage.getAsInternalPage() != null) {
            this.treeTrace[++i] = curPage.getPageIndex();
            curPage = this.getPageInstance(curPage.getAsInternalPage().getRecordByKey(recKey));
        }
        this.treeTrace[0] = i;
        return SchemaFile.getGlobalIndex(curPage.getPageIndex(), (short)0);
    }
}

