/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.idtable;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.AlignedPath;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.metadata.idtable.IDiskSchemaManager;
import org.apache.iotdb.db.metadata.idtable.entry.DeviceEntry;
import org.apache.iotdb.db.metadata.idtable.entry.DeviceIDFactory;
import org.apache.iotdb.db.metadata.idtable.entry.DiskSchemaEntry;
import org.apache.iotdb.db.metadata.idtable.entry.IDeviceID;
import org.apache.iotdb.db.metadata.idtable.entry.SchemaEntry;
import org.apache.iotdb.db.metadata.idtable.entry.TimeseriesID;
import org.apache.iotdb.db.metadata.plan.schemaregion.write.ICreateAlignedTimeSeriesPlan;
import org.apache.iotdb.db.metadata.plan.schemaregion.write.ICreateTimeSeriesPlan;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface IDTable {
    public static final Logger logger = LoggerFactory.getLogger(IDTable.class);
    public static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();

    public void createAlignedTimeseries(ICreateAlignedTimeSeriesPlan var1) throws MetadataException;

    public void createTimeseries(ICreateTimeSeriesPlan var1) throws MetadataException;

    public Pair<Integer, Set<String>> deleteTimeseries(List<PartialPath> var1) throws MetadataException;

    public void clear() throws IOException;

    public DeviceEntry getDeviceEntry(String var1);

    public IMeasurementSchema getSeriesSchema(String var1, String var2);

    public List<DeviceEntry> getAllDeviceEntry();

    public void putSchemaEntry(String var1, String var2, SchemaEntry var3, boolean var4) throws MetadataException;

    public static PartialPath translateQueryPath(PartialPath fullPath) {
        if (!config.isEnableIDTable()) {
            return fullPath;
        }
        try {
            if (fullPath instanceof AlignedPath) {
                AlignedPath cur = (AlignedPath)fullPath;
                return new AlignedPath(DeviceIDFactory.getInstance().getDeviceID((PartialPath)cur).toStringID(), cur.getMeasurementList(), cur.getSchemaList());
            }
            TimeseriesID timeseriesID = new TimeseriesID(fullPath);
            return new MeasurementPath(timeseriesID.getDeviceID().toStringID(), timeseriesID.getMeasurement(), fullPath.getMeasurementSchema());
        }
        catch (MetadataException e) {
            logger.error("Error when translate query path: " + fullPath);
            throw new IllegalArgumentException("can't translate path to device id, path is: " + fullPath);
        }
    }

    public List<DiskSchemaEntry> getDiskSchemaEntries(List<SchemaEntry> var1);

    public Map<IDeviceID, DeviceEntry>[] getIdTables();

    public IDiskSchemaManager getIDiskSchemaManager();
}

