/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.querycontext;

import java.util.List;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.qp.utils.DateTimeUtils;
import org.apache.iotdb.tsfile.read.filter.TimeFilter;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.operator.AndFilter;

public class QueryDataSource {
    private List<TsFileResource> seqResources;
    private List<TsFileResource> unseqResources;
    private int[] unSeqFileOrderIndex;
    private long dataTTL = Long.MAX_VALUE;

    public QueryDataSource(List<TsFileResource> seqResources, List<TsFileResource> unseqResources) {
        this.seqResources = seqResources;
        this.unseqResources = unseqResources;
    }

    public List<TsFileResource> getSeqResources() {
        return this.seqResources;
    }

    public List<TsFileResource> getUnseqResources() {
        return this.unseqResources;
    }

    public void setUnSeqFileOrderIndex(int[] index) {
        this.unSeqFileOrderIndex = index;
    }

    public long getDataTTL() {
        return this.dataTTL;
    }

    public void setDataTTL(long dataTTL) {
        this.dataTTL = dataTTL;
    }

    public Filter updateFilterUsingTTL(Filter filter) {
        return QueryDataSource.updateFilterUsingTTL(filter, this.dataTTL);
    }

    public static Filter updateFilterUsingTTL(Filter filter, long dataTTL) {
        if (dataTTL != Long.MAX_VALUE) {
            filter = filter != null ? new AndFilter(filter, (Filter)TimeFilter.gtEq((long)(DateTimeUtils.currentTime() - dataTTL))) : TimeFilter.gtEq((long)(DateTimeUtils.currentTime() - dataTTL));
        }
        return filter;
    }

    public TsFileResource getSeqResourceByIndex(int curIndex) {
        if (curIndex < this.seqResources.size()) {
            return this.seqResources.get(curIndex);
        }
        return null;
    }

    public TsFileResource getUnseqResourceByIndex(int curIndex) {
        int actualIndex = this.unSeqFileOrderIndex[curIndex];
        if (actualIndex < this.unseqResources.size()) {
            return this.unseqResources.get(actualIndex);
        }
        return null;
    }

    public boolean hasNextSeqResource(int curIndex, boolean ascending) {
        return ascending ? curIndex < this.seqResources.size() : curIndex >= 0;
    }

    public boolean hasNextUnseqResource(int curIndex) {
        return curIndex < this.unseqResources.size();
    }

    public int getSeqResourcesSize() {
        return this.seqResources.size();
    }

    public int getUnseqResourcesSize() {
        return this.unseqResources.size();
    }
}

