/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.cross.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.engine.compaction.cross.utils.ChunkMetadataElement;
import org.apache.iotdb.db.engine.compaction.cross.utils.FileElement;
import org.apache.iotdb.db.engine.compaction.cross.utils.PageElement;
import org.apache.iotdb.db.engine.compaction.reader.PointPriorityReader;
import org.apache.iotdb.db.engine.compaction.task.SubCompactionTaskSummary;
import org.apache.iotdb.db.engine.compaction.writer.AbstractCompactionWriter;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.WriteProcessException;
import org.apache.iotdb.tsfile.exception.write.PageException;
import org.apache.iotdb.tsfile.file.metadata.AlignedChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.read.reader.chunk.AlignedChunkReader;

public abstract class SeriesCompactionExecutor {
    private final SubCompactionTaskSummary summary;
    protected List<FileElement> fileList = new ArrayList<FileElement>();
    protected final PriorityQueue<ChunkMetadataElement> chunkMetadataQueue;
    protected final PriorityQueue<PageElement> pageQueue;
    protected AbstractCompactionWriter compactionWriter;
    protected int subTaskId;
    protected Map<TsFileResource, TsFileSequenceReader> readerCacheMap;
    private final Map<TsFileResource, List<Modification>> modificationCacheMap;
    private final PointPriorityReader pointPriorityReader = new PointPriorityReader(this::removePage);
    protected String deviceId;
    private final List<PageElement> candidateOverlappedPages = new ArrayList<PageElement>();

    public SeriesCompactionExecutor(AbstractCompactionWriter compactionWriter, Map<TsFileResource, TsFileSequenceReader> readerCacheMap, Map<TsFileResource, List<Modification>> modificationCacheMap, String deviceId, int subTaskId, SubCompactionTaskSummary summary) {
        this.compactionWriter = compactionWriter;
        this.subTaskId = subTaskId;
        this.deviceId = deviceId;
        this.readerCacheMap = readerCacheMap;
        this.modificationCacheMap = modificationCacheMap;
        this.summary = summary;
        this.chunkMetadataQueue = new PriorityQueue((o1, o2) -> {
            int timeCompare = Long.compare(o1.startTime, o2.startTime);
            return timeCompare != 0 ? timeCompare : Long.compare(o2.priority, o1.priority);
        });
        this.pageQueue = new PriorityQueue((o1, o2) -> {
            int timeCompare = Long.compare(o1.startTime, o2.startTime);
            return timeCompare != 0 ? timeCompare : Long.compare(o2.priority, o1.priority);
        });
    }

    public abstract void execute() throws PageException, IllegalPathException, IOException, WriteProcessException;

    protected abstract void compactFiles() throws PageException, IOException, WriteProcessException, IllegalPathException;

    protected void compactChunks() throws IOException, PageException, WriteProcessException, IllegalPathException {
        while (!this.chunkMetadataQueue.isEmpty()) {
            ChunkMetadataElement firstChunkMetadataElement = this.chunkMetadataQueue.peek();
            List<ChunkMetadataElement> overlappedChunkMetadataList = this.findOverlapChunkMetadatas(firstChunkMetadataElement);
            boolean isChunkOverlap = overlappedChunkMetadataList.size() > 1;
            boolean isModified = firstChunkMetadataElement.chunkMetadata.isModified();
            if (isChunkOverlap || isModified) {
                this.summary.CHUNK_OVERLAP_OR_MODIFIED += overlappedChunkMetadataList.size();
                this.compactWithOverlapChunks(overlappedChunkMetadataList);
                continue;
            }
            ++this.summary.CHUNK_NONE_OVERLAP;
            this.compactWithNonOverlapChunk(firstChunkMetadataElement);
        }
    }

    private void compactWithOverlapChunks(List<ChunkMetadataElement> overlappedChunkMetadataList) throws IOException, PageException, WriteProcessException, IllegalPathException {
        for (ChunkMetadataElement overlappedChunkMetadata : overlappedChunkMetadataList) {
            this.readChunk(overlappedChunkMetadata);
            this.deserializeChunkIntoQueue(overlappedChunkMetadata);
        }
        this.compactPages();
    }

    private void compactWithNonOverlapChunk(ChunkMetadataElement chunkMetadataElement) throws IOException, PageException, WriteProcessException, IllegalPathException {
        this.readChunk(chunkMetadataElement);
        boolean success = chunkMetadataElement.chunkMetadata instanceof AlignedChunkMetadata ? this.compactionWriter.flushAlignedChunk(chunkMetadataElement.chunk, ((AlignedChunkMetadata)chunkMetadataElement.chunkMetadata).getTimeChunkMetadata(), chunkMetadataElement.valueChunks, ((AlignedChunkMetadata)chunkMetadataElement.chunkMetadata).getValueChunkMetadataList(), this.subTaskId) : this.compactionWriter.flushNonAlignedChunk(chunkMetadataElement.chunk, (ChunkMetadata)chunkMetadataElement.chunkMetadata, this.subTaskId);
        if (success) {
            this.removeChunk(this.chunkMetadataQueue.peek());
        } else {
            ++this.summary.CHUNK_NONE_OVERLAP_BUT_DESERIALIZE;
            this.deserializeChunkIntoQueue(chunkMetadataElement);
            this.compactPages();
        }
    }

    abstract void deserializeChunkIntoQueue(ChunkMetadataElement var1) throws IOException;

    abstract void readChunk(ChunkMetadataElement var1) throws IOException;

    abstract void deserializeFileIntoQueue(List<FileElement> var1) throws IOException, IllegalPathException;

    private void compactPages() throws IOException, PageException, WriteProcessException, IllegalPathException {
        while (!this.pageQueue.isEmpty()) {
            boolean isPageOverlap;
            PageElement firstPageElement = this.pageQueue.peek();
            ModifiedStatus modifiedStatus = this.isPageModified(firstPageElement);
            if (modifiedStatus == ModifiedStatus.ALL_DELETED) {
                this.removePage(firstPageElement);
                continue;
            }
            List<PageElement> overlapPages = this.findOverlapPages(firstPageElement);
            boolean bl = isPageOverlap = overlapPages.size() > 1;
            if (isPageOverlap || modifiedStatus == ModifiedStatus.PARTIAL_DELETED) {
                ++this.summary.PAGE_OVERLAP_OR_MODIFIED;
                this.pointPriorityReader.addNewPage(overlapPages.remove(0));
                this.addOverlappedPagesIntoList(overlapPages);
                this.compactWithOverlapPages();
                continue;
            }
            ++this.summary.PAGE_NONE_OVERLAP;
            this.compactWithNonOverlapPage(firstPageElement);
        }
    }

    private void compactWithNonOverlapPage(PageElement pageElement) throws PageException, IOException, WriteProcessException, IllegalPathException {
        boolean success = pageElement.iChunkReader instanceof AlignedChunkReader ? this.compactionWriter.flushAlignedPage(pageElement.pageData, pageElement.pageHeader, pageElement.valuePageDatas, pageElement.valuePageHeaders, this.subTaskId) : this.compactionWriter.flushNonAlignedPage(pageElement.pageData, pageElement.pageHeader, this.subTaskId);
        if (success) {
            this.removePage(pageElement);
        } else {
            ++this.summary.PAGE_NONE_OVERLAP_BUT_DESERIALIZE;
            this.pointPriorityReader.addNewPage(pageElement);
            while (this.pointPriorityReader.hasNext() && this.pointPriorityReader.currentPoint().getTimestamp() <= pageElement.pageHeader.getEndTime()) {
                this.compactionWriter.write(this.pointPriorityReader.currentPoint(), this.subTaskId);
                this.pointPriorityReader.next();
            }
        }
    }

    private void compactWithOverlapPages() throws IOException, PageException, WriteProcessException, IllegalPathException {
        this.checkAndCompactOverlapPages();
        while (this.pointPriorityReader.hasNext()) {
            this.compactionWriter.write(this.pointPriorityReader.currentPoint(), this.subTaskId);
            this.pointPriorityReader.next();
            if (this.candidateOverlappedPages.size() <= 0) continue;
            this.checkAndCompactOverlapPages();
        }
    }

    private void checkAndCompactOverlapPages() throws IllegalPathException, IOException, WriteProcessException, PageException {
        while (this.candidateOverlappedPages.size() > 0) {
            PageElement nextPageElement = this.candidateOverlappedPages.get(0);
            int oldSize = this.candidateOverlappedPages.size();
            while (this.pointPriorityReader.hasNext() && this.pointPriorityReader.currentPoint().getTimestamp() < nextPageElement.startTime) {
                this.compactionWriter.write(this.pointPriorityReader.currentPoint(), this.subTaskId);
                this.pointPriorityReader.next();
                if (this.candidateOverlappedPages.size() <= oldSize) continue;
                oldSize = this.candidateOverlappedPages.size();
                nextPageElement = this.candidateOverlappedPages.get(0);
            }
            ModifiedStatus nextPageModifiedStatus = this.isPageModified(nextPageElement);
            if (nextPageModifiedStatus == ModifiedStatus.ALL_DELETED) {
                this.removePage(nextPageElement);
            } else {
                boolean isNextPageOverlap;
                boolean bl = isNextPageOverlap = this.pointPriorityReader.hasNext() && this.pointPriorityReader.currentPoint().getTimestamp() <= nextPageElement.pageHeader.getEndTime() || this.isPageOverlap(nextPageElement);
                if (isNextPageOverlap || nextPageModifiedStatus == ModifiedStatus.PARTIAL_DELETED) {
                    this.pointPriorityReader.addNewPage(nextPageElement);
                } else {
                    ++this.summary.PAGE_FAKE_OVERLAP;
                    this.compactWithNonOverlapPage(nextPageElement);
                }
            }
            this.candidateOverlappedPages.remove(0);
        }
    }

    private void addOverlappedPagesIntoList(List<PageElement> newOverlappedPages) {
        this.summary.PAGE_OVERLAP_OR_MODIFIED += newOverlappedPages.size();
        int oldSize = this.candidateOverlappedPages.size();
        this.candidateOverlappedPages.addAll(newOverlappedPages);
        if (oldSize != 0 && this.candidateOverlappedPages.size() > oldSize) {
            this.candidateOverlappedPages.sort(Comparator.comparingLong(o -> o.startTime));
        }
    }

    private List<PageElement> findOverlapPages(PageElement page) {
        ArrayList<PageElement> elements = new ArrayList<PageElement>();
        long endTime = page.pageHeader.getEndTime();
        for (PageElement element : this.pageQueue) {
            if (element.startTime > endTime || element.isSelected) continue;
            elements.add(element);
            element.isSelected = true;
        }
        elements.sort(Comparator.comparingLong(o -> o.startTime));
        return elements;
    }

    private List<ChunkMetadataElement> findOverlapChunkMetadatas(ChunkMetadataElement chunkMetadataElement) {
        ArrayList<ChunkMetadataElement> elements = new ArrayList<ChunkMetadataElement>();
        long endTime = chunkMetadataElement.chunkMetadata.getEndTime();
        for (ChunkMetadataElement element : this.chunkMetadataQueue) {
            if (element.chunkMetadata.getStartTime() > endTime || element.isSelected) continue;
            elements.add(element);
            element.isSelected = true;
        }
        elements.sort(Comparator.comparingLong(o -> o.startTime));
        return elements;
    }

    protected List<FileElement> findOverlapFiles(FileElement file) {
        ArrayList<FileElement> overlappedFiles = new ArrayList<FileElement>();
        long endTime = file.resource.getEndTime(this.deviceId);
        for (FileElement fileElement : this.fileList) {
            if (fileElement.resource.getStartTime(this.deviceId) > endTime) break;
            if (fileElement.isSelected) continue;
            overlappedFiles.add(fileElement);
            fileElement.isSelected = true;
        }
        return overlappedFiles;
    }

    private boolean isPageOverlap(PageElement pageElement) {
        long endTime = pageElement.pageHeader.getEndTime();
        long startTime = pageElement.startTime;
        for (PageElement element : this.pageQueue) {
            if (element.equals(pageElement) || element.startTime < startTime || element.startTime > endTime) continue;
            return true;
        }
        return false;
    }

    protected abstract ModifiedStatus isPageModified(PageElement var1);

    protected ModifiedStatus checkIsModified(long startTime, long endTime, Collection<TimeRange> deletions) {
        ModifiedStatus status = ModifiedStatus.NONE_DELETED;
        if (deletions != null) {
            for (TimeRange range : deletions) {
                if (range.contains(startTime, endTime)) {
                    return ModifiedStatus.ALL_DELETED;
                }
                if (!range.overlaps(new TimeRange(startTime, endTime))) continue;
                status = ModifiedStatus.PARTIAL_DELETED;
            }
        }
        return status;
    }

    private void removePage(PageElement pageElement) throws IOException, IllegalPathException {
        boolean isFirstPage = this.pageQueue.peek().equals(pageElement);
        boolean hasNewOverlappedChunks = false;
        this.pageQueue.remove(pageElement);
        if (pageElement.isLastPage) {
            hasNewOverlappedChunks = this.removeChunk(pageElement.chunkMetadataElement);
        }
        if ((isFirstPage || hasNewOverlappedChunks) && (this.pointPriorityReader.hasNext() || this.candidateOverlappedPages.size() > 0) && this.pageQueue.size() != 0) {
            this.addOverlappedPagesIntoList(this.findOverlapPages(this.pageQueue.peek()));
        }
    }

    private boolean removeChunk(ChunkMetadataElement chunkMetadataElement) throws IOException, IllegalPathException {
        boolean hasNewOverlappedChunks = false;
        boolean isFirstChunk = this.chunkMetadataQueue.peek().equals(chunkMetadataElement);
        boolean hasNewOverlappedFiles = false;
        this.chunkMetadataQueue.remove(chunkMetadataElement);
        if (chunkMetadataElement.isLastChunk) {
            hasNewOverlappedFiles = this.removeFile(chunkMetadataElement.fileElement);
        }
        if ((isFirstChunk || hasNewOverlappedFiles) && this.pageQueue.size() != 0 && this.chunkMetadataQueue.size() != 0) {
            for (ChunkMetadataElement newOverlappedChunkMetadata : this.findOverlapChunkMetadatas(this.chunkMetadataQueue.peek())) {
                ++this.summary.CHUNK_OVERLAP_OR_MODIFIED;
                this.readChunk(newOverlappedChunkMetadata);
                this.deserializeChunkIntoQueue(newOverlappedChunkMetadata);
                hasNewOverlappedChunks = true;
            }
        }
        return hasNewOverlappedChunks;
    }

    protected boolean removeFile(FileElement fileElement) throws IllegalPathException, IOException {
        boolean hasNewOverlappedFiles = false;
        boolean isFirstFile = this.fileList.get(0).equals(fileElement);
        this.fileList.remove(fileElement);
        if (isFirstFile && !this.fileList.isEmpty()) {
            List<FileElement> newOverlappedFiles = this.findOverlapFiles(this.fileList.get(0));
            this.deserializeFileIntoQueue(newOverlappedFiles);
            hasNewOverlappedFiles = newOverlappedFiles.size() > 0;
        }
        return hasNewOverlappedFiles;
    }

    protected List<Modification> getModificationsFromCache(TsFileResource tsFileResource, PartialPath path) {
        List modifications = this.modificationCacheMap.computeIfAbsent(tsFileResource, resource -> new ArrayList<Modification>(resource.getModFile().getModifications()));
        ArrayList<Modification> pathModifications = new ArrayList<Modification>();
        for (Modification modification : modifications) {
            if (!modification.getPath().matchFullPath(path)) continue;
            pathModifications.add(modification);
        }
        return pathModifications;
    }

    @FunctionalInterface
    public static interface RemovePage {
        public void call(PageElement var1) throws WriteProcessException, IOException, IllegalPathException;
    }

    protected static enum ModifiedStatus {
        ALL_DELETED,
        PARTIAL_DELETED,
        NONE_DELETED;

    }
}

