/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.conf;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.commons.conf.CommonConfig;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.conf.IoTDBConstant;
import org.apache.iotdb.commons.exception.ConfigurationException;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.confignode.rpc.thrift.TGlobalConfig;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.conf.directories.DirectoryChecker;
import org.apache.iotdb.db.wal.utils.WALMode;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.fileSystem.fsFactory.FSFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBStartCheck {
    private static final Logger logger = LoggerFactory.getLogger(IoTDBStartCheck.class);
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final CommonConfig commonConfig = CommonDescriptor.getInstance().getConfig();
    private FSFactory fsFactory = FSFactoryProducer.getFSFactory();
    private static final String PROPERTIES_FILE_NAME = "system.properties";
    private static final String SCHEMA_DIR = config.getSchemaDir();
    private static final String[] WAL_DIRS = commonConfig.getWalDirs();
    private File propertiesFile;
    private File tmpPropertiesFile;
    private Properties properties = new Properties();
    private Map<String, String> systemProperties = new HashMap<String, String>();
    private static final String SYSTEM_PROPERTIES_STRING = "System properties:";
    private static final String TIMESTAMP_PRECISION_STRING = "timestamp_precision";
    private static String timestampPrecision = config.getTimestampPrecision();
    private static final String PARTITION_INTERVAL_STRING = "time_partition_interval";
    private static long timePartitionInterval = config.getTimePartitionInterval();
    private static final String TSFILE_FILE_SYSTEM_STRING = "tsfile_storage_fs";
    private static String tsfileFileSystem = config.getTsFileStorageFs().toString();
    private static final String TAG_ATTRIBUTE_SIZE_STRING = "tag_attribute_total_size";
    private static String tagAttributeTotalSize = String.valueOf(config.getTagAttributeTotalSize());
    private static final String TAG_ATTRIBUTE_FLUSH_INTERVAL = "tag_attribute_flush_interval";
    private static String tagAttributeFlushInterval = String.valueOf(config.getTagAttributeFlushInterval());
    private static final String MAX_DEGREE_OF_INDEX_STRING = "max_degree_of_index_node";
    private static String maxDegreeOfIndexNode = String.valueOf(TSFileDescriptor.getInstance().getConfig().getMaxDegreeOfIndexNode());
    private static final String DATA_REGION_NUM = "data_region_num";
    private static final String VIRTUAL_STORAGE_GROUP_NUM = "virtual_storage_group_num";
    private static String dataRegionNum = String.valueOf(config.getDataRegionNum());
    private static final String ENABLE_ID_TABLE = "enable_id_table";
    private static String enableIDTable = String.valueOf(config.isEnableIDTable());
    private static final String ENABLE_ID_TABLE_LOG_FILE = "enable_id_table_log_file";
    private static String enableIdTableLogFile = String.valueOf(config.isEnableIDTableLogFile());
    private static final String SCHEMA_ENGINE_MODE = "schema_engine_mode";
    private static String schemaEngineMode = String.valueOf(config.getSchemaEngineMode());
    private static final String TIME_ENCODER_KEY = "time_encoder";
    private static String timeEncoderValue = String.valueOf(TSFileDescriptor.getInstance().getConfig().getTimeEncoder());
    private static final String DATA_NODE_ID = "data_node_id";
    private static final String SCHEMA_REGION_CONSENSUS_PROTOCOL = "schema_region_consensus_protocol";
    private static final String DATA_REGION_CONSENSUS_PROTOCOL = "data_region_consensus_protocol";
    private static final String IOTDB_VERSION_STRING = "iotdb_version";
    private static final String INTERNAL_ADDRESS = "dn_internal_address";
    private static final String internalAddress = config.getInternalAddress();
    private static final String INTERNAL_PORT = "dn_internal_port";
    private static final String internalPort = String.valueOf(config.getInternalPort());
    private static final String RPC_ADDRESS = "dn_rpc_address";
    private static final String rpcAddress = config.getRpcAddress();
    private static final String RPC_PORT = "dn_rpc_port";
    private static final String rpcPort = String.valueOf(config.getRpcPort());
    private static final String MPP_DATA_EXCHANGE_PORT = "dn_mpp_data_exchange_port";
    private static final String mppDataExchangePort = String.valueOf(config.getMppDataExchangePort());
    private static final String SCHEMA_REGION_CONSENSUS_PORT = "dn_schema_region_consensus_port";
    private static final String schemaRegionConsensusPort = String.valueOf(config.getSchemaRegionConsensusPort());
    private static final String DATA_REGION_CONSENSUS_PORT = "dn_data_region_consensus_port";
    private static final String dataRegionConsensusPort = String.valueOf(config.getDataRegionConsensusPort());

    public static IoTDBStartCheck getInstance() {
        return IoTDBConfigCheckHolder.INSTANCE;
    }

    private IoTDBStartCheck() {
        logger.info("Starting IoTDB " + IoTDBConstant.VERSION_WITH_BUILD);
        File dir = SystemFileFactory.INSTANCE.getFile(SCHEMA_DIR);
        if (!dir.exists()) {
            if (!dir.mkdirs()) {
                logger.error("can not create schema dir: {}", (Object)SCHEMA_DIR);
                System.exit(-1);
            } else {
                logger.info(" {} dir has been created.", (Object)SCHEMA_DIR);
            }
        }
        if (!("ms".equals(timestampPrecision) || "us".equals(timestampPrecision) || "ns".equals(timestampPrecision))) {
            logger.error("Wrong {}, please set as: ms, us or ns ! Current is: {}", (Object)TIMESTAMP_PRECISION_STRING, (Object)timestampPrecision);
            System.exit(-1);
        }
        this.systemProperties.put(IOTDB_VERSION_STRING, IoTDBConstant.VERSION);
        this.systemProperties.put(TIMESTAMP_PRECISION_STRING, timestampPrecision);
        this.systemProperties.put(PARTITION_INTERVAL_STRING, String.valueOf(timePartitionInterval));
        this.systemProperties.put(TSFILE_FILE_SYSTEM_STRING, tsfileFileSystem);
        this.systemProperties.put(TAG_ATTRIBUTE_SIZE_STRING, tagAttributeTotalSize);
        this.systemProperties.put(TAG_ATTRIBUTE_FLUSH_INTERVAL, tagAttributeFlushInterval);
        this.systemProperties.put(MAX_DEGREE_OF_INDEX_STRING, maxDegreeOfIndexNode);
        this.systemProperties.put(DATA_REGION_NUM, dataRegionNum);
        this.systemProperties.put(TIME_ENCODER_KEY, timeEncoderValue);
        this.systemProperties.put(ENABLE_ID_TABLE, enableIDTable);
        this.systemProperties.put(ENABLE_ID_TABLE_LOG_FILE, enableIdTableLogFile);
        this.systemProperties.put(SCHEMA_ENGINE_MODE, schemaEngineMode);
        this.systemProperties.put(INTERNAL_ADDRESS, internalAddress);
        this.systemProperties.put(INTERNAL_PORT, internalPort);
        this.systemProperties.put(RPC_ADDRESS, rpcAddress);
        this.systemProperties.put(RPC_PORT, rpcPort);
        this.systemProperties.put(MPP_DATA_EXCHANGE_PORT, mppDataExchangePort);
        this.systemProperties.put(SCHEMA_REGION_CONSENSUS_PORT, schemaRegionConsensusPort);
        this.systemProperties.put(DATA_REGION_CONSENSUS_PORT, dataRegionConsensusPort);
    }

    public void checkDirectory() throws ConfigurationException, IOException {
        for (String dataDir : config.getDataDirs()) {
            DirectoryChecker.getInstance().registerDirectory(new File(dataDir));
        }
        DirectoryChecker.getInstance().registerDirectory(new File(config.getSystemDir()));
        if (!(config.isClusterMode() && config.getDataRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.ratis.RatisConsensus") || config.getWalMode().equals((Object)WALMode.DISABLE))) {
            for (String walDir : commonConfig.getWalDirs()) {
                DirectoryChecker.getInstance().registerDirectory(new File(walDir));
            }
        }
        if (config.isClusterMode()) {
            DirectoryChecker.getInstance().registerDirectory(new File(config.getConsensusDir()));
        }
    }

    public void checkConfig() throws ConfigurationException, IOException {
        String versionString;
        this.propertiesFile = SystemFileFactory.INSTANCE.getFile(SCHEMA_DIR + File.separator + PROPERTIES_FILE_NAME);
        this.tmpPropertiesFile = SystemFileFactory.INSTANCE.getFile(SCHEMA_DIR + File.separator + PROPERTIES_FILE_NAME + ".tmp");
        if (!this.propertiesFile.exists() && !this.tmpPropertiesFile.exists()) {
            if (this.propertiesFile.createNewFile()) {
                logger.info(" {} has been created.", (Object)this.propertiesFile.getAbsolutePath());
            } else {
                logger.error("can not create {}", (Object)this.propertiesFile.getAbsolutePath());
                System.exit(-1);
            }
            try (FileOutputStream outputStream = new FileOutputStream(this.propertiesFile);){
                this.systemProperties.forEach((k, v) -> this.properties.setProperty((String)k, (String)v));
                this.properties.store(outputStream, SYSTEM_PROPERTIES_STRING);
            }
            return;
        }
        if (!this.propertiesFile.exists() && this.tmpPropertiesFile.exists()) {
            FileUtils.moveFile((File)this.tmpPropertiesFile, (File)this.propertiesFile);
            logger.info("rename {} to {}", (Object)this.tmpPropertiesFile, (Object)this.propertiesFile);
            return;
        }
        if (this.propertiesFile.exists() && this.tmpPropertiesFile.exists()) {
            FileUtils.forceDelete((File)this.tmpPropertiesFile);
            logger.info("remove {}", (Object)this.tmpPropertiesFile);
        }
        try (FileInputStream inputStream = new FileInputStream(this.propertiesFile);
             InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inputStream, TSFileConfig.STRING_CHARSET);){
            this.properties.load(inputStreamReader);
        }
        if (!this.properties.containsKey(IOTDB_VERSION_STRING)) {
            logger.error("DO NOT UPGRADE IoTDB from v0.9 or lower version to v0.12! Please upgrade to v0.10 first");
            System.exit(-1);
        }
        if ((versionString = this.properties.getProperty(IOTDB_VERSION_STRING)).startsWith("0.10") || versionString.startsWith("0.11")) {
            logger.error("IoTDB version is too old, please upgrade to 0.12 firstly.");
            System.exit(-1);
        } else if (versionString.startsWith("0.12") || versionString.startsWith("0.13")) {
            this.checkWALNotExists();
            this.upgradePropertiesFile();
        }
        this.checkProperties();
    }

    private void checkWALNotExists() {
        for (String walDir : WAL_DIRS) {
            File[] sgWALs;
            if (!SystemFileFactory.INSTANCE.getFile(walDir).isDirectory() || (sgWALs = SystemFileFactory.INSTANCE.getFile(walDir).listFiles()) == null) continue;
            for (File sgWAL : sgWALs) {
                if (!sgWAL.isDirectory() || sgWAL.list().length == 0) continue;
                logger.error("WAL detected, please stop insertion and run 'SET SYSTEM TO READONLY', then run 'flush' on IoTDB {} before upgrading to {}.", (Object)this.properties.getProperty(IOTDB_VERSION_STRING), (Object)IoTDBConstant.VERSION);
                System.exit(-1);
            }
        }
    }

    private void upgradePropertiesFile() throws IOException {
        if (this.tmpPropertiesFile.createNewFile()) {
            logger.info("Create system.properties.tmp {}.", (Object)this.tmpPropertiesFile);
        } else {
            logger.error("Create system.properties.tmp {} failed.", (Object)this.tmpPropertiesFile);
            System.exit(-1);
        }
        try (FileOutputStream tmpFOS = new FileOutputStream(this.tmpPropertiesFile.toString());){
            this.systemProperties.forEach((k, v) -> {
                if (!this.properties.containsKey(k)) {
                    this.properties.setProperty((String)k, (String)v);
                }
            });
            this.properties.setProperty(IOTDB_VERSION_STRING, IoTDBConstant.VERSION);
            this.properties.setProperty(DATA_REGION_NUM, this.properties.getProperty(VIRTUAL_STORAGE_GROUP_NUM));
            this.properties.remove(VIRTUAL_STORAGE_GROUP_NUM);
            this.properties.store(tmpFOS, SYSTEM_PROPERTIES_STRING);
            if (this.propertiesFile.exists()) {
                Files.delete(this.propertiesFile.toPath());
            }
        }
        FileUtils.moveFile((File)this.tmpPropertiesFile, (File)this.propertiesFile);
    }

    private void upgradePropertiesFileFromBrokenFile() throws IOException {
        if (this.tmpPropertiesFile.createNewFile()) {
            logger.info("Create system.properties.tmp {}.", (Object)this.tmpPropertiesFile);
        } else {
            logger.error("Create system.properties.tmp {} failed.", (Object)this.tmpPropertiesFile);
            System.exit(-1);
        }
        try (FileOutputStream tmpFOS = new FileOutputStream(this.tmpPropertiesFile.toString());){
            this.systemProperties.forEach((k, v) -> {
                if (!this.properties.containsKey(k)) {
                    this.properties.setProperty((String)k, (String)v);
                }
            });
            this.properties.setProperty(IOTDB_VERSION_STRING, IoTDBConstant.VERSION);
            this.properties.store(tmpFOS, SYSTEM_PROPERTIES_STRING);
            if (this.propertiesFile.exists()) {
                Files.delete(this.propertiesFile.toPath());
            }
        }
        FileUtils.moveFile((File)this.tmpPropertiesFile, (File)this.propertiesFile);
    }

    private void checkProperties() throws ConfigurationException, IOException {
        for (Map.Entry<String, String> entry : this.systemProperties.entrySet()) {
            if (this.properties.containsKey(entry.getKey())) continue;
            this.upgradePropertiesFileFromBrokenFile();
            logger.info("repair system.properties, lack {}", (Object)entry.getKey());
        }
        if (!this.properties.getProperty(TIMESTAMP_PRECISION_STRING).equals(timestampPrecision)) {
            this.throwException(TIMESTAMP_PRECISION_STRING, timestampPrecision);
        }
        if (!this.properties.getProperty(TSFILE_FILE_SYSTEM_STRING).equals(tsfileFileSystem)) {
            this.throwException(TSFILE_FILE_SYSTEM_STRING, tsfileFileSystem);
        }
        if (!this.properties.getProperty(TAG_ATTRIBUTE_SIZE_STRING).equals(tagAttributeTotalSize)) {
            this.throwException(TAG_ATTRIBUTE_SIZE_STRING, tagAttributeTotalSize);
        }
        if (!this.properties.getProperty(TAG_ATTRIBUTE_FLUSH_INTERVAL).equals(tagAttributeFlushInterval)) {
            this.throwException(TAG_ATTRIBUTE_FLUSH_INTERVAL, tagAttributeFlushInterval);
        }
        if (!this.properties.getProperty(MAX_DEGREE_OF_INDEX_STRING).equals(maxDegreeOfIndexNode)) {
            this.throwException(MAX_DEGREE_OF_INDEX_STRING, maxDegreeOfIndexNode);
        }
        if (!this.properties.getProperty(DATA_REGION_NUM).equals(dataRegionNum)) {
            this.throwException(DATA_REGION_NUM, dataRegionNum);
        }
        if (!this.properties.getProperty(TIME_ENCODER_KEY).equals(timeEncoderValue)) {
            this.throwException(TIME_ENCODER_KEY, timeEncoderValue);
        }
        if (!this.properties.getProperty(ENABLE_ID_TABLE).equals(enableIDTable)) {
            this.throwException(ENABLE_ID_TABLE, enableIDTable);
        }
        if (!this.properties.getProperty(ENABLE_ID_TABLE_LOG_FILE).equals(enableIdTableLogFile)) {
            this.throwException(ENABLE_ID_TABLE_LOG_FILE, enableIdTableLogFile);
        }
        if (!this.properties.getProperty(SCHEMA_ENGINE_MODE).equals(schemaEngineMode)) {
            this.throwException(SCHEMA_ENGINE_MODE, schemaEngineMode);
        }
        if (this.properties.containsKey(DATA_NODE_ID)) {
            config.setDataNodeId(Integer.parseInt(this.properties.getProperty(DATA_NODE_ID)));
        }
        if (this.properties.containsKey(SCHEMA_REGION_CONSENSUS_PROTOCOL)) {
            config.setSchemaRegionConsensusProtocolClass(this.properties.getProperty(SCHEMA_REGION_CONSENSUS_PROTOCOL));
        }
        if (this.properties.containsKey(DATA_REGION_CONSENSUS_PROTOCOL)) {
            config.setDataRegionConsensusProtocolClass(this.properties.getProperty(DATA_REGION_CONSENSUS_PROTOCOL));
        }
    }

    private void throwException(String parameter, Object badValue) throws ConfigurationException {
        throw new ConfigurationException(parameter, String.valueOf(badValue), this.properties.getProperty(parameter));
    }

    private void reloadProperties() throws IOException {
        try (FileInputStream inputStream = new FileInputStream(this.propertiesFile);
             InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inputStream, TSFileConfig.STRING_CHARSET);){
            this.properties.load(inputStreamReader);
        }
    }

    public void serializeDataNodeId(int dataNodeId) throws IOException {
        if (this.tmpPropertiesFile.createNewFile()) {
            logger.info("Create system.properties.tmp {}.", (Object)this.tmpPropertiesFile);
        } else {
            logger.error("Create system.properties.tmp {} failed.", (Object)this.tmpPropertiesFile);
            System.exit(-1);
        }
        this.reloadProperties();
        try (FileOutputStream tmpFOS = new FileOutputStream(this.tmpPropertiesFile.toString());){
            this.properties.setProperty(DATA_NODE_ID, String.valueOf(dataNodeId));
            this.properties.store(tmpFOS, SYSTEM_PROPERTIES_STRING);
            if (this.propertiesFile.exists()) {
                Files.delete(this.propertiesFile.toPath());
            }
        }
        FileUtils.moveFile((File)this.tmpPropertiesFile, (File)this.propertiesFile);
    }

    public void serializeConsensusProtocol(String regionConsensusProtocol, TConsensusGroupType type) throws IOException {
        if (this.tmpPropertiesFile.createNewFile()) {
            logger.info("Create system.properties.tmp {}.", (Object)this.tmpPropertiesFile);
        } else {
            logger.error("Create system.properties.tmp {} failed.", (Object)this.tmpPropertiesFile);
            System.exit(-1);
        }
        this.reloadProperties();
        try (FileOutputStream tmpFOS = new FileOutputStream(this.tmpPropertiesFile.toString());){
            if (type == TConsensusGroupType.DataRegion) {
                this.properties.setProperty(DATA_REGION_CONSENSUS_PROTOCOL, regionConsensusProtocol);
            } else if (type == TConsensusGroupType.SchemaRegion) {
                this.properties.setProperty(SCHEMA_REGION_CONSENSUS_PROTOCOL, regionConsensusProtocol);
            }
            this.properties.store(tmpFOS, SYSTEM_PROPERTIES_STRING);
            if (this.propertiesFile.exists()) {
                Files.delete(this.propertiesFile.toPath());
            }
        }
        FileUtils.moveFile((File)this.tmpPropertiesFile, (File)this.propertiesFile);
    }

    public void serializeGlobalConfig(TGlobalConfig globalConfig) throws IOException {
        if (this.tmpPropertiesFile.createNewFile()) {
            logger.info("Create system.properties.tmp {}.", (Object)this.tmpPropertiesFile);
        } else {
            logger.error("Create system.properties.tmp {} failed.", (Object)this.tmpPropertiesFile);
            System.exit(-1);
        }
        this.reloadProperties();
        try (FileOutputStream tmpFOS = new FileOutputStream(this.tmpPropertiesFile.toString());){
            if (!this.checkConsensusProtocolExists(TConsensusGroupType.DataRegion)) {
                this.properties.setProperty(DATA_REGION_CONSENSUS_PROTOCOL, globalConfig.getDataRegionConsensusProtocolClass());
            }
            if (!this.checkConsensusProtocolExists(TConsensusGroupType.SchemaRegion)) {
                this.properties.setProperty(SCHEMA_REGION_CONSENSUS_PROTOCOL, globalConfig.getSchemaRegionConsensusProtocolClass());
            }
            this.properties.store(tmpFOS, SYSTEM_PROPERTIES_STRING);
            if (this.propertiesFile.exists()) {
                Files.delete(this.propertiesFile.toPath());
            }
        }
        FileUtils.moveFile((File)this.tmpPropertiesFile, (File)this.propertiesFile);
    }

    public void serializeNewDataNode(TDataNodeLocation dataNodeLocation) throws IOException {
        this.reloadProperties();
        try (FileOutputStream fileOutputStream = new FileOutputStream(this.propertiesFile);){
            this.properties.setProperty(INTERNAL_ADDRESS, dataNodeLocation.getInternalEndPoint().getIp());
            this.properties.setProperty(INTERNAL_PORT, String.valueOf(dataNodeLocation.getInternalEndPoint().getPort()));
            this.properties.setProperty(RPC_ADDRESS, String.valueOf(dataNodeLocation.getClientRpcEndPoint().getIp()));
            this.properties.setProperty(RPC_PORT, String.valueOf(dataNodeLocation.getClientRpcEndPoint().getPort()));
            this.properties.setProperty(MPP_DATA_EXCHANGE_PORT, String.valueOf(dataNodeLocation.getMPPDataExchangeEndPoint().getPort()));
            this.properties.setProperty(SCHEMA_REGION_CONSENSUS_PORT, String.valueOf(dataNodeLocation.getSchemaRegionConsensusEndPoint().getPort()));
            this.properties.setProperty(DATA_REGION_CONSENSUS_PORT, String.valueOf(dataNodeLocation.getDataRegionConsensusEndPoint().getPort()));
            this.properties.store(fileOutputStream, SYSTEM_PROPERTIES_STRING);
        }
    }

    public boolean checkConsensusProtocolExists(TConsensusGroupType type) {
        if (type == TConsensusGroupType.DataRegion) {
            return this.properties.containsKey(DATA_REGION_CONSENSUS_PROTOCOL);
        }
        if (type == TConsensusGroupType.SchemaRegion) {
            return this.properties.containsKey(SCHEMA_REGION_CONSENSUS_PROTOCOL);
        }
        logger.error("Unexpected consensus group type");
        return false;
    }

    public boolean isIpPortUpdated() {
        boolean isUpdated = false;
        if (!this.properties.getProperty(INTERNAL_PORT).equals(internalPort)) {
            isUpdated = true;
            logger.info("Internal port is updated from {} to {}", (Object)this.properties.getProperty(INTERNAL_PORT), (Object)internalPort);
        }
        if (!this.properties.getProperty(RPC_ADDRESS).equals(rpcAddress)) {
            isUpdated = true;
            logger.info("RPC address is updated from {} to {}", (Object)this.properties.getProperty(RPC_ADDRESS), (Object)rpcAddress);
        }
        if (!this.properties.getProperty(RPC_PORT).equals(rpcPort)) {
            isUpdated = true;
            logger.info("RPC port is updated from {} to {}", (Object)this.properties.getProperty(RPC_PORT), (Object)rpcPort);
        }
        if (!this.properties.getProperty(MPP_DATA_EXCHANGE_PORT).equals(mppDataExchangePort)) {
            isUpdated = true;
            logger.info("MPP data exchange port is updated from {} to {}", (Object)this.properties.getProperty(MPP_DATA_EXCHANGE_PORT), (Object)mppDataExchangePort);
        }
        return isUpdated;
    }

    public boolean checkNonModifiableConfiguration() {
        if (!this.properties.getProperty(INTERNAL_ADDRESS).equals(internalAddress)) {
            logger.error("Internal address is not allowed to be updated");
            return true;
        }
        if (!this.properties.getProperty(SCHEMA_REGION_CONSENSUS_PORT).equals(schemaRegionConsensusPort)) {
            logger.error("Schema region consensus port is not allowed to be updated");
            return true;
        }
        if (!this.properties.getProperty(DATA_REGION_CONSENSUS_PORT).equals(dataRegionConsensusPort)) {
            logger.error("Data region consensus port is not allowed to be updated");
            return true;
        }
        return false;
    }

    private static class IoTDBConfigCheckHolder {
        private static final IoTDBStartCheck INSTANCE = new IoTDBStartCheck();

        private IoTDBConfigCheckHolder() {
        }
    }
}

