/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.TimeDuration;
import org.apache.ratis.util.function.CheckedConsumer;
import org.apache.ratis.util.function.CheckedFunction;

public interface ConcurrentUtils {
    public static <E, THROWABLE extends Throwable> E updateAndGet(AtomicReference<E> reference, CheckedFunction<E, E, THROWABLE> update) throws THROWABLE {
        AtomicReference throwableRef = new AtomicReference();
        E updated = reference.updateAndGet(value -> {
            try {
                return update.apply(value);
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable t) {
                throwableRef.set(t);
                return value;
            }
        });
        Throwable t = (Throwable)throwableRef.get();
        if (t != null) {
            throw t;
        }
        return updated;
    }

    public static ThreadFactory newThreadFactory(String namePrefix) {
        AtomicInteger numThread = new AtomicInteger();
        return runnable -> {
            int id = numThread.incrementAndGet();
            Thread t = new Thread(runnable);
            t.setName(namePrefix + "-thread" + id);
            return t;
        };
    }

    public static ExecutorService newCachedThreadPool(int maximumPoolSize, ThreadFactory threadFactory) {
        return maximumPoolSize == 0 ? Executors.newCachedThreadPool(threadFactory) : new ThreadPoolExecutor(0, maximumPoolSize, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
    }

    public static ExecutorService newThreadPoolWithMax(boolean cached, int maximumPoolSize, String namePrefix) {
        ThreadFactory f = ConcurrentUtils.newThreadFactory(namePrefix);
        return cached ? ConcurrentUtils.newCachedThreadPool(maximumPoolSize, f) : Executors.newFixedThreadPool(maximumPoolSize, f);
    }

    public static void shutdownAndWait(ExecutorService executor) {
        ConcurrentUtils.shutdownAndWait(TimeDuration.ONE_DAY, executor, timeout -> {
            throw new IllegalStateException(executor.getClass().getName() + " shutdown timeout in " + timeout);
        });
    }

    public static void shutdownAndWait(TimeDuration waitTime, ExecutorService executor, Consumer<TimeDuration> timoutHandler) {
        executor.shutdown();
        try {
            if (executor.awaitTermination(waitTime.getDuration(), waitTime.getUnit())) {
                return;
            }
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
            return;
        }
        if (timoutHandler != null) {
            timoutHandler.accept(waitTime);
        }
    }

    public static <E, THROWABLE extends Throwable> CompletableFuture<Void> parallelForEachAsync(Collection<E> collection, CheckedConsumer<? super E, THROWABLE> action, Executor executor) {
        ArrayList futures = new ArrayList(collection.size());
        collection.forEach(element -> {
            CompletableFuture f = new CompletableFuture();
            futures.add(f);
            executor.execute(() -> ConcurrentUtils.accept(action, element, f));
        });
        return JavaUtils.allOf(futures);
    }

    public static <E, THROWABLE extends Throwable> void accept(CheckedConsumer<? super E, THROWABLE> action, E element, CompletableFuture<E> f) {
        try {
            action.accept(element);
            f.complete(element);
        }
        catch (Throwable t) {
            f.completeExceptionally(t);
        }
    }
}

