/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.common;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.commons.utils.BasicStructureSerDeUtil;
import org.apache.iotdb.commons.utils.ThriftCommonsSerDeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Peer {
    private final Logger LOGGER = LoggerFactory.getLogger(Peer.class);
    private final ConsensusGroupId groupId;
    private final TEndPoint endpoint;
    private final int nodeId;

    public Peer(ConsensusGroupId groupId, int nodeId, TEndPoint endpoint) {
        this.groupId = groupId;
        this.nodeId = nodeId;
        this.endpoint = endpoint;
    }

    public ConsensusGroupId getGroupId() {
        return this.groupId;
    }

    public TEndPoint getEndpoint() {
        return this.endpoint;
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public void serialize(DataOutputStream stream) {
        try {
            ThriftCommonsSerDeUtils.serializeTConsensusGroupId((TConsensusGroupId)this.groupId.convertToTConsensusGroupId(), (DataOutputStream)stream);
            BasicStructureSerDeUtil.write((int)this.nodeId, (DataOutputStream)stream);
            ThriftCommonsSerDeUtils.serializeTEndPoint((TEndPoint)this.endpoint, (DataOutputStream)stream);
        }
        catch (IOException e) {
            this.LOGGER.error("Failed to serialize Peer", (Throwable)e);
        }
    }

    public static Peer deserialize(ByteBuffer buffer) {
        return new Peer(ConsensusGroupId.Factory.createFromTConsensusGroupId((TConsensusGroupId)ThriftCommonsSerDeUtils.deserializeTConsensusGroupId((ByteBuffer)buffer)), BasicStructureSerDeUtil.readInt((ByteBuffer)buffer), ThriftCommonsSerDeUtils.deserializeTEndPoint((ByteBuffer)buffer));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Peer peer = (Peer)o;
        return this.nodeId == peer.nodeId && Objects.equals(this.groupId, peer.groupId) && Objects.equals(this.endpoint, peer.endpoint);
    }

    public int hashCode() {
        return Objects.hash(this.groupId, this.endpoint, this.nodeId);
    }

    public String toString() {
        return "Peer{groupId=" + this.groupId + ", endpoint=" + this.endpoint + ", nodeId=" + this.nodeId + '}';
    }
}

