/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.client;

import java.io.IOException;
import org.apache.commons.pool2.KeyedObjectPool;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.IClientPoolFactory;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientManager<K, V>
implements IClientManager<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(ClientManager.class);
    private final KeyedObjectPool<K, V> pool;

    ClientManager(IClientPoolFactory<K, V> factory) {
        this.pool = factory.createClientPool(this);
    }

    public KeyedObjectPool<K, V> getPool() {
        return this.pool;
    }

    @Override
    public V borrowClient(K node) throws IOException {
        Object client;
        try {
            client = this.pool.borrowObject(node);
        }
        catch (TTransportException e) {
            throw new IOException(e);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            String errorMessage = String.format("Borrow client from pool for node %s failed, you need to increase dn_max_connection_for_internal_service.", node);
            logger.warn(errorMessage, (Throwable)e);
            throw new IOException(errorMessage, e);
        }
        return (V)client;
    }

    @Override
    public V purelyBorrowClient(K node) {
        Object client = null;
        try {
            client = this.pool.borrowObject(node);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (V)client;
    }

    public void returnClient(K node, V client) {
        if (client != null && node != null) {
            try {
                this.pool.returnObject(node, client);
            }
            catch (Exception e) {
                logger.error(String.format("Return client %s for node %s to pool failed.", client, node), (Throwable)e);
            }
        }
    }

    @Override
    public void clear(K node) {
        if (node != null) {
            try {
                this.pool.clear(node);
            }
            catch (Exception e) {
                logger.error(String.format("Clear all client in pool for node %s failed.", node), (Throwable)e);
            }
        }
    }

    @Override
    public void close() {
        try {
            this.pool.close();
        }
        catch (Exception e) {
            logger.error("close client pool failed", (Throwable)e);
        }
    }
}

