/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.partition.heartbeat;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.iotdb.commons.cluster.RegionStatus;
import org.apache.iotdb.confignode.manager.partition.heartbeat.RegionHeartbeatSample;
import org.apache.iotdb.confignode.manager.partition.heartbeat.RegionStatistics;

public class RegionCache {
    private final List<RegionHeartbeatSample> slidingWindow = Collections.synchronizedList(new LinkedList());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheHeartbeatSample(RegionHeartbeatSample newHeartbeatSample) {
        List<RegionHeartbeatSample> list = this.slidingWindow;
        synchronized (list) {
            if (this.slidingWindow.size() == 0 || this.getLastSample().getSendTimestamp() < newHeartbeatSample.getSendTimestamp()) {
                this.slidingWindow.add(newHeartbeatSample);
            }
            if (this.slidingWindow.size() > 100) {
                this.slidingWindow.remove(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegionStatistics getRegionStatistics() {
        RegionHeartbeatSample lastSample;
        List<RegionHeartbeatSample> list = this.slidingWindow;
        synchronized (list) {
            lastSample = this.getLastSample();
        }
        RegionStatus status = System.currentTimeMillis() - lastSample.getSendTimestamp() > 20000L ? RegionStatus.Unknown : lastSample.getStatus();
        return new RegionStatistics(status);
    }

    private RegionHeartbeatSample getLastSample() {
        return this.slidingWindow.get(this.slidingWindow.size() - 1);
    }
}

