/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.common.rpc.thrift.TConfigNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TDataNodeConfiguration;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.commons.utils.NodeUrlUtils;
import org.apache.iotdb.confignode.manager.IManager;
import org.apache.iotdb.confignode.manager.load.LoadManager;
import org.apache.iotdb.confignode.manager.node.NodeManager;
import org.apache.iotdb.confignode.manager.partition.PartitionManager;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class LoadManagerMetrics
implements IMetricSet {
    private final IManager configManager;

    public LoadManagerMetrics(IManager configManager) {
        this.configManager = configManager;
    }

    public void bindTo(AbstractMetricService metricService) {
        metricService.createAutoGauge(Metric.CONFIG_NODE.toString(), MetricLevel.CORE, (Object)this, o -> this.getRegisterConfigNodesNum(metricService), new String[]{Tag.NAME.toString(), "total", Tag.STATUS.toString(), "Registered"});
        metricService.createAutoGauge(Metric.DATA_NODE.toString(), MetricLevel.CORE, (Object)this, o -> this.getRegisterDataNodesNum(metricService), new String[]{Tag.NAME.toString(), "total", Tag.STATUS.toString(), "Registered"});
        metricService.createAutoGauge(Metric.CONFIG_NODE.toString(), MetricLevel.CORE, (Object)this, o -> this.getRunningConfigNodesNum(metricService), new String[]{Tag.NAME.toString(), "total", Tag.STATUS.toString(), "Online"});
        metricService.createAutoGauge(Metric.DATA_NODE.toString(), MetricLevel.CORE, (Object)this, o -> this.getRunningDataNodesNum(metricService), new String[]{Tag.NAME.toString(), "total", Tag.STATUS.toString(), "Online"});
        metricService.createAutoGauge(Metric.CONFIG_NODE.toString(), MetricLevel.CORE, (Object)this, o -> this.getUnknownConfigNodesNum(metricService), new String[]{Tag.NAME.toString(), "total", Tag.STATUS.toString(), "Unknown"});
        metricService.createAutoGauge(Metric.DATA_NODE.toString(), MetricLevel.CORE, (Object)this, o -> this.getUnknownDataNodesNum(metricService), new String[]{Tag.NAME.toString(), "total", Tag.STATUS.toString(), "Unknown"});
    }

    public void unbindFrom(AbstractMetricService metricService) {
        metricService.remove(MetricType.AUTO_GAUGE, Metric.CONFIG_NODE.toString(), new String[]{Tag.NAME.toString(), "total", Tag.STATUS.toString(), "Registered"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.DATA_NODE.toString(), new String[]{Tag.NAME.toString(), "total", Tag.STATUS.toString(), "Registered"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.CONFIG_NODE.toString(), new String[]{Tag.NAME.toString(), "total", Tag.STATUS.toString(), "Online"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.DATA_NODE.toString(), new String[]{Tag.NAME.toString(), "total", Tag.STATUS.toString(), "Online"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.CONFIG_NODE.toString(), new String[]{Tag.NAME.toString(), "total", Tag.STATUS.toString(), "Unknown"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.DATA_NODE.toString(), new String[]{Tag.NAME.toString(), "total", Tag.STATUS.toString(), "Unknown"});
        this.getNodeManager().getRegisteredDataNodes().forEach(dataNodeInfo -> {
            TDataNodeLocation dataNodeLocation = dataNodeInfo.getLocation();
            String name = NodeUrlUtils.convertTEndPointUrl((TEndPoint)dataNodeLocation.getClientRpcEndPoint());
            metricService.remove(MetricType.GAUGE, Metric.CLUSTER_NODE_LEADER_COUNT.toString(), new String[]{Tag.NAME.toString(), name});
        });
    }

    private NodeManager getNodeManager() {
        return this.configManager.getNodeManager();
    }

    private PartitionManager getPartitionManager() {
        return this.configManager.getPartitionManager();
    }

    private LoadManager getLoadManager() {
        return this.configManager.getLoadManager();
    }

    private int getRegisterConfigNodesNum(AbstractMetricService metricService) {
        return this.getNodeManager().getRegisteredConfigNodes().size();
    }

    private int getRegisterDataNodesNum(AbstractMetricService metricService) {
        List<TDataNodeConfiguration> dataNodeConfigurations = this.getNodeManager().getRegisteredDataNodes();
        ConcurrentHashMap idToCountMap = new ConcurrentHashMap();
        this.getLoadManager().getLatestRegionLeaderMap().forEach((consensusGroupId, nodeId) -> idToCountMap.merge(nodeId, 1, Integer::sum));
        for (TDataNodeConfiguration dataNodeInfo : dataNodeConfigurations) {
            TDataNodeLocation dataNodeLocation = dataNodeInfo.getLocation();
            int dataNodeId = dataNodeLocation.getDataNodeId();
            String name = NodeUrlUtils.convertTEndPointUrl((TEndPoint)dataNodeLocation.getClientRpcEndPoint());
            metricService.getOrCreateGauge(Metric.CLUSTER_NODE_LEADER_COUNT.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), name}).set((long)idToCountMap.getOrDefault(dataNodeId, 0).intValue());
        }
        return dataNodeConfigurations.size();
    }

    private int getRunningConfigNodesNum(AbstractMetricService metricService) {
        List<TConfigNodeLocation> runningConfigNodes = this.getNodeManager().filterConfigNodeThroughStatus(NodeStatus.Running);
        if (runningConfigNodes == null) {
            return 0;
        }
        for (TConfigNodeLocation configNodeLocation : runningConfigNodes) {
            String name = NodeUrlUtils.convertTEndPointUrl((TEndPoint)configNodeLocation.getInternalEndPoint());
            metricService.getOrCreateGauge(Metric.CLUSTER_NODE_STATUS.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), name, Tag.TYPE.toString(), "ConfigNode"}).set(1L);
        }
        return runningConfigNodes.size();
    }

    private int getRunningDataNodesNum(AbstractMetricService metricService) {
        List<TDataNodeConfiguration> runningDataNodes = this.getNodeManager().filterDataNodeThroughStatus(NodeStatus.Running);
        if (runningDataNodes == null) {
            return 0;
        }
        for (TDataNodeConfiguration dataNodeInfo : runningDataNodes) {
            TDataNodeLocation dataNodeLocation = dataNodeInfo.getLocation();
            String name = NodeUrlUtils.convertTEndPointUrl((TEndPoint)dataNodeLocation.getClientRpcEndPoint());
            metricService.getOrCreateGauge(Metric.CLUSTER_NODE_STATUS.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), name, Tag.TYPE.toString(), "DataNode"}).set(1L);
        }
        return runningDataNodes.size();
    }

    private int getUnknownConfigNodesNum(AbstractMetricService metricService) {
        List<TConfigNodeLocation> unknownConfigNodes = this.getNodeManager().filterConfigNodeThroughStatus(NodeStatus.Unknown);
        if (unknownConfigNodes == null) {
            return 0;
        }
        for (TConfigNodeLocation configNodeLocation : unknownConfigNodes) {
            String name = NodeUrlUtils.convertTEndPointUrl((TEndPoint)configNodeLocation.getInternalEndPoint());
            metricService.getOrCreateGauge(Metric.CLUSTER_NODE_STATUS.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), name, Tag.TYPE.toString(), "ConfigNode"}).set(0L);
        }
        return unknownConfigNodes.size();
    }

    private int getUnknownDataNodesNum(AbstractMetricService metricService) {
        List<TDataNodeConfiguration> unknownDataNodes = this.getNodeManager().filterDataNodeThroughStatus(NodeStatus.Unknown);
        if (unknownDataNodes == null) {
            return 0;
        }
        for (TDataNodeConfiguration dataNodeInfo : unknownDataNodes) {
            TDataNodeLocation dataNodeLocation = dataNodeInfo.getLocation();
            String name = NodeUrlUtils.convertTEndPointUrl((TEndPoint)dataNodeLocation.getClientRpcEndPoint());
            metricService.getOrCreateGauge(Metric.CLUSTER_NODE_STATUS.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), name, Tag.TYPE.toString(), "DataNode"}).set(0L);
        }
        return unknownDataNodes.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LoadManagerMetrics that = (LoadManagerMetrics)o;
        return Objects.equals(this.configManager, that.configManager);
    }

    public int hashCode() {
        return Objects.hash(this.configManager);
    }
}

