/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request;

import java.util.HashMap;
import java.util.Map;

public enum ConfigPhysicalPlanType {
    ApplyConfigNode(0),
    RemoveConfigNode(1),
    RegisterDataNode(100),
    GetDataNodeConfiguration(101),
    RemoveDataNode(102),
    UpdateDataNodeConfiguration(103),
    SetStorageGroup(200),
    SetTTL(201),
    SetSchemaReplicationFactor(202),
    SetDataReplicationFactor(203),
    SetTimePartitionInterval(204),
    AdjustMaxRegionGroupNum(205),
    DeleteStorageGroup(206),
    PreDeleteStorageGroup(207),
    GetStorageGroup(208),
    CountStorageGroup(209),
    CreateRegionGroups(300),
    DeleteRegionGroups(301),
    GetRegionInfoList(302),
    UpdateRegionLocation(303),
    OfferRegionMaintainTasks(304),
    PollRegionMaintainTask(305),
    GetRegionId(306),
    GetSeriesSlotList(307),
    GetTimeSlotList(308),
    GetSchemaPartition(400),
    CreateSchemaPartition(401),
    GetOrCreateSchemaPartition(402),
    GetDataPartition(403),
    CreateDataPartition(404),
    GetOrCreateDataPartition(405),
    GetNodePathsPartition(406),
    UpdateProcedure(500),
    DeleteProcedure(501),
    Author(600),
    CreateUser(601),
    CreateRole(602),
    DropUser(603),
    DropRole(604),
    GrantRole(605),
    GrantUser(606),
    GrantRoleToUser(607),
    RevokeUser(608),
    RevokeRole(609),
    RevokeRoleFromUser(610),
    UpdateUser(611),
    ListUser(612),
    ListRole(613),
    ListUserPrivilege(614),
    ListRolePrivilege(615),
    ListUserRoles(616),
    ListRoleUsers(617),
    CreateFunction(700),
    DropFunction(701),
    GetFunctionTable(702),
    GetFunctionJar(703),
    CreateSchemaTemplate(800),
    GetAllSchemaTemplate(801),
    GetSchemaTemplate(802),
    CheckTemplateSettable(803),
    SetSchemaTemplate(804),
    GetPathsSetTemplate(805),
    GetAllTemplateSetInfo(806),
    GetTemplateSetInfo(807),
    PreUnsetTemplate(808),
    RollbackUnsetTemplate(809),
    UnsetTemplate(810),
    DropSchemaTemplate(811),
    CreatePipeSink(900),
    DropPipeSink(901),
    GetPipeSink(902),
    PreCreatePipe(903),
    SetPipeStatus(904),
    DropPipe(905),
    ShowPipe(906),
    RecordPipeMessage(907),
    AddTriggerInTable(1000),
    DeleteTriggerInTable(1001),
    GetTriggerTable(1002),
    UpdateTriggerStateInTable(1003),
    GetTriggerJar(1004),
    UpdateTriggersOnTransferNodes(1005),
    UpdateTriggerLocation(1006),
    GetTransferringTriggers(1007),
    GetTriggerLocation(1008),
    DROP_CQ(1100),
    ACTIVE_CQ(1101),
    ADD_CQ(1102),
    UPDATE_CQ_LAST_EXEC_TIME(1103),
    SHOW_CQ(1104);

    private final short planType;
    private static final Map<Short, ConfigPhysicalPlanType> PLAN_TYPE_MAP;

    private ConfigPhysicalPlanType(short planType) {
        this.planType = planType;
    }

    public short getPlanType() {
        return this.planType;
    }

    public static ConfigPhysicalPlanType convertToConfigPhysicalPlanType(short planType) {
        return PLAN_TYPE_MAP.getOrDefault(planType, null);
    }

    static {
        PLAN_TYPE_MAP = new HashMap<Short, ConfigPhysicalPlanType>();
        for (ConfigPhysicalPlanType planType : ConfigPhysicalPlanType.values()) {
            PLAN_TYPE_MAP.put(planType.getPlanType(), planType);
        }
    }
}

