<!--

    Licensed to the Apache Software Foundation (ASF) under one
    or more contributor license agreements.  See the NOTICE file
    distributed with this work for additional information
    regarding copyright ownership.  The ASF licenses this file
    to you under the Apache License, Version 2.0 (the
    "License"); you may not use this file except in compliance
    with the License.  You may obtain a copy of the License at
    
        http://www.apache.org/licenses/LICENSE-2.0
    
    Unless required by applicable law or agreed to in writing,
    software distributed under the License is distributed on an
    "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
    KIND, either express or implied.  See the License for the
    specific language governing permissions and limitations
    under the License.

-->

# Release version

<table>
	<tr>
      <th>Version</th>
	    <th colspan="3">IoTDB Binaries</th>
	    <th colspan="3">IoTDB Sources</th>
	    <th>release notes</th>  
	</tr>
	<tr>
            <td rowspan="1">0.14.0-preview2</td>
            <td><a href="https://www.apache.org/dyn/closer.cgi/iotdb/0.14.0-preview2/apache-iotdb-0.14.0-preview2-all-bin.zip">Cluster</a></td>
            <td><a href="https://downloads.apache.org/iotdb/0.14.0-preview2/apache-iotdb-0.14.0-preview2-all-bin.zip.sha512">SHA512</a></td>
            <td><a href="https://downloads.apache.org/iotdb/0.14.0-preview2/apache-iotdb-0.14.0-preview2-all-bin.zip.asc">ASC</a></td>
            <td rowspan="1"><a href="https://www.apache.org/dyn/closer.cgi/iotdb/0.14.0-preview2/apache-iotdb-0.14.0-preview2-source-release.zip">Sources</a></td>
            <td rowspan="1"><a href="https://downloads.apache.org/iotdb/0.14.0-preview2/apache-iotdb-0.14.0-preview2-source-release.zip.sha512">SHA512</a></td>
            <td rowspan="1"><a href="https://downloads.apache.org/iotdb/0.14.0-preview2/apache-iotdb-0.14.0-preview2-source-release.zip.asc">ASC</a></td>
            <td rowspan="1"><a href="https://raw.githubusercontent.com/apache/iotdb/master/RELEASE_NOTES.md">release notes</a></td>
      </tr>
      <tr>
            <td rowspan="3">0.13.2</td>
            <td><a href="https://www.apache.org/dyn/closer.cgi/iotdb/0.13.2/apache-iotdb-0.13.2-all-bin.zip">All-in-one</a></td>
            <td><a href="https://downloads.apache.org/iotdb/0.13.2/apache-iotdb-0.13.2-all-bin.zip.sha512">SHA512</a></td>
            <td><a href="https://downloads.apache.org/iotdb/0.13.2/apache-iotdb-0.13.2-all-bin.zip.asc">ASC</a></td>
            <td rowspan="3"><a href="https://www.apache.org/dyn/closer.cgi/iotdb/0.13.2/apache-iotdb-0.13.2-source-release.zip">Sources</a></td>
            <td rowspan="3"><a href="https://downloads.apache.org/iotdb/0.13.2/apache-iotdb-0.13.2-source-release.zip.sha512">SHA512</a></td>
            <td rowspan="3"><a href="https://downloads.apache.org/iotdb/0.13.2/apache-iotdb-0.13.2-source-release.zip.asc">ASC</a></td>
            <td rowspan="3"><a href="https://raw.githubusercontent.com/apache/iotdb/v0.13.2/RELEASE_NOTES.md">release notes</a></td>
      </tr>
      <tr>
            <td><a href="https://www.apache.org/dyn/closer.cgi/iotdb/0.13.2/apache-iotdb-0.13.2-grafana-plugin-bin.zip">Grafana-plugin</a></td>
            <td><a href="https://downloads.apache.org/iotdb/0.13.2/apache-iotdb-0.13.2-grafana-plugin-bin.zip.sha512">SHA512</a></td>
            <td><a href="https://downloads.apache.org/iotdb/0.13.2/apache-iotdb-0.13.2-grafana-plugin-bin.zip.asc">ASC</a></td>
      </tr>
      <tr>
            <td><a href="https://www.apache.org/dyn/closer.cgi/iotdb/0.13.2/apache-iotdb-0.13.2-grafana-connector-bin.zip">Grafana-connector</a></td>
            <td><a href="https://downloads.apache.org/iotdb/0.13.2/apache-iotdb-0.13.2-grafana-connector-bin.zip.sha512">SHA512</a></td>
            <td><a href="https://downloads.apache.org/iotdb/0.13.2/apache-iotdb-0.13.2-grafana-connector-bin.zip.asc">ASC</a></td>
      </tr>
      <tr>
            <td rowspan="4">0.12.6</td>
            <td><a href="https://www.apache.org/dyn/closer.cgi/iotdb/0.12.6/apache-iotdb-0.12.6-all-bin.zip">All-in-one</a></td>
            <td><a href="https://downloads.apache.org/iotdb/0.12.6/apache-iotdb-0.12.6-all-bin.zip.sha512">SHA512</a></td>
            <td><a href="https://downloads.apache.org/iotdb/0.12.6/apache-iotdb-0.12.6-all-bin.zip.asc">ASC</a></td>
            <td rowspan="4"><a href="https://www.apache.org/dyn/closer.cgi/iotdb/0.12.6/apache-iotdb-0.12.6-source-release.zip">Sources</a></td>
            <td rowspan="4"><a href="https://downloads.apache.org/iotdb/0.12.6/apache-iotdb-0.12.6-source-release.zip.sha512">SHA512</a></td>
            <td rowspan="4"><a href="https://downloads.apache.org/iotdb/0.12.6/apache-iotdb-0.12.6-source-release.zip.asc">ASC</a></td>
            <td rowspan="4"><a href="https://raw.githubusercontent.com/apache/iotdb/v0.12.6/RELEASE_NOTES.md">release notes</a></td>
      </tr>
      <tr>
            <td><a href="https://www.apache.org/dyn/closer.cgi/iotdb/0.12.6/apache-iotdb-0.12.6-server-bin.zip">Server</a></td>
            <td><a href="https://downloads.apache.org/iotdb/0.12.6/apache-iotdb-0.12.6-server-bin.zip.sha512">SHA512</a></td>
            <td><a href="https://downloads.apache.org/iotdb/0.12.6/apache-iotdb-0.12.6-server-bin.zip.asc">ASC</a></td>
      </tr>
      <tr>
            <td><a href="https://www.apache.org/dyn/closer.cgi/iotdb/0.12.6/apache-iotdb-0.12.6-cluster-bin.zip">Cluster</a></td>
            <td><a href="https://downloads.apache.org/iotdb/0.12.6/apache-iotdb-0.12.6-cluster-bin.zip.sha512">SHA512</a></td>
            <td><a href="https://downloads.apache.org/iotdb/0.12.6/apache-iotdb-0.12.6-cluster-bin.zip.asc">ASC</a></td>
      </tr>
      <tr>
            <td><a href="https://www.apache.org/dyn/closer.cgi/iotdb/0.12.6/apache-iotdb-0.12.6-grafana-bin.zip">Grafana-connector</a></td>
            <td><a href="https://downloads.apache.org/iotdb/0.12.6/apache-iotdb-0.12.6-grafana-bin.zip.sha512">SHA512</a></td>
            <td><a href="https://downloads.apache.org/iotdb/0.12.6/apache-iotdb-0.12.6-grafana-bin.zip.asc">ASC</a></td>
      </tr>
</table>

Legacy version are available here: [https://archive.apache.org/dist/iotdb/](https://archive.apache.org/dist/iotdb/)


## Configurations

- Recommended OS parameters
  * Set the somaxconn as 65535 to avoid "connection reset" error when the system is under high load.
    ```
    # Linux
    > sudo sysctl -w net.core.somaxconn=65535
     
    # FreeBSD or Darwin
    > sudo sysctl -w kern.ipc.somaxconn=65535
    ```

## About 0.14.0-preview1

- 0.14.0-preview1 is a preview release for the new IoTDB cluster, which you could download and have a try.
  We DO NOT recommend using preview release on-line, and DO NOT upgrade 0.13 to a preview release.
  - The UserGuide of 0.14.0-preview is still in the **latest**.

**<font color=red>NOTE: Do not use the stop-confignode.bat/sh script, which has a bug that may kill other process</font>**:
 

- **After we release 0.14.0, how to upgrade from v.13.x to v0.14.x?**
  
  - **Version 0.14 has changed the SQL syntax conventions (please refer to the syntax conventions section of the user manual), the incompatibilities are as follows:**
    - **Identifiers that are not quoted with backquotes are not allowed to be pure numbers and only allowed to contain letters, Chinese characters, and underscores. If the above occurs in an identifier, use backquotes to enclose the identifier.**
    - **Identifiers no longer support quoting with single and double quotes, please use backquotes instead.**
    - **When using the path node name in the Session API, it needs to be consistent with that in the SQL statement. If the path node is a pure number 111, it needs to be enclosed in backquotes in the SQL statement and written as \`111\`, then when using the Session API, the corresponding parameter also needs to be written as \`111\`.**
  - In order to ensure the stability of UDF-related APIs, in version 0.14, UDF-related APIs are seperated into an independent module and no longer depend on the tsfile package. The implemented UDFs need to rewrite the code, replace `TsDataType` with `Type`, and replace `org .apache.iotdb.tsfile.utils.Binary` with `org.apache.iotdb.udf.api.type.Binary`, then redo the packaging and loading process.

## How to Upgrade

- How to upgrade a minor version (e.g., from v0.12.3 to v0.12.5)?
  * versions which have the same major version are compatible.
  * Just download and unzip the new version. Then modify the configuration files to keep consistent
    with what you set in the old version.
  * stop the old version instance, and start the new one.

- How to upgrade from v.12.x to v0.13.x?

  * The data format (i.e., TsFile data) of v0.12.x and v0.13.x are compatible, but the WAL file is
    incompatible. So, you can follow the steps:
  * **<font color=red> Execute `SET STSTEM TO READONLY` command in CLI. </font>**
  * **<font color=red> Stop writing new data.</font>**
  * Execute `flush` command to close all TsFiles.
  * We recommend to back up all data files before upgrading for rolling back.
  * Just download, unzip v0.13.x.zip, and modify conf/iotdb-engine.properties, **<font color=red> especially the unchangeable configurations like timestamp precision</font>**. Let all the
    directories point to the data folder set in v0.12.x (or the backup folder). You can also modify
    other settings if you want.
  * Stop IoTDB v0.12.x instance, and then start v0.13.x.
  * **<font color=red>After the steps above, please make sure the `iotdb_version` in `data/system/schema/system.properties` file is `0.13.x`. 
    If not, please change it to `0.13.x` manually.</font>**
  * __NOTICE: V0.13 changes many settings in conf/iotdb-engine.properties, so do not use v0.12's
    configuration file directly.__
  * **In 0.13, the SQL syntax has been changed. The identifiers not enclosed in backquotes can only contain the following characters, otherwise they need to be enclosed in backquotes.**
    * **[0-9 a-z A-Z _ : @ # $ { }] (letters, digits, some special characters)**
    * **['\u2E80'..'\u9FFF'] (UNICODE Chinese characters)**
  * **In 0.13, if the path node name in the `SELECT` clause consists of pure numbers, it needs to be enclosed in backquotes to distinguish it from the constant in the expression. For example, in the statement "select 123 + \`123\` from root.sg", the former 123 represents a constant, and the latter \`123\` will be spliced with root.sg, indicating the path root.sg.\`123\`.**

- How to upgrade from v.11.x or v0.10.x to v0.12.x?
  * Upgrading from v0.11 or v0.10 to v0.12 is similar as v0.9 to v0.10. The upgrade tool will rewrite the data files automatically.
  * **<font color=red>Stop writing new data.</font>**
  * Call `flush` command using sbin/start-cli.sh in original version to close all TsFiles.
  * We recommend to backup the data file (also the wal files and mlog.txt) before upgrading for rolling back.
  * Just download, unzip v0.12.x.zip, and modify conf/iotdb-engine.proeprties to let all the 
  directories point to the folders set in previous version (or the backup folder). 
  You can also modify other settings if you want. Any other config changes in v0.11 should be moved to v0.12. 
  * Stop IoTDB v0.11 or v0.10 instance, and start v0.12.x, then the IoTDB will upgrade data file format automatically. It is ok to read and write data when the upgrading process works.
  * After a log `All files upgraded successfully!` printed, the upgrading completes.
  * __NOTICE 1: V0.12 changes many settings in conf/iotdb-engine.properties, so do not use previous 
    configuration file directly.__
  * __NOTICE 2: V0.12 doesn't support upgrade from v0.9 or lower version, please upgrade to v0.10 first if needed.__
  * __NOTICE 3: We don't recommend deleting data before the upgrading finished. The deletion will fail if you try to delete data in the storage group with upgrading files.__

- How to upgrade from v.10.x to v0.11.x?
  * The data format (i.e., TsFile data) of v0.10.x and v0.11 are compatible, but the WAL file is 
  incompatible. So, you can follow the steps:
  * **<font color=red>Stop writing new data.</font>**
  * Call `flush` command using `sbin/start-cli.sh` in v0.10.x to close all TsFiles.
  * We recommend to backup the wal files and mlog.txt before upgrading for rolling back.
  * Just download, unzip v0.11.x.zip, and modify conf/iotdb-engine.properties to let all the 
    directories point to the data folder set in v0.10.x (or the backup folder). You can also modify 
    other settings if you want.
  * Stop IoTDB v0.10.x instance, and start v0.11.x, then the IoTDB will upgrade data file format 
    automatically.
  * __NOTICE: V0.11 changes many settings in conf/iotdb-engine.properties, so do not use v0.10's 
    configuration file directly.__

- How to upgrade from v0.9.x to v0.10.x?
  * Upgrading from v0.9 to v0.10 is more complex than v0.8 to v0.9.
  * **<font color=red>Stop writing new data.</font>**
  * Call `flush` command using sbin/start-client.sh in v0.9 to close all TsFiles.
  * We recommend to backup the data file (also the wal files and mlog.txt) before upgrading for rolling back.
  * Just download, unzip v0.10.x.zip, and modify conf/iotdb-engine.proeprties to let all the 
  directories point to the folders set in v0.9.x  (or the backup folder). 
  You can also modify other settings if you want. 
  * Stop IoTDB v0.9 instance, and start v0.10.x, then the IoTDB will upgrade data file format automatically.

- How to upgrade from 0.8.x to v0.9.x?
  * We recommend to backup the data file (also the wal files and mlog.txt) before upgrading for rolling back.
  * Just download, unzip v0.9.x.zip, and modify conf/iotdb-engine.properties to let all the 
  directories point to the folders set in v0.8.x (or the backup folder). 
  You can also modify other settings if you want. 
  * Stop IoTDB v0.8 instance, and start v0.9.x, then the IoTDB will upgrade data file format automatically.



​       

# All releases

Find all releases in the [Archive repository](https://archive.apache.org/dist/iotdb/).



# Verifying Hashes and Signatures

Along with our releases, we also provide sha512 hashes in *.sha512 files and cryptographic signatures in *.asc files. The Apache Software Foundation has an extensive tutorial to [verify hashes and signatures ](http://www.apache.org/info/verification.html)which you can follow by using any of these release-signing [KEYS ](https://downloads.apache.org/iotdb/KEYS).
