/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.udf.builtin;

import java.util.Comparator;
import java.util.PriorityQueue;
import org.apache.iotdb.commons.udf.builtin.UDTFSelectK;
import org.apache.iotdb.commons.udf.utils.UDFDataTypeTransformer;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.udf.api.exception.UDFInputSeriesDataTypeNotValidException;
import org.apache.iotdb.udf.api.type.Type;

public class UDTFTopK
extends UDTFSelectK {
    @Override
    protected void constructPQ() throws UDFInputSeriesDataTypeNotValidException {
        switch (this.dataType) {
            case INT32: {
                this.intPQ = new PriorityQueue<Pair>(this.k, Comparator.comparing(o -> (Integer)o.right));
                break;
            }
            case INT64: {
                this.longPQ = new PriorityQueue<Pair>(this.k, Comparator.comparing(o -> (Long)o.right));
                break;
            }
            case FLOAT: {
                this.floatPQ = new PriorityQueue<Pair>(this.k, Comparator.comparing(o -> (Float)o.right));
                break;
            }
            case DOUBLE: {
                this.doublePQ = new PriorityQueue<Pair>(this.k, Comparator.comparing(o -> (Double)o.right));
                break;
            }
            case TEXT: {
                this.stringPQ = new PriorityQueue<Pair>(this.k, Comparator.comparing(o -> (String)o.right));
                break;
            }
            default: {
                throw new UDFInputSeriesDataTypeNotValidException(0, UDFDataTypeTransformer.transformToUDFDataType(this.dataType), new Type[]{Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE, Type.TEXT});
            }
        }
    }

    @Override
    protected void transformInt(long time, int value) {
        if (this.intPQ.size() < this.k) {
            this.intPQ.add(new Pair((Object)time, (Object)value));
        } else if ((Integer)((Pair)this.intPQ.peek()).right < value) {
            this.intPQ.poll();
            this.intPQ.add(new Pair((Object)time, (Object)value));
        }
    }

    @Override
    protected void transformLong(long time, long value) {
        if (this.longPQ.size() < this.k) {
            this.longPQ.add(new Pair((Object)time, (Object)value));
        } else if ((Long)((Pair)this.longPQ.peek()).right < value) {
            this.longPQ.poll();
            this.longPQ.add(new Pair((Object)time, (Object)value));
        }
    }

    @Override
    protected void transformFloat(long time, float value) {
        if (this.floatPQ.size() < this.k) {
            this.floatPQ.add(new Pair((Object)time, (Object)Float.valueOf(value)));
        } else if (((Float)((Pair)this.floatPQ.peek()).right).floatValue() < value) {
            this.floatPQ.poll();
            this.floatPQ.add(new Pair((Object)time, (Object)Float.valueOf(value)));
        }
    }

    @Override
    protected void transformDouble(long time, double value) {
        if (this.doublePQ.size() < this.k) {
            this.doublePQ.add(new Pair((Object)time, (Object)value));
        } else if ((Double)((Pair)this.doublePQ.peek()).right < value) {
            this.doublePQ.poll();
            this.doublePQ.add(new Pair((Object)time, (Object)value));
        }
    }

    @Override
    protected void transformString(long time, String value) {
        if (this.stringPQ.size() < this.k) {
            this.stringPQ.add(new Pair((Object)time, (Object)value));
        } else if (((String)((Pair)this.stringPQ.peek()).right).compareTo(value) < 0) {
            this.stringPQ.poll();
            this.stringPQ.add(new Pair((Object)time, (Object)value));
        }
    }
}

