/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.partition;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TSeriesPartitionSlot;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.utils.ThriftCommonsSerDeUtils;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocol;

public class SeriesPartitionTable {
    private final Map<TTimePartitionSlot, List<TConsensusGroupId>> seriesPartitionMap;

    public SeriesPartitionTable() {
        this.seriesPartitionMap = new ConcurrentHashMap<TTimePartitionSlot, List<TConsensusGroupId>>();
    }

    public SeriesPartitionTable(Map<TTimePartitionSlot, List<TConsensusGroupId>> seriesPartitionMap) {
        this.seriesPartitionMap = seriesPartitionMap;
    }

    public Map<TTimePartitionSlot, List<TConsensusGroupId>> getSeriesPartitionMap() {
        return this.seriesPartitionMap;
    }

    public boolean getDataPartition(List<TTimePartitionSlot> partitionSlots, SeriesPartitionTable seriesPartitionTable) {
        AtomicBoolean result = new AtomicBoolean(true);
        if (partitionSlots.isEmpty()) {
            seriesPartitionTable.getSeriesPartitionMap().putAll(this.seriesPartitionMap);
        } else {
            partitionSlots.forEach(timePartitionSlot -> {
                if (this.seriesPartitionMap.containsKey(timePartitionSlot)) {
                    seriesPartitionTable.getSeriesPartitionMap().put((TTimePartitionSlot)timePartitionSlot, this.seriesPartitionMap.get(timePartitionSlot));
                } else {
                    result.set(false);
                }
            });
        }
        return result.get();
    }

    public TConsensusGroupId getPrecededDataPartition(TTimePartitionSlot timePartitionSlot, long timePartitionInterval) {
        if (timePartitionSlot.getStartTime() < timePartitionInterval) {
            return null;
        }
        TTimePartitionSlot predecessorSlot = new TTimePartitionSlot(timePartitionSlot.getStartTime() - timePartitionInterval);
        return this.seriesPartitionMap.getOrDefault(predecessorSlot, Collections.singletonList(null)).get(0);
    }

    List<TConsensusGroupId> getRouting(TTimePartitionSlot timeSlotId) {
        if (timeSlotId.getStartTime() >= 0L) {
            if (!this.seriesPartitionMap.containsKey(timeSlotId)) {
                return new ArrayList<TConsensusGroupId>();
            }
            return this.seriesPartitionMap.get(timeSlotId);
        }
        HashSet result = new HashSet();
        this.seriesPartitionMap.values().forEach(result::addAll);
        return new ArrayList<TConsensusGroupId>(result);
    }

    List<TTimePartitionSlot> getTimeSlotList(long startTime, long endTime) {
        return this.seriesPartitionMap.keySet().stream().filter(e -> e.getStartTime() >= startTime && e.getStartTime() < endTime).collect(Collectors.toList());
    }

    public void createDataPartition(SeriesPartitionTable assignedSeriesPartitionTable, TSeriesPartitionSlot seriesPartitionSlot, Map<TConsensusGroupId, Map<TSeriesPartitionSlot, AtomicLong>> groupDeltaMap) {
        assignedSeriesPartitionTable.getSeriesPartitionMap().forEach((timePartitionSlot, consensusGroupIds) -> {
            this.seriesPartitionMap.put((TTimePartitionSlot)timePartitionSlot, new Vector(consensusGroupIds));
            consensusGroupIds.forEach(consensusGroupId -> groupDeltaMap.computeIfAbsent((TConsensusGroupId)consensusGroupId, empty -> new ConcurrentHashMap()).computeIfAbsent(seriesPartitionSlot, empty -> new AtomicLong(0L)).getAndIncrement());
        });
    }

    public synchronized List<TTimePartitionSlot> filterUnassignedDataPartitionSlots(List<TTimePartitionSlot> partitionSlots) {
        Vector<TTimePartitionSlot> result = new Vector<TTimePartitionSlot>();
        partitionSlots.forEach(timePartitionSlot -> {
            if (!this.seriesPartitionMap.containsKey(timePartitionSlot)) {
                result.add((TTimePartitionSlot)timePartitionSlot);
            }
        });
        return result;
    }

    public void serialize(OutputStream outputStream, TProtocol protocol) throws IOException, TException {
        ReadWriteIOUtils.write((int)this.seriesPartitionMap.size(), (OutputStream)outputStream);
        for (Map.Entry<TTimePartitionSlot, List<TConsensusGroupId>> seriesPartitionEntry : this.seriesPartitionMap.entrySet()) {
            seriesPartitionEntry.getKey().write(protocol);
            ReadWriteIOUtils.write((int)seriesPartitionEntry.getValue().size(), (OutputStream)outputStream);
            for (TConsensusGroupId consensusGroupId : seriesPartitionEntry.getValue()) {
                consensusGroupId.write(protocol);
            }
        }
    }

    public void deserialize(ByteBuffer buffer) {
        int timePartitionSlotNum = buffer.getInt();
        for (int i = 0; i < timePartitionSlotNum; ++i) {
            TTimePartitionSlot timePartitionSlot = ThriftCommonsSerDeUtils.deserializeTTimePartitionSlot(buffer);
            int consensusGroupIdNum = buffer.getInt();
            Vector<TConsensusGroupId> consensusGroupIds = new Vector<TConsensusGroupId>();
            for (int j = 0; j < consensusGroupIdNum; ++j) {
                consensusGroupIds.add(ThriftCommonsSerDeUtils.deserializeTConsensusGroupId(buffer));
            }
            this.seriesPartitionMap.put(timePartitionSlot, consensusGroupIds);
        }
    }

    public void deserialize(InputStream inputStream, TProtocol protocol) throws IOException, TException {
        int timePartitionSlotNum = ReadWriteIOUtils.readInt((InputStream)inputStream);
        for (int i = 0; i < timePartitionSlotNum; ++i) {
            TTimePartitionSlot timePartitionSlot = new TTimePartitionSlot();
            timePartitionSlot.read(protocol);
            int consensusGroupIdNum = ReadWriteIOUtils.readInt((InputStream)inputStream);
            Vector<TConsensusGroupId> consensusGroupIds = new Vector<TConsensusGroupId>();
            for (int j = 0; j < consensusGroupIdNum; ++j) {
                TConsensusGroupId consensusGroupId = new TConsensusGroupId();
                consensusGroupId.read(protocol);
                consensusGroupIds.add(consensusGroupId);
            }
            this.seriesPartitionMap.put(timePartitionSlot, consensusGroupIds);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SeriesPartitionTable that = (SeriesPartitionTable)o;
        return this.seriesPartitionMap.equals(that.seriesPartitionMap);
    }

    public int hashCode() {
        return Objects.hash(this.seriesPartitionMap);
    }
}

