/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.conf;

import java.io.File;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.commons.enums.HandleSystemErrorStrategy;
import org.apache.iotdb.tsfile.fileSystem.FSType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonConfig {
    private static final Logger logger = LoggerFactory.getLogger(CommonConfig.class);
    private String openIdProviderUrl = "";
    private String authorizerProvider = "org.apache.iotdb.commons.auth.authorizer.LocalFileAuthorizer";
    private String encryptDecryptProvider = "org.apache.iotdb.commons.security.encrypt.MessageDigestEncrypt";
    private String encryptDecryptProviderParameter;
    private String adminName = "root";
    private String adminPassword = "root";
    private String userFolder = "data" + File.separator + "system" + File.separator + "users";
    private String roleFolder = "data" + File.separator + "system" + File.separator + "roles";
    private String procedureWalFolder = "data" + File.separator + "system" + File.separator + "procedure";
    private String syncFolder = "data" + File.separator + "sync";
    private String[] walDirs = new String[]{"data" + File.separator + "wal"};
    private FSType systemFileStorageFs = FSType.LOCAL;
    private long defaultTTL = Long.MAX_VALUE;
    private int connectionTimeoutInMS = (int)TimeUnit.SECONDS.toMillis(20L);
    private int selectorNumOfClientManager = Runtime.getRuntime().availableProcessors() / 4 > 0 ? Runtime.getRuntime().availableProcessors() / 4 : 1;
    private boolean isRpcThriftCompressionEnabled = false;
    private HandleSystemErrorStrategy handleSystemErrorStrategy = HandleSystemErrorStrategy.CHANGE_TO_READ_ONLY;
    private volatile NodeStatus status = NodeStatus.Running;
    private volatile String statusReason = null;
    private double diskSpaceWarningThreshold = 5.0;

    CommonConfig() {
    }

    public void updatePath(String homeDir) {
        this.userFolder = this.addHomeDir(this.userFolder, homeDir);
        this.roleFolder = this.addHomeDir(this.roleFolder, homeDir);
        this.procedureWalFolder = this.addHomeDir(this.procedureWalFolder, homeDir);
        this.syncFolder = this.addHomeDir(this.syncFolder, homeDir);
        for (int i = 0; i < this.walDirs.length; ++i) {
            this.walDirs[i] = this.addHomeDir(this.walDirs[i], homeDir);
        }
    }

    private String addHomeDir(String dir, String homeDir) {
        if (!new File(dir).isAbsolute() && homeDir != null && homeDir.length() > 0) {
            dir = !homeDir.endsWith(File.separator) ? homeDir + File.separatorChar + dir : homeDir + dir;
        }
        return dir;
    }

    public String getEncryptDecryptProvider() {
        return this.encryptDecryptProvider;
    }

    public void setEncryptDecryptProvider(String encryptDecryptProvider) {
        this.encryptDecryptProvider = encryptDecryptProvider;
    }

    public String getEncryptDecryptProviderParameter() {
        return this.encryptDecryptProviderParameter;
    }

    public void setEncryptDecryptProviderParameter(String encryptDecryptProviderParameter) {
        this.encryptDecryptProviderParameter = encryptDecryptProviderParameter;
    }

    public String getOpenIdProviderUrl() {
        return this.openIdProviderUrl;
    }

    public void setOpenIdProviderUrl(String openIdProviderUrl) {
        this.openIdProviderUrl = openIdProviderUrl;
    }

    public String getAuthorizerProvider() {
        return this.authorizerProvider;
    }

    public void setAuthorizerProvider(String authorizerProvider) {
        this.authorizerProvider = authorizerProvider;
    }

    public String getAdminName() {
        return this.adminName;
    }

    public void setAdminName(String adminName) {
        this.adminName = adminName;
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public void setAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
    }

    public String getUserFolder() {
        return this.userFolder;
    }

    public void setUserFolder(String userFolder) {
        this.userFolder = userFolder;
    }

    public String getRoleFolder() {
        return this.roleFolder;
    }

    public void setRoleFolder(String roleFolder) {
        this.roleFolder = roleFolder;
    }

    public String getProcedureWalFolder() {
        return this.procedureWalFolder;
    }

    public void setProcedureWalFolder(String procedureWalFolder) {
        this.procedureWalFolder = procedureWalFolder;
    }

    public String getSyncFolder() {
        return this.syncFolder;
    }

    public void setSyncFolder(String syncFolder) {
        this.syncFolder = syncFolder;
    }

    public String[] getWalDirs() {
        return this.walDirs;
    }

    public void setWalDirs(String[] walDirs) {
        this.walDirs = walDirs;
    }

    public FSType getSystemFileStorageFs() {
        return this.systemFileStorageFs;
    }

    public void setSystemFileStorageFs(FSType systemFileStorageFs) {
        this.systemFileStorageFs = systemFileStorageFs;
    }

    public long getDefaultTTL() {
        return this.defaultTTL;
    }

    public void setDefaultTTL(long defaultTTL) {
        this.defaultTTL = defaultTTL;
    }

    public int getConnectionTimeoutInMS() {
        return this.connectionTimeoutInMS;
    }

    public void setConnectionTimeoutInMS(int connectionTimeoutInMS) {
        this.connectionTimeoutInMS = connectionTimeoutInMS;
    }

    public int getSelectorNumOfClientManager() {
        return this.selectorNumOfClientManager;
    }

    public void setSelectorNumOfClientManager(int selectorNumOfClientManager) {
        this.selectorNumOfClientManager = selectorNumOfClientManager;
    }

    public boolean isRpcThriftCompressionEnabled() {
        return this.isRpcThriftCompressionEnabled;
    }

    public void setRpcThriftCompressionEnabled(boolean rpcThriftCompressionEnabled) {
        this.isRpcThriftCompressionEnabled = rpcThriftCompressionEnabled;
    }

    HandleSystemErrorStrategy getHandleSystemErrorStrategy() {
        return this.handleSystemErrorStrategy;
    }

    void setHandleSystemErrorStrategy(HandleSystemErrorStrategy handleSystemErrorStrategy) {
        this.handleSystemErrorStrategy = handleSystemErrorStrategy;
    }

    public void handleUnrecoverableError() {
        this.handleSystemErrorStrategy.handle();
    }

    public double getDiskSpaceWarningThreshold() {
        return this.diskSpaceWarningThreshold;
    }

    public void setDiskSpaceWarningThreshold(double diskSpaceWarningThreshold) {
        this.diskSpaceWarningThreshold = diskSpaceWarningThreshold;
    }

    public boolean isReadOnly() {
        return this.status == NodeStatus.ReadOnly;
    }

    public NodeStatus getNodeStatus() {
        return this.status;
    }

    public void setNodeStatusToShutdown() {
        logger.info("System will reject write operations when shutting down.");
        this.status = NodeStatus.ReadOnly;
    }

    public void setNodeStatus(NodeStatus newStatus) {
        logger.info("Set system mode from {} to {}.", (Object)this.status, (Object)newStatus);
        this.status = newStatus;
        switch (newStatus) {
            case ReadOnly: {
                logger.error("Change system status to ReadOnly! Only query statements are permitted!", (Throwable)new RuntimeException("System mode is set to READ_ONLY"));
                break;
            }
            case Removing: {
                logger.info("Change system status to Removing! The current Node is being removed from cluster!");
            }
        }
    }

    public String getStatusReason() {
        return this.statusReason;
    }

    public void setStatusReason(String statusReason) {
        this.statusReason = statusReason;
    }
}

