/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.windowing.runtime;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.IoTThreadFactory;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.rescon.AbstractPoolManager;
import org.apache.iotdb.db.utils.windowing.runtime.WindowEvaluationTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowEvaluationTaskPoolManager
extends AbstractPoolManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(WindowEvaluationTaskPoolManager.class);

    private WindowEvaluationTaskPoolManager() {
        int nThreads = IoTDBDescriptor.getInstance().getConfig().getConcurrentWindowEvaluationThread();
        LOGGER.info("WindowEvaluationTaskPoolManager is initializing, thread number: {}", (Object)nThreads);
        this.pool = new ThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(IoTDBDescriptor.getInstance().getConfig().getMaxPendingWindowEvaluationTasks()), (ThreadFactory)new IoTThreadFactory(ThreadName.WINDOW_EVALUATION_SERVICE.getName()));
    }

    public void submit(WindowEvaluationTask task) {
        try {
            super.submit((Runnable)((Object)task));
        }
        catch (RejectedExecutionException e) {
            task.onRejection();
        }
    }

    @Override
    public Logger getLogger() {
        return LOGGER;
    }

    @Override
    public String getName() {
        return "window evaluation task";
    }

    @Override
    public void start() {
        if (this.pool != null) {
            return;
        }
        this.pool = IoTDBThreadPoolFactory.newFixedThreadPool((int)IoTDBDescriptor.getInstance().getConfig().getConcurrentWindowEvaluationThread(), (String)ThreadName.WINDOW_EVALUATION_SERVICE.getName());
    }

    public static WindowEvaluationTaskPoolManager getInstance() {
        return InstanceHolder.INSTANCE;
    }

    private static class InstanceHolder {
        private static final WindowEvaluationTaskPoolManager INSTANCE = new WindowEvaluationTaskPoolManager();

        private InstanceHolder() {
        }
    }
}

