/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.transformation.dag.column;

import org.apache.iotdb.db.mpp.transformation.dag.column.ColumnCache;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.type.Type;
import org.apache.iotdb.tsfile.read.common.type.TypeEnum;

public abstract class ColumnTransformer {
    protected final Type returnType;
    protected final ColumnCache columnCache;
    protected int referenceCount;

    public ColumnTransformer(Type returnType) {
        this.returnType = returnType;
        this.columnCache = new ColumnCache();
        this.referenceCount = 0;
    }

    public void tryEvaluate() {
        if (!this.columnCache.hasCached()) {
            this.evaluate();
        }
    }

    public Column getColumn() {
        return this.columnCache.getColumn();
    }

    public void addReferenceCount() {
        ++this.referenceCount;
    }

    public void initializeColumnCache(Column column) {
        this.columnCache.cacheColumn(column, this.referenceCount);
    }

    public int getColumnCachePositionCount() {
        return this.columnCache.getPositionCount();
    }

    public Type getType() {
        return this.returnType;
    }

    public boolean isReturnTypeNumeric() {
        TypeEnum typeEnum = this.returnType.getTypeEnum();
        return typeEnum.equals((Object)TypeEnum.INT32) || typeEnum.equals((Object)TypeEnum.INT64) || typeEnum.equals((Object)TypeEnum.FLOAT) || typeEnum.equals((Object)TypeEnum.DOUBLE);
    }

    protected abstract void evaluate();

    protected abstract void checkType();

    public void close() {
    }
}

