/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.statement.crud;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.mpp.plan.constant.StatementType;
import org.apache.iotdb.db.mpp.plan.statement.Statement;
import org.apache.iotdb.db.mpp.plan.statement.StatementVisitor;

public class LoadTsFileStatement
extends Statement {
    private File file;
    private int sgLevel;
    private boolean verifySchema;
    private boolean deleteAfterLoad;
    private boolean autoCreateSchema;
    private List<File> tsFiles;
    private List<TsFileResource> resources;

    public LoadTsFileStatement(String filePath) throws FileNotFoundException {
        this.file = new File(filePath);
        this.sgLevel = IoTDBDescriptor.getInstance().getConfig().getDefaultStorageGroupLevel();
        this.verifySchema = true;
        this.deleteAfterLoad = true;
        this.autoCreateSchema = IoTDBDescriptor.getInstance().getConfig().isAutoCreateSchemaEnabled();
        this.tsFiles = new ArrayList<File>();
        this.resources = new ArrayList<TsFileResource>();
        this.statementType = StatementType.MULTI_BATCH_INSERT;
        if (this.file.isFile()) {
            this.tsFiles.add(this.file);
        } else {
            if (this.file.listFiles() == null) {
                throw new FileNotFoundException("Can not find %s on this machine, notice that load can only handle files on this machine.");
            }
            this.findAllTsFile(this.file);
        }
        this.sortTsFiles(this.tsFiles);
    }

    private void findAllTsFile(File file) {
        for (File nowFile : file.listFiles()) {
            if (nowFile.getName().endsWith(".tsfile")) {
                this.tsFiles.add(nowFile);
                continue;
            }
            if (!nowFile.isDirectory()) continue;
            this.findAllTsFile(nowFile);
        }
    }

    private void sortTsFiles(List<File> files) {
        files.sort((o1, o2) -> {
            String file1Name = o1.getName();
            String file2Name = o2.getName();
            try {
                return TsFileResource.checkAndCompareFileName(file1Name, file2Name);
            }
            catch (IOException e) {
                return file1Name.compareTo(file2Name);
            }
        });
    }

    public void setDeleteAfterLoad(boolean deleteAfterLoad) {
        this.deleteAfterLoad = deleteAfterLoad;
    }

    public void setSgLevel(int sgLevel) {
        this.sgLevel = sgLevel;
    }

    public void setVerifySchema(boolean verifySchema) {
        this.verifySchema = verifySchema;
    }

    public boolean isVerifySchema() {
        return this.verifySchema;
    }

    public boolean isDeleteAfterLoad() {
        return this.deleteAfterLoad;
    }

    public boolean isAutoCreateSchema() {
        return this.autoCreateSchema;
    }

    public int getSgLevel() {
        return this.sgLevel;
    }

    public List<File> getTsFiles() {
        return this.tsFiles;
    }

    public void addTsFileResource(TsFileResource resource) {
        this.resources.add(resource);
    }

    public List<TsFileResource> getResources() {
        return this.resources;
    }

    @Override
    public List<? extends PartialPath> getPaths() {
        return Collections.emptyList();
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitLoadFile(this, context);
    }

    public String toString() {
        return "LoadTsFileStatement{file=" + this.file + ", deleteAfterLoad=" + this.deleteAfterLoad + ", sgLevel=" + this.sgLevel + ", verifySchema=" + this.verifySchema + ", tsFiles Size=" + this.tsFiles.size() + '}';
    }
}

